/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.exception;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.cil.CilException;
import oracle.bpm.lang.DefaultException;
import oracle.bpm.lang.Platform;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.StackTrace;
import org.jetbrains.annotations.NotNull;

public class ProjectException
extends DefaultException {
    private final Map<ProjectObjectType, String> details = new HashMap<ProjectObjectType, String>();
    private ProjectObject projectObject;
    private String projectObjectPart = "part.context";
    private static final long serialVersionUID = 5041006509605552539L;
    public static final String DETAILS = "project.object.details";
    public static final String PART_KEY = "project.object.details.part";
    public static final String PART_PROPERTIES = "part.properties";
    public static final String PART_CONTEXT = "part.context";

    public ProjectException(ProjectObject projectObject) {
        this.setProjectObject(projectObject);
    }

    public ProjectException(ProjectObject projectObject, Msg msg) {
        super(msg);
        this.setProjectObject(projectObject);
    }

    public ProjectException(ProjectObject projectObject, Msg msgKey, Throwable cause) {
        super(msgKey == null ? CoreMsg.ERROR_MSG(cause.getMessage()) : msgKey, cause);
        this.setProjectObject(projectObject);
    }

    public static ProjectException wrapException(ProjectObject p, Msg msg, Throwable cause) {
        return new ProjectException(p, msg, cause);
    }

    @Deprecated
    public static ProjectException wrap(Throwable cause) {
        return ProjectException.wrap(null, cause);
    }

    public static ProjectException wrap(ProjectObject project, Throwable cause) {
        ProjectException result;
        if (cause instanceof ProjectException) {
            result = (ProjectException)cause;
        } else {
            result = new ProjectException(project, ProjectModelMsg.PRP_00003(cause.getMessage()), cause);
            if (cause instanceof CilException) {
                CilException cil = (CilException)cause;
                Map<ProjectObjectType, String> details = ProjectException.getDetails(cil.getMember());
                result.details.putAll(details);
            }
        }
        return result;
    }

    @NotNull
    public static ProjectException wrap(@NotNull ProjectObject project, @NotNull Msg msg) {
        return new ProjectException(project, msg);
    }

    public static ProjectException wrap(ProjectObject project, Msg msg, Throwable cause) {
        ProjectException projectException = ProjectException.wrap(project, cause);
        projectException.setKey(msg);
        return projectException;
    }

    public static String getProjectObjectPart(TypeDescription type) {
        String part = null;
        if (type.isMember()) {
            part = (String)type.asMethod().getTransientProperty(PART_KEY);
        } else if (type.isObject()) {
            part = (String)type.asObject().getTransientProperty(PART_KEY);
        }
        return part;
    }

    public static Map<ProjectObjectType, String> getDetails(TypeDescription type) {
        Map<ProjectObjectType, String> details = ProjectException.getDetailsIfPresent(type);
        details = details == null ? Collections.emptyMap() : Collections.unmodifiableMap(details);
        return details;
    }

    public static void addDetail(TypeDescription type, ProjectObject projectObject) {
        ProjectException.addDetail(type, projectObject.getProjectObjectType(), projectObject.getId());
        ProjectObject parent = projectObject.getParentObject();
        if (parent != null) {
            ProjectException.addDetail(type, parent);
        }
    }

    public static void addDetail(TypeDescription type, ProjectObjectType key, String value) {
        Map<ProjectObjectType, String> details = ProjectException.getDetailsIfPresent(type);
        if (details == null) {
            details = new HashMap<ProjectObjectType, String>();
            if (type != null) {
                if (type.isMember()) {
                    type.asMethod().setTransientProperty(DETAILS, details);
                } else if (type.isObject()) {
                    type.asObject().setTransientProperty(DETAILS, details);
                }
            }
        }
        details.put(key, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectException that = (ProjectException)o;
        if (!((Object)this.details).equals(that.details)) {
            return false;
        }
        if (!this.projectObject.equals(that.projectObject)) {
            return false;
        }
        return this.projectObjectPart.equals(that.projectObjectPart);
    }

    public int hashCode() {
        int result = ((Object)this.details).hashCode();
        result = 31 * result + this.projectObject.hashCode();
        result = 31 * result + this.projectObjectPart.hashCode();
        return result;
    }

    public void setProjectObjectPart(String projectObjectPart) {
        this.projectObjectPart = projectObjectPart;
    }

    public String getProjectObjectPart() {
        return this.projectObjectPart;
    }

    public Msg getMsg() {
        return this.getKey();
    }

    public ProjectObject getProjectObject() {
        return this.projectObject;
    }

    public Map<ProjectObjectType, String> getDetails() {
        return this.details;
    }

    public void addDetail(ProjectObjectType projectObjectType, String value) {
        this.getDetails().put(projectObjectType, value);
    }

    private static Map<ProjectObjectType, String> getDetailsIfPresent(TypeDescription type) {
        HashMap details = null;
        if (type != null) {
            if (type.isMember()) {
                details = type.getParent() != null ? ProjectException.getDetailsIfPresent(type.getParent()) : null;
                Map memberDetails = (Map)type.asMethod().getTransientProperty(DETAILS);
                if (details == null) {
                    details = memberDetails;
                } else if (memberDetails != null) {
                    details = new HashMap(details);
                    details.putAll(memberDetails);
                }
            } else if (type.isObject()) {
                details = (HashMap)type.asObject().getTransientProperty(DETAILS);
            }
        }
        return details;
    }

    private void setProjectObject(ProjectObject projectObject) {
        this.projectObject = projectObject;
        if (projectObject != null) {
            this.getDetails().put(projectObject.getProjectObjectType(), projectObject.getId());
            for (ProjectObject current = projectObject; current != null; current = current.getParentObject()) {
                this.getDetails().put(current.getProjectObjectType(), current.getId());
            }
        } else {
            String stackTrace = StackTrace.getStackTrace(1, Integer.MAX_VALUE);
            Throwable cause = this.getCause() != null ? this.getCause() : this;
            Platform.getInternalReportingService().reportIssue(cause, "Project Exception was created without a project object!!\nCause:" + stackTrace);
        }
    }
}

