/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.catalog;

import java.util.Comparator;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.CollectionTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.model.DefaultProjectObject;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.UnknownType;
import org.jetbrains.annotations.NotNull;

public interface CatalogType
extends ProjectObjectContainer {
    @Override
    public String getName();

    public boolean isMember();

    public boolean isAbstract();

    public boolean isString();

    public boolean isBoolean();

    public boolean isInt();

    public boolean isReal();

    public boolean isDecimal();

    public boolean isTime();

    public boolean isArray();

    public boolean isVoid();

    public boolean isAny();

    public boolean isNull();

    public boolean isObject();

    public boolean isCollection();

    public boolean isBinary();

    public boolean isHidden();

    public boolean isAssignableFrom(CatalogType var1);

    public boolean isUnknown();

    public CatalogType getIndexType();

    public CatalogType getElementType();

    public CatalogMember asMember();

    public CatalogObject asObject();

    public TypeDescription getDelegate();

    public TypeRef getDynamicRef();

    public boolean equality(CatalogType var1);

    public boolean equality(TypeDescription var1);

    public int getLength();

    public int getScale();

    public String getText();

    public int getKind();

    public boolean isPredefined();

    public boolean isException();

    public boolean isNumber();

    public boolean equivalent(CatalogType var1);

    public boolean isPrimitive();

    public boolean isOrdered();

    public void setElementType(CatalogType var1);

    public void setIndexType(CatalogType var1);

    public void setOrdered(boolean var1);

    public CatalogType primitiveEquivalent(boolean var1);

    public static class Default {
        public static CatalogType get(TypeRef type) {
            return Default.asCatalogType(type.get());
        }

        public static CatalogType getNone() {
            return Default.asCatalogType(TypeFactory.getNone());
        }

        public static CatalogType getVoid() {
            return Default.asCatalogType(TypeFactory.getVoid());
        }

        public static CatalogType getNull() {
            return Default.asCatalogType(TypeFactory.getNull());
        }

        public static CatalogType getBool() {
            return Default.asCatalogType(TypeFactory.getBool());
        }

        public static CatalogType getPrimitiveBool() {
            return Default.asCatalogType(TypeFactory.getPrimitiveBool());
        }

        public static CatalogType getInt() {
            return Default.asCatalogType(TypeFactory.getInt());
        }

        public static CatalogType getInt(int len) {
            return Default.asCatalogType(TypeFactory.getInt(len));
        }

        public static CatalogType getPrimitiveInt(int len) {
            return Default.asCatalogType(TypeFactory.getPrimitiveInt(len));
        }

        public static CatalogType getDecimal() {
            return Default.asCatalogType(TypeFactory.getDecimal());
        }

        public static CatalogType getDecimal(int length, int scale) {
            return Default.asCatalogType(TypeFactory.getDecimal(length, scale));
        }

        public static CatalogType getReal() {
            return Default.asCatalogType(TypeFactory.getReal());
        }

        public static CatalogType getReal(int len) {
            return Default.asCatalogType(TypeFactory.getReal(len));
        }

        public static CatalogType getPrimitiveReal(int len) {
            return Default.asCatalogType(TypeFactory.getPrimitiveReal(len));
        }

        public static CatalogType getString() {
            return Default.asCatalogType(TypeFactory.getString());
        }

        public static CatalogType getString(int length) {
            return Default.asCatalogType(TypeFactory.getString(length));
        }

        public static CatalogType getPrimitiveChar() {
            return Default.asCatalogType(TypeFactory.getPrimitiveChar());
        }

        public static CatalogType getTime() {
            return Default.asCatalogType(TypeFactory.getTime());
        }

        public static CatalogType getInterval() {
            return Default.asCatalogType(TypeFactory.getInterval());
        }

        public static CatalogType getBinary() {
            return Default.asCatalogType(TypeFactory.getBinary());
        }

        public static CatalogType getAny() {
            return Default.asCatalogType(TypeFactory.getAny());
        }

        public static CatalogType getArray(CatalogType elementType) {
            return Default.asCatalogType(TypeFactory.getArray(elementType.getDelegate()));
        }

        public static CatalogType getPrimitiveArray(CatalogType elementType) {
            return Default.asCatalogType(TypeFactory.getPrimitiveArray(elementType.getDelegate()));
        }

        public static CatalogType getIterator(CatalogType elementType) {
            return Default.asCatalogType(TypeFactory.getIterator(elementType.getDelegate()));
        }

        public static CatalogType getMap(CatalogType elementType, CatalogType indexType) {
            return Default.asCatalogType(TypeFactory.getMap(elementType.getDelegate(), indexType.getDelegate()));
        }

        public static CatalogType getSortedMap(CatalogType elementType, CatalogType indexType) {
            return Default.asCatalogType(TypeFactory.getSortedMap(elementType.getDelegate(), indexType.getDelegate()));
        }

        public static CatalogType getSet(CatalogType elementType) {
            return Default.asCatalogType(TypeFactory.getSet(elementType.getDelegate()));
        }

        public static CatalogType getUnknown(String name, ComponentCatalog catalog) {
            return Default.asCatalogType(UnknownType.create(name, catalog));
        }

        private static CatalogType asCatalogType(TypeDescription type) {
            return new BaseCatalogType(type);
        }
    }

    public static class BaseCatalogType
    extends DefaultProjectObject
    implements CatalogType {
        private TypeDescription type;

        public BaseCatalogType(TypeDescription type) {
            this.type = type;
        }

        @Override
        public String getId() {
            return this.type.getName();
        }

        @Override
        @Deprecated
        @NotNull
        public ProjectObjectType getProjectObjectType() {
            return null;
        }

        @Override
        public Project getProject() {
            return null;
        }

        @Override
        public Path getPath() {
            return null;
        }

        @Override
        public ProjectObject getParentObject() {
            return null;
        }

        @Override
        public void replace(ProjectObject newObject) throws ProjectException {
        }

        @Override
        public Class getRawClass() {
            return CatalogType.class;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public void visit(ProjectVisitor visitor) throws ProjectException {
        }

        @Override
        public String getName() {
            return this.type.getName();
        }

        @Override
        public int getPosition() {
            return -1;
        }

        @Override
        public CatalogType getIndexType() {
            return Default.asCatalogType(this.type.getIndexType());
        }

        @Override
        public CatalogType getElementType() {
            return Default.asCatalogType(this.type.getElementType());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BaseCatalogType)) {
                return false;
            }
            BaseCatalogType that = (BaseCatalogType)o;
            return !(this.type == null ? that.type != null : !this.type.equals(that.type));
        }

        public int hashCode() {
            return this.type != null ? this.type.hashCode() : 0;
        }

        @Override
        public boolean isMember() {
            return this.type.isMember();
        }

        @Override
        public boolean isAbstract() {
            return this.type.isAbstract();
        }

        @Override
        public boolean isString() {
            return this.type.isString();
        }

        @Override
        public boolean isBoolean() {
            return this.type.isBool();
        }

        @Override
        public boolean isInt() {
            return this.type.isInt();
        }

        @Override
        public boolean isReal() {
            return this.type.isReal();
        }

        @Override
        public boolean isDecimal() {
            return this.type.isDecimal();
        }

        @Override
        public boolean isTime() {
            return this.type.isTime();
        }

        @Override
        public boolean isArray() {
            return this.type.isArray();
        }

        @Override
        public boolean isVoid() {
            return this.type.isVoid();
        }

        @Override
        public boolean isAny() {
            return this.type.isAny();
        }

        @Override
        public boolean isNull() {
            return this.type.isNull();
        }

        @Override
        public boolean isObject() {
            return this.type.isObject();
        }

        @Override
        public boolean isCollection() {
            return this.type.isCollection();
        }

        @Override
        public boolean isBinary() {
            return this.type.isBinary();
        }

        @Override
        public boolean isHidden() {
            return Modifier.isHidden(this.type.getModifiers());
        }

        @Override
        public boolean isUnknown() {
            return this.type.isUnknown();
        }

        @Override
        public TypeDescription getDelegate() {
            return this.type;
        }

        @Override
        public boolean equality(CatalogType type) {
            return this.type.equality(type.getDelegate());
        }

        @Override
        public boolean equality(TypeDescription type) {
            return this.type.equality(type);
        }

        @Override
        public int getLength() {
            return this.type.getLength();
        }

        @Override
        public int getScale() {
            return this.type.getScale();
        }

        @Override
        public String getText() {
            return this.type.getText();
        }

        @Override
        public int getKind() {
            return this.type.getKind();
        }

        @Override
        public boolean isPredefined() {
            return this.type.isPredefined();
        }

        @Override
        public boolean isException() {
            return Modifier.isException(this.type.getModifiers());
        }

        @Override
        public boolean isNumber() {
            return this.type.isNumber();
        }

        @Override
        public boolean equivalent(CatalogType type) {
            return this.type.equivalent(type.getDelegate());
        }

        @Override
        public boolean isPrimitive() {
            return this.type.isPrimitive();
        }

        @Override
        public boolean isOrdered() {
            return this.type.isOrdered();
        }

        @Override
        public void setElementType(CatalogType type) {
            this.type.asObject().setElementType(type.getDelegate());
        }

        @Override
        public void setIndexType(CatalogType type) {
            ((CollectionTypeDescription)this.type).setIndexType(type.getDelegate());
        }

        @Override
        public void setOrdered(boolean ordered) {
        }

        @Override
        public CatalogType primitiveEquivalent(boolean primitive) {
            TypeDescription result = this.type.primitiveEquivalent(primitive);
            if (result != this.type) {
                return Default.get(result);
            }
            return this;
        }

        @Override
        public TypeRef getDynamicRef() {
            return this.type.getRef();
        }

        @Override
        public boolean isAssignableFrom(CatalogType type) {
            return this.getDelegate().isAssignableFrom(type.getDelegate());
        }

        @Override
        public CatalogMember asMember() {
            return null;
        }

        @Override
        public CatalogObject asObject() {
            return null;
        }

        @Override
        public Comparator<ProjectObject> getChildComparator() {
            return null;
        }

        @Override
        public boolean contains(ProjectObject child) {
            return false;
        }

        @Override
        public <T extends ProjectObject> T findChild(Class<T> type, String id) {
            return null;
        }

        @Override
        public <E extends ProjectObject> E findDescendant(Class<E> type, String id) {
            return null;
        }

        @Override
        public <E extends ProjectObject> Sequence<E> getDescendants(Class<E> type) {
            return null;
        }

        @Override
        @NotNull
        public <E extends ProjectObject> Sequence<E> getChildrenByType(Class<E> type) {
            return CollectionUtils.emptySequence();
        }

        @Override
        @NotNull
        public Sequence<? extends ProjectObject> getChildren() {
            return null;
        }

        @Override
        public void addChild(ProjectObject child) throws ProjectException {
        }

        @Override
        public void addChild(ProjectObject child, int position) throws ProjectException {
        }

        @Override
        public void removeChild(ProjectObject child) throws ProjectException {
        }

        @Override
        public void moveChild(ProjectObject child, int newPosition) throws ProjectException {
        }

        @Override
        public void replaceChild(ProjectObject oldProjectObject, ProjectObject newProjectObject) throws ProjectException {
        }

        @Override
        public void clear() {
        }

        @Override
        public int indexOf(ProjectObject projectObject) {
            return -1;
        }

        @Override
        public void setId(String id) {
        }

        public void setModified(boolean value) {
        }

        @Override
        public void setReadOnly(boolean value) {
        }

        @Override
        public void setDefault(boolean isDefault) {
        }

        @Override
        public void delete() throws ProjectException {
        }
    }
}

