/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.TimeZone;
import oracle.bpm.lang.Day;
import oracle.bpm.lang.FormatException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Month;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.Week;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.DailySchedule;
import oracle.bpm.project.model.MonthlySchedule;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.Schedule;
import oracle.bpm.project.model.ScheduleEntryField;
import oracle.bpm.project.model.ScheduleType;
import oracle.bpm.project.model.WeeklySchedule;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.xml.XmlTag;
import oracle.bpm.xml.XmlWriter;
import org.xml.sax.Attributes;

public abstract class ScheduleEntry
implements Comparable,
Serializable {
    public boolean runsOnHolidays;
    public Interval when;
    static final long serialVersionUID = 2056267213683991600L;
    protected static final ScheduleEntryField[] fields = new ScheduleEntryField[]{ScheduleEntryField.WHEN, ScheduleEntryField.RUNS_ON_HOLIDAYS};
    static final long serialCheck = 973290373506256165L;

    protected ScheduleEntry(Interval when, boolean runsOnHolidays) {
        this.setWhen(when);
        this.runsOnHolidays = runsOnHolidays;
    }

    public abstract ScheduleType getType();

    public abstract Time nextDueTime(Time var1);

    public abstract void visit(ProjectVisitor var1) throws ProjectException;

    public static ScheduleEntry create(ScheduleType type) {
        return type.createSchedule();
    }

    public static ScheduleEntry createDaily(Interval when, boolean runsOnHoliday) {
        return new DailySchedule(when, runsOnHoliday);
    }

    public static ScheduleEntry createMonthly(Month month, int dayOfMonth, Interval when, boolean runsOnHolidays) {
        return new MonthlySchedule(month, dayOfMonth, when, runsOnHolidays);
    }

    public static ScheduleEntry createMonthly(Month month, Week week, Day dayOfWeek, Interval when, boolean runsOnHolidays) {
        return new MonthlySchedule(month, week, dayOfWeek, when, runsOnHolidays);
    }

    public static ScheduleEntry createWeekly(Day dayOfWeek, Interval when, boolean runsOnHoliday) {
        return new WeeklySchedule(dayOfWeek, when, runsOnHoliday);
    }

    public static int compare(ScheduleEntry a, ScheduleEntry b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        int result = a.getType().compareTo(b.getType());
        if (result == 0) {
            result = a.compareFields(b);
        }
        return result;
    }

    public static boolean equals(ScheduleEntry a, ScheduleEntry b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null || a.getType() != b.getType()) {
            return false;
        }
        return a.equalsFields(b);
    }

    public static ScheduleEntry deprecatedCreate(Attributes amap) {
        XmlTag entry = new XmlTag();
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            if (attname.equals("dayOfWeek")) {
                entry.putAttribute(ScheduleEntryField.DAY.getAttributeName(), Day.compatibleValueOf(value));
                continue;
            }
            if (attname.equals("type")) {
                entry.setName(ScheduleType.compatibleValueOf(value).toString());
                continue;
            }
            if (attname.equals("runsOnHoliday")) {
                entry.putAttribute(ScheduleEntryField.RUNS_ON_HOLIDAYS.getAttributeName(), value);
                continue;
            }
            if (attname.equals("month")) {
                Month m = Month.compatibleValueOf(value);
                entry.putAttribute(ScheduleEntryField.MONTH.getAttributeName(), m != null ? m.toString() : CoreMsg.ALL.getString());
                continue;
            }
            if (attname.equals("time")) {
                Time time = Time.valueOf(Long.parseLong(value) * 1000L);
                entry.putAttribute(ScheduleEntryField.WHEN.getAttributeName(), time.getHour() + time.getAMPM() * 12 + ":" + time.getMinute());
                continue;
            }
            if (attname.equals("dayType")) {
                Week week = Week.compatibleValueOf(value);
                if (week == null) continue;
                entry.putAttribute(ScheduleEntryField.WEEK.getAttributeName(), week);
                continue;
            }
            if (!attname.equals("dayOfMonth")) continue;
            entry.putAttribute(ScheduleEntryField.DAY.getAttributeName(), value);
        }
        return ScheduleEntry.create(entry);
    }

    public static void main(String[] args) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(args[0]));
        Schedule handler = new Schedule();
        while ((line = reader.readLine()) != null) {
            if (line.equals("")) continue;
            handler.add(ScheduleEntry.valueOf(line));
        }
        System.out.println("handler = \n" + handler.getString());
        System.out.println("handler.nextDueTime() = " + handler.nextDueTime(TimeZone.getDefault()));
    }

    public static ScheduleEntry valueOf(String schedule) {
        XmlTag tag = XmlTag.createXmlTag(schedule);
        return ScheduleEntry.create(tag);
    }

    public static ScheduleEntry create(XmlTag tag) {
        ScheduleType scheduleType = ScheduleType.valueOf(tag.getName().toUpperCase());
        if (scheduleType == null) {
            throw new FormatException(CoreMsg.INVALID_SCHEDULE_TYPE(tag.getName()));
        }
        ScheduleEntry result = scheduleType.createSchedule();
        result.parse(tag);
        return result;
    }

    public void setRunsOnHolidays(boolean runsOnHolidays) {
        this.runsOnHolidays = runsOnHolidays;
    }

    public boolean getRunsOnHolidays() {
        return this.runsOnHolidays;
    }

    public void setWhen(Interval when) {
        this.when = when;
        this.ensureValidRangeInterval();
    }

    public Interval getWhen() {
        this.ensureValidRangeInterval();
        return this.when;
    }

    public int compareTo(Object that) {
        return ScheduleEntry.compare(this, (ScheduleEntry)that);
    }

    public boolean equals(Object that) {
        return that instanceof ScheduleEntry && ScheduleEntry.equals(this, (ScheduleEntry)that);
    }

    public int hashCode() {
        int result = this.when != null ? this.when.hashCode() : 0;
        return 29 * result + (this.runsOnHolidays ? 1 : 0);
    }

    public ScheduleEntryField getField(int i) {
        return fields[i];
    }

    public Class getFieldClass(int i) {
        return i == 0 ? Interval.class : (i == 1 ? Boolean.class : null);
    }

    public int getFieldCount() {
        return fields.length;
    }

    public void setFieldValue(int i, Object o) {
        if (i == 0) {
            this.setWhen((Interval)o);
        } else if (i == 1) {
            this.runsOnHolidays = (Boolean)o;
        }
    }

    public Object getFieldValue(int i) {
        if (i == 0) {
            return this.getWhen();
        }
        if (i == 1) {
            return this.runsOnHolidays;
        }
        return null;
    }

    public void revalidate() {
    }

    public void writeXml(XmlWriter xml) throws IOException {
        ScheduleType type = this.getType();
        xml.startElement(type.toString().toLowerCase());
        this.writeFieldsToXml(xml);
        xml.endElement();
    }

    protected int compareFields(ScheduleEntry that) {
        int result = Interval.compare(this.when, that.when);
        if (result == 0 && this.runsOnHolidays != that.runsOnHolidays) {
            result = this.runsOnHolidays ? 1 : -1;
        }
        return result;
    }

    protected boolean equalsFields(ScheduleEntry that) {
        return this.runsOnHolidays == that.runsOnHolidays && Interval.equals(this.when, that.when);
    }

    protected Time establishWhen(Time now) {
        return Time.valueOf(now.getYear(), now.getMonth(), now.getDayOfMonth(), this.getWhen().getHoursOnly() % 24, this.getWhen().getMinutesOnly(), this.getWhen().getSecondsOnly(), now.getMicroSecond());
    }

    protected void parse(XmlTag tag) {
        this.when = tag.getInterval(ScheduleEntryField.WHEN.getAttributeName());
        this.runsOnHolidays = tag.getBoolean(ScheduleEntryField.RUNS_ON_HOLIDAYS.getAttributeName());
    }

    protected void writeFieldsToXml(XmlWriter xml) throws IOException {
        xml.printAttribute(ScheduleEntryField.RUNS_ON_HOLIDAYS.getAttributeName(), this.runsOnHolidays);
        xml.printAttribute(ScheduleEntryField.WHEN.getAttributeName(), this.when);
    }

    private void ensureValidRangeInterval() {
        if (this.when.getMinutes() < 0) {
            this.when = this.when.addHours(24L);
        }
        while (this.when.getHours() >= 24) {
            this.when = this.when.addHours(-24L);
        }
    }
}

