/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.ProjectRepositoryMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.log.Log;
import oracle.bpm.observers.Observable;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.RepositoryChangeEvent;
import oracle.bpm.project.model.RepositoryServiceListener;

public class RepositoryService
implements Observable<RepositoryServiceListener> {
    private ProjectRepository defaultRepository;
    private Collection<RepositoryServiceListener> listeners = new ArrayList<RepositoryServiceListener>();
    private Map<ProjectRepository, String> repositories = new WeakHashMap<ProjectRepository, String>();
    private static RepositoryService repositoryService;

    private RepositoryService() {
    }

    public static synchronized RepositoryService getInstance() {
        if (repositoryService == null) {
            repositoryService = new RepositoryService();
        }
        return repositoryService;
    }

    public static ProjectRepository createNewRepository(String type) {
        ProjectRepository repository = null;
        ExtensionService service = Platform.getExtensionService();
        ArrayList availableTypes = new ArrayList();
        List<Extension<ProjectRepositoryMetadata>> extensions = service.getExtensionsByPoint(ProjectRepositoryMetadata.class);
        for (Extension<ProjectRepositoryMetadata> extension : extensions) {
            String repositoryType = extension.getMetadata().type();
            if (!repositoryType.equals(type)) continue;
            try {
                repository = extension.instantiateAs(ProjectRepository.class);
                break;
            }
            catch (InstantiationException e) {
                IllegalStateException iae = new IllegalStateException("Could not create repository with type " + type + ". Because: " + e);
                iae.initCause(e);
                throw iae;
            }
        }
        if (repository == null) {
            throw new IllegalArgumentException("Could not create repository with type " + type + ". Available repository types are: " + availableTypes);
        }
        return repository;
    }

    public static ProjectRepository createNewRepository(String type, boolean readOnly) {
        ProjectRepository repository = null;
        ExtensionService service = Platform.getExtensionService();
        for (Extension<ProjectRepositoryMetadata> extension : service.getExtensionsByPoint(ProjectRepositoryMetadata.class)) {
            if (!extension.getMetadata().type().equals(type)) continue;
            try {
                repository = extension.instantiateAs(ProjectRepository.class);
                break;
            }
            catch (InstantiationException e) {
                Log.logWarning(e);
            }
        }
        if (repository == null) {
            throw new IllegalArgumentException("Could not create repository with type " + type);
        }
        repository.setReadOnly(readOnly);
        return repository;
    }

    public ProjectRepository getActiveRepository() {
        return this.defaultRepository;
    }

    public void setActiveRepository(ProjectRepository repository) {
        RepositoryChangeEvent event = RepositoryChangeEvent.create(this.defaultRepository, repository);
        this.defaultRepository = repository;
        this.fireRepositoryChanged(event);
    }

    public void repositoryAdded(ProjectRepository repository) {
        this.repositories.put(repository, null);
    }

    public void repositoryRemoved(ProjectRepository repository) {
        if (this.defaultRepository == repository) {
            this.setActiveRepository(null);
        }
        this.repositories.remove(repository);
    }

    @Override
    public void addObserver(RepositoryServiceListener observer) {
        this.listeners.add(observer);
    }

    @Override
    public void removeObserver(RepositoryServiceListener observer) {
        this.listeners.remove(observer);
    }

    private void fireRepositoryChanged(RepositoryChangeEvent event) {
        for (RepositoryServiceListener listener : this.listeners) {
            listener.repositoryChanged(event);
        }
    }
}

