/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model;

import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;

public class ProjectUtils {
    public static boolean isActive(ProjectObject projectObject) {
        ProjectObject parentObject = projectObject.getParentObject();
        boolean result = false;
        if (parentObject != null && parentObject instanceof ProjectObjectContainer) {
            Sequence<? extends ProjectObject> collection = ((ProjectObjectContainer)parentObject).getChildren();
            result = collection != null && collection.contains(projectObject);
        }
        return result;
    }

    public static String getProjectName(ProjectObject projectObject) {
        return ProjectUtils.removeHashCode(projectObject.getProject().getName());
    }

    private static String removeHashCode(String name) {
        int index = name.indexOf(64);
        return index != -1 ? name.substring(0, index) : name;
    }
}

