/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.changeset;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.lang.Ref;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ModelChangeSet {
    private final Ref<Point> absolute;
    private final List<ModelChange> changeSet = new ArrayList<ModelChange>();
    private final List<ModelChangeSet> children = new ArrayList<ModelChangeSet>(3);
    @NonNls
    private static final String ADD = "A";
    @NonNls
    private static final String CHANGE = "C";
    @NonNls
    private static final String REMOVE = "R";

    public ModelChangeSet() {
        this.absolute = Ref.createRef(Point.ORIGIN);
    }

    public ModelChangeSet(@NotNull Ref<Point> absolute) {
        this.absolute = absolute;
    }

    public ModelChangeSet apply(@NotNull Process model) throws ProjectException {
        ModelChangeSet backup = new ModelChangeSet();
        for (ModelChangeSet child : this.children) {
            backup.add(child.apply(model));
        }
        for (ModelChange change : this.changeSet) {
            backup.add(change.apply(model));
        }
        return backup;
    }

    public void addRemoveLane(@NotNull Lane lane) {
        this.add(new RemoveLane(lane));
    }

    public void addChangeSubprocess(@NotNull Subprocess subprocess, @NotNull Point location, @NotNull Dimension size, @NotNull ModelChangeSet innerChanges) {
        this.add(innerChanges);
        innerChanges.updateInnerAbsoluteLocations(location.sub(size.getWidth() / 2, size.getHeight() / 2));
        this.add(new ChangeSubprocess(subprocess, location, size, this.absolute));
    }

    public void addChangeActivity(@NotNull FlowNode node, @NotNull Lane lane, @NotNull Point location) {
        if (node.getLane() != null && !node.getLane().equals(lane) || !node.getLocation().equals(location)) {
            this.add(new ChangeActivity(node, lane, location, this.absolute));
        }
    }

    public void addChangeLane(@NotNull Lane lane, int offset, int size) {
        if (lane.getOffset() != offset || lane.getSize() != size) {
            this.add(new ChangeLane(lane, offset, size));
        }
    }

    public void addChangeTransition(@NotNull SequenceFlow transition, @NotNull Point controlPoint) {
        if (!transition.getControlPoint().equals(controlPoint)) {
            this.add(new ChangeTransition(transition, controlPoint, this.absolute));
        }
    }

    public void addChangeMeasurement(@NotNull Measurement measurement, @NotNull Point location) {
        if (!measurement.getLocation().equals(location)) {
            this.add(new ChangeMeasurement(measurement, location, this.absolute));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Builder Structure \n").append("Children: ").append(this.children.size()).append("\nInner Changes: ").append(this.changeSet.size()).append("\n");
        builder.append("CHANGE SET\n");
        for (ModelChange change : this.changeSet) {
            builder.append(change);
            builder.append('\n');
        }
        builder.append("CHILDREN\n");
        for (ModelChangeSet child : this.children) {
            builder.append(child);
            builder.append('\n');
        }
        return builder.toString();
    }

    private void add(ModelChange change) {
        this.changeSet.add(change);
    }

    private void add(ModelChangeSet changes) {
        this.children.add(changes);
    }

    private void updateInnerAbsoluteLocations(@NotNull Point point) {
        this.absolute.set(this.absolute.get().add(point));
        for (ModelChangeSet child : this.children) {
            child.updateInnerAbsoluteLocations(point);
        }
    }

    private static class RemoveLane
    extends AddLane {
        private RemoveLane(@NotNull Lane lane) {
            super(lane);
        }

        @Override
        public String toString() {
            return this.changeString(ModelChangeSet.REMOVE);
        }

        @Override
        protected ModelChange apply(@NotNull Process model) throws ProjectException {
            AddLane backup = new AddLane(this.lane);
            model.removeChild(this.lane);
            return backup;
        }
    }

    private static class ChangeTransition
    extends AbsoluteModelChange {
        @NotNull
        private Point controlPoint;
        @NotNull
        private SequenceFlow transition;

        private ChangeTransition(@NotNull SequenceFlow transition, @NotNull Point controlPoint, @NotNull Ref<Point> absolute) {
            super(ProjectObjectType.TRANSITION, absolute);
            this.transition = transition;
            this.controlPoint = controlPoint;
        }

        public String toString() {
            return this.changeString(this.transition, ChangeTransition.string(this.transition.getControlPoint()), ChangeTransition.string(!this.controlPoint.equals(SequenceFlow.NULL_CONTROL_POINT) ? this.relToAbs(this.controlPoint) : this.controlPoint));
        }

        @Override
        protected ModelChange apply(@NotNull Process model) throws ProjectException {
            ChangeTransition backup = new ChangeTransition(this.transition, this.transition.getControlPoint(), Ref.createRef(Point.ORIGIN));
            this.transition.setRoutingData(this.transition.getRoutingMode(), !this.controlPoint.equals(SequenceFlow.NULL_CONTROL_POINT) ? this.relToAbs(this.controlPoint) : this.controlPoint);
            return backup;
        }

        private static String string(Point cp) {
            return cp.equals(SequenceFlow.NULL_CONTROL_POINT) ? "[]" : cp.toString();
        }
    }

    private static class ChangeSubprocess
    extends AbsoluteModelChange {
        @NotNull
        private final Point location;
        @NotNull
        private final Dimension size;
        @NotNull
        private final Subprocess subprocess;

        private ChangeSubprocess(@NotNull Subprocess subprocess, @NotNull Point location, @NotNull Dimension size, @NotNull Ref<Point> absolute) {
            super(ProjectObjectType.ACTIVITY, absolute);
            this.subprocess = subprocess;
            this.size = size;
            this.location = location;
        }

        public String toString() {
            return this.changeString(this.subprocess, ChangeSubprocess.string(this.subprocess.getLocation(), Dimension.valueOf(this.subprocess.getWidth(), this.subprocess.getHeight())), ChangeSubprocess.string(this.relToAbs(this.location), this.size));
        }

        @Override
        protected ModelChange apply(@NotNull Process model) throws ProjectException {
            ChangeSubprocess backup = new ChangeSubprocess(this.subprocess, this.subprocess.getLocation(), Dimension.valueOf(this.subprocess.getWidth(), this.subprocess.getHeight()), Ref.createRef(Point.ORIGIN));
            this.subprocess.setWidth(this.size.getWidth());
            this.subprocess.setHeight(this.size.getHeight());
            this.subprocess.setLocation(this.relToAbs(this.location));
            return backup;
        }

        private static String string(Point location, Dimension size) {
            return location + " with size " + size;
        }
    }

    private static class ChangeMeasurement
    extends AbsoluteModelChange {
        @NotNull
        private Point location;
        @NotNull
        private Measurement measurement;

        private ChangeMeasurement(@NotNull Measurement measurement, @NotNull Point location, @NotNull Ref<Point> absolute) {
            super(ProjectObjectType.MEASUREMENT, absolute);
            this.measurement = measurement;
            this.location = location;
        }

        public String toString() {
            return this.changeString(this.measurement, this.measurement.getLocation().toString(), this.relToAbs(this.location).toString());
        }

        @Override
        protected ModelChange apply(@NotNull Process process) throws ProjectException {
            ChangeMeasurement backup = new ChangeMeasurement(this.measurement, this.measurement.getLocation(), Ref.createRef(Point.ORIGIN));
            this.measurement.setLocation(this.relToAbs(this.location));
            return backup;
        }
    }

    private static class ChangeLane
    extends AddLane {
        private int offset;
        private int size;

        private ChangeLane(@NotNull Lane lane, int offset, int size) {
            super(lane);
            this.offset = offset;
            this.size = size;
        }

        @Override
        public String toString() {
            return this.changeString(this.lane, ChangeLane.string(this.lane.getOffset(), this.lane.getSize()), ChangeLane.string(this.offset, this.size));
        }

        @Override
        protected ModelChange apply(@NotNull Process model) throws ProjectException {
            ChangeLane backup = new ChangeLane(this.lane, this.lane.getOffset(), this.lane.getSize());
            Lane.Mutable l = this.lane.asMutable();
            l.setOffset(this.offset);
            l.setSize(this.size);
            return backup;
        }

        private static String string(int pos, int sz) {
            return new Point(pos, sz).toString();
        }
    }

    private static class ChangeActivity
    extends AbsoluteModelChange {
        @NotNull
        private Lane lane;
        @NotNull
        private Point location;
        @NotNull
        private FlowNode node;

        private ChangeActivity(@NotNull FlowNode node, @NotNull Lane lane, @NotNull Point location, @NotNull Ref<Point> absolute) {
            super(ProjectObjectType.ACTIVITY, absolute);
            this.node = node;
            this.lane = lane;
            this.location = location;
        }

        public String toString() {
            return this.changeString(this.node, ChangeActivity.string(this.node.getLane(), this.node.getLocation(), this.node.getBpmnType()), ChangeActivity.string(this.lane, this.relToAbs(this.location), this.node.getBpmnType()));
        }

        @Override
        protected ModelChange apply(@NotNull Process model) throws ProjectException {
            ChangeActivity backup = new ChangeActivity(this.node, this.node.getLane(), this.node.getLocation(), Ref.createRef(Point.ORIGIN));
            this.node.setLocation(this.relToAbs(this.location));
            return backup;
        }

        private static String string(Lane l, Point loc, BpmnType type) {
            return l.getId() + " " + loc + " for " + type;
        }
    }

    private static class AddLane
    extends ModelChange {
        protected Lane lane;

        private AddLane(@NotNull Lane lane) {
            super(ProjectObjectType.LANE);
            this.lane = lane;
        }

        public String toString() {
            return this.changeString(ModelChangeSet.ADD);
        }

        protected String changeString(String op) {
            return this.changeString(op, this.lane);
        }

        @Override
        protected ModelChange apply(@NotNull Process model) throws ProjectException {
            model.addChild(this.lane);
            return new RemoveLane(this.lane);
        }
    }

    private static abstract class ModelChange {
        ProjectObjectType type;

        public ModelChange(ProjectObjectType type) {
            this.type = type;
        }

        protected abstract ModelChange apply(@NotNull Process var1) throws ProjectException;

        protected String changeString(String op, ProjectObject obj) {
            return op + " " + (Object)((Object)this.type) + "(" + obj.getId() + ")";
        }

        protected String changeString(ProjectObject obj, String before, String after) {
            return this.changeString(ModelChangeSet.CHANGE, obj) + " " + before + " -> " + after;
        }
    }

    private static abstract class AbsoluteModelChange
    extends ModelChange {
        private final Ref<Point> absolute;

        public AbsoluteModelChange(@NotNull ProjectObjectType type, @NotNull Ref<Point> absolute) {
            super(type);
            this.absolute = absolute;
        }

        protected Point relToAbs(@NotNull Point relative) {
            return relative.add(this.absolute.get());
        }
    }
}

