/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.core.recognizer;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.EnumMap;
import java.util.Map;
import oracle.bpm.fusion.core.ProjectObjectNode;
import oracle.bpm.project.io.recognizer.FileInputSource;
import oracle.bpm.project.io.recognizer.ProjectRecognizer;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.NotRecognizableObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.UnknownProjectObject;
import oracle.bpm.project.model.deployment.DeploymentDescriptor;
import oracle.bpm.project.model.processes.BpelProcess;
import oracle.ide.model.Recognizer;

class ProjectRecognizerAdapter
extends Recognizer {
    private final ProjectRecognizer recognizer = ProjectRecognizer.getInstance();
    private final Map<ProjectObjectType, Class<ProjectObjectNode>> typeToNode = new EnumMap<ProjectObjectType, Class<ProjectObjectNode>>(ProjectObjectType.class);

    ProjectRecognizerAdapter() {
        this.initializeTypeToNodeMap();
    }

    public Class<ProjectObjectNode> recognize(URL url) {
        Class<ProjectObjectNode> classFromExtension = null;
        Class<? extends ProjectObject> poc = this.recognizeProjectObject(url);
        if (poc != null && !poc.equals(UnknownProjectObject.class)) {
            classFromExtension = ProjectObjectNode.class;
        }
        return classFromExtension;
    }

    public ProjectObjectNode create(URL url, Class nodeType) throws IllegalAccessException, InstantiationException {
        ProjectObjectNode node = null;
        if (this.recognize(url) != null) {
            node = new ProjectObjectNode(url);
        }
        return node;
    }

    public String[] getRecognizedExtensions() {
        return this.recognizer.getRecognizedExtensions();
    }

    private Class<? extends ProjectObject> recognizeProjectObject(URL url) {
        File file;
        try {
            file = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        FileInputSource inputSource = FileInputSource.create(file);
        Class<? extends ProjectObject> result = this.recognizer.recognize(inputSource);
        if (this.mustExclude(result)) {
            result = null;
        }
        return result;
    }

    private void initializeTypeToNodeMap() {
        this.typeToNode.put(ProjectObjectType.MODEL, ProjectObjectNode.class);
        this.typeToNode.put(ProjectObjectType.ORGANIZATION_ROLE, ProjectObjectNode.class);
    }

    private boolean mustExclude(Class cl) {
        return cl != null && (ProjectPreferences.class.isAssignableFrom(cl) || FolderContainer.class.isAssignableFrom(cl) || BpelProcess.class.isAssignableFrom(cl) || DeploymentDescriptor.class.isAssignableFrom(cl) || UnknownProjectObject.class.isAssignableFrom(cl) || NotRecognizableObject.class.isAssignableFrom(cl));
    }
}

