/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.core.recognizer;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import oracle.bpm.fusion.core.recognizer.ProjectRecognizerAdapter;
import oracle.bpm.util.LoggingUtils;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Recognizer;
import oracle.ide.model.Workspace;

public class FusionStudioRecognizer
extends Recognizer {
    private final ProjectRecognizerAdapter projectRecognizer = new ProjectRecognizerAdapter();
    private static FusionStudioRecognizer instance;

    private FusionStudioRecognizer() {
    }

    public static FusionStudioRecognizer getInstance() {
        if (instance == null) {
            instance = new FusionStudioRecognizer();
        }
        return instance;
    }

    public Class<? extends Node> recognize(URL url) {
        return this.projectRecognizer.recognize(url);
    }

    public Node create(URL url, Class type) throws IllegalAccessException, InstantiationException {
        if (url.getProtocol().equals("file")) {
            File file = new File(url.getPath());
            if (!file.exists()) {
                return null;
            }
            if (!this.isProjectOpen(url)) {
                LoggingUtils.assertLog("FusionStudioRecognizer.create()", "Project containing '" + url + "' is closed. Ignoring file.");
                return null;
            }
        }
        return this.projectRecognizer.create(url, type);
    }

    public String[] getRecognizedExtensions() {
        return this.projectRecognizer.getRecognizedExtensions();
    }

    private boolean isProjectOpen(URL path) {
        for (Workspace workspace : Ide.getWorkspaces().workspaces()) {
            Iterator it = workspace.getChildren();
            while (it.hasNext()) {
                Element child = (Element)it.next();
                if (!(child instanceof Project)) continue;
                Project jdevProject = (Project)child;
                URL projectURL = jdevProject.getURL();
                String projectPath = projectURL.getPath();
                int index = projectPath.lastIndexOf(47);
                projectPath = projectPath.substring(0, index);
                if (!path.getPath().startsWith(projectPath)) continue;
                return true;
            }
        }
        return false;
    }
}

