/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.core.model;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.bpm.fusion.core.ProjectObjectNode;
import oracle.bpm.fusion.core.model.StudioNodeFactory;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.processes.BpelProcess;
import oracle.bpm.project.model.processes.dataassociations.XSLTransformation;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.tree.TreeNode;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.javatools.data.HashStructure;

public class TreeNodeAdapter
extends ProjectObjectNode {
    private TreeNode treeNode;

    public TreeNodeAdapter(TreeNode treeNode, URL url) {
        super(url);
        this.treeNode = treeNode;
    }

    public static boolean isExternalNode(Class<? extends Object> userObjectClass) {
        return HumanTask.class.isAssignableFrom(userObjectClass) || BusinessRule.class.isAssignableFrom(userObjectClass) || BpelProcess.class.isAssignableFrom(userObjectClass) || XSLTransformation.class.isAssignableFrom(userObjectClass);
    }

    @Override
    public String getShortLabel() {
        return this.treeNode.getText();
    }

    public String getToolTipText() {
        String toolTipText = this.treeNode.getToolTipText();
        if (toolTipText != null) {
            return toolTipText;
        }
        return super.getToolTipText();
    }

    @Override
    public void replaceObject(ProjectObject replacement) {
        this.treeNode.reload((Object)replacement);
        super.replaceObject(replacement);
    }

    @Override
    public ActionGroup createActions() {
        return this.treeNode.createActions();
    }

    @Override
    public ProjectObject getObject() {
        Object userObject = this.treeNode.getUserObject();
        assert (userObject instanceof ProjectObject) : "Tree node '" + this.treeNode.getClass().getName() + " contains a '" + userObject + "' instead of a ProjectObject";
        return (ProjectObject)userObject;
    }

    public HashStructure getProperties() {
        System.out.println("TreeNodeAdapter.getProperties()");
        return super.getProperties();
    }

    public Iterator<Element> getChildren() {
        if (!this.isLoaded()) {
            try {
                this.open();
            }
            catch (IOException e) {
                Log.logTrace(e);
            }
        }
        return super.getChildren();
    }

    public void reloadChildren() {
        boolean dirty = this.isDirty();
        this.removeAll();
        try {
            this.openImpl();
            this.markDirty(dirty);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void invalidateIcon() {
        super.invalidateIcon();
        this.treeNode.reloadIcon();
    }

    @Override
    protected void registerAdapter(ProjectObject result) {
    }

    @Override
    protected Icon resolveIcon() {
        Image image = this.treeNode.getIcon();
        return image != null ? image.asSwingIcon() : null;
    }

    @Override
    protected TreeNode getTreeNode() {
        return this.treeNode;
    }

    protected Object getObjectStoreTarget() {
        return this.treeNode;
    }

    protected void openImpl() throws IOException {
        boolean dirty = this.isDirty();
        for (TreeNode childNode : this.treeNode.getChildren()) {
            Element childNodeAdapter;
            Class<?> userObjectClass = childNode.getUserObject().getClass();
            if (TreeNodeAdapter.isExternalNode(userObjectClass)) {
                try {
                    childNodeAdapter = NodeFactory.findOrCreate((URL)StudioNodeFactory.calculateURL(childNode));
                }
                catch (IllegalAccessException e) {
                    throw new IOException(e);
                }
                catch (InstantiationException e) {
                    throw new IOException(e);
                }
            } else {
                childNodeAdapter = StudioNodeFactory.getInstance().create(childNode);
            }
            if (childNodeAdapter == null) continue;
            this.add(childNodeAdapter);
        }
        this.markDirty(dirty);
    }

    private void fixOpenedEditors() {
        List allEditors = EditorManager.getEditorManager().getAllEditors();
        for (Object editor : allEditors) {
            if (!((Editor)editor).getContext().getNode().getURL().equals(this.getURL())) continue;
            ((Editor)editor).getContext().setNode((Node)this);
        }
    }
}

