/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.core.model;

import java.io.File;
import java.net.URL;
import oracle.bpm.fusion.core.model.NodeFactory;
import oracle.bpm.fusion.core.model.ObjectContainerNode;
import oracle.bpm.fusion.core.model.StudioNode;
import oracle.bpm.fusion.core.model.TreeNodeAdapter;
import oracle.bpm.project.model.DefaultProjectObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.processes.BpelProcess;
import oracle.bpm.project.model.processes.dataassociations.XSLTransformation;
import oracle.bpm.ui.tree.TreeNode;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.javatools.marshal.TransientMarker;

public final class StudioNodeFactory<E>
implements NodeFactory<E, TreeNode> {
    private static StudioNodeFactory instance;

    public static synchronized StudioNodeFactory getInstance() {
        if (instance == null) {
            instance = new StudioNodeFactory();
        }
        return instance;
    }

    public static URL calculateURL(TreeNode treeNode) throws TransientMarker {
        URL result = (URL)treeNode.as(URL.class);
        if (result == null) {
            File objectFile = (File)treeNode.as(File.class);
            result = StudioNodeFactory.asUrl(objectFile);
        }
        if (result == null) {
            TreeNode[] treeNodes = treeNode.getPath();
            StringBuffer url = new StringBuffer();
            boolean first = true;
            for (TreeNode node : treeNodes) {
                if (first) {
                    first = false;
                    continue;
                }
                url.append("/").append(node.getText());
            }
            result = URLFactory.newDirURL((String)"file", (String)url.toString());
        }
        return result;
    }

    public Element create(TreeNode node) {
        Object result;
        Class<?> userObjClass = node.getUserObject().getClass();
        if (XSLTransformation.class.isAssignableFrom(userObjClass) || BpelProcess.class.isAssignableFrom(userObjClass)) {
            try {
                result = oracle.ide.model.NodeFactory.findOrCreate((URL)StudioNodeFactory.calculateURL(node));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        } else {
            result = this.createNode(node);
        }
        return result;
    }

    @Override
    public StudioNode<E> createNode(TreeNode treeNode) {
        return this.createNode(treeNode, null);
    }

    public StudioNode<E> createNode(TreeNode treeNode, URL url) {
        StudioNode studioNode;
        if (url == null) {
            url = StudioNodeFactory.calculateURL(treeNode);
        }
        if (treeNode.isRoot()) {
            studioNode = new ObjectContainerNode(treeNode, url);
        } else if (ProjectObject.class.isAssignableFrom(treeNode.getUserObject().getClass())) {
            if (ResourceContainer.class.isAssignableFrom(treeNode.getUserObject().getClass())) {
                studioNode = new ObjectContainerNode(treeNode, url);
            } else {
                Object projectObject;
                try {
                    Object userObject = treeNode.getUserObject();
                    if (userObject instanceof ProjectObject) {
                        projectObject = (DefaultProjectObject)userObject;
                        Node prevNode = oracle.ide.model.NodeFactory.findOrCreate((URL)url);
                        if (prevNode != null && !(prevNode instanceof TreeNodeAdapter)) {
                            projectObject.addAdapter((Object)prevNode);
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                Node node = null;
                try {
                    node = oracle.ide.model.NodeFactory.findOrCreate((URL)url);
                }
                catch (IllegalAccessException e) {
                }
                catch (InstantiationException e) {
                    // empty catch block
                }
                studioNode = node != null && node instanceof StudioNode ? (StudioNode)node : new TreeNodeAdapter(treeNode, url);
                projectObject = treeNode.getUserObject();
                if (projectObject instanceof CatalogObject && (((CatalogObject)projectObject).isSynthesized() || ((CatalogObject)projectObject).isModule())) {
                    studioNode.getAttributes().unset(ElementAttributes.SAVEABLE);
                    studioNode.getAttributes().set(ElementAttributes.READ_ONLY);
                }
            }
        } else {
            studioNode = new ObjectContainerNode(treeNode, url);
        }
        return studioNode;
    }

    private static URL asUrl(File objecFile) {
        if (objecFile != null) {
            if (objecFile.isDirectory()) {
                return URLFactory.newDirURL((File)objecFile);
            }
            return URLFactory.newFileURL((File)objecFile);
        }
        return null;
    }
}

