/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.core.model;

import java.util.Comparator;
import oracle.bpm.fusion.core.model.PositionableNode;
import oracle.bpm.util.LoggingUtils;
import oracle.ide.model.Displayable;
import oracle.ideimpl.explorer.ExplorerNode;

public class ExplorerNodeComparator
implements Comparator<ExplorerNode> {
    @Override
    public int compare(ExplorerNode explorerNode1, ExplorerNode explorerNode2) {
        int result = 1;
        Object userObject1 = explorerNode1.getUserObject();
        Object userObject2 = explorerNode2.getUserObject();
        if (userObject1 instanceof PositionableNode && userObject2 instanceof PositionableNode) {
            int position1 = ((PositionableNode)userObject1).getPosition();
            int position2 = ((PositionableNode)userObject2).getPosition();
            result = position1 != -1 && position2 != -1 ? position1 - position2 : this.compareByLabel(userObject1, userObject2);
        } else {
            result = this.compareByLabel(userObject1, userObject2);
        }
        if (result == 0 && userObject1 != userObject2) {
            LoggingUtils.assertLog("ExplorerNodeComparator.compare", " ERROR: " + userObject1 + " [" + userObject1.getClass() + "] != " + userObject2 + " [" + userObject2.getClass() + "]");
        }
        return result;
    }

    private int compareByLabel(Object userObject1, Object userObject2) {
        int result = 1;
        if (userObject1 instanceof Comparable && userObject2 instanceof Comparable) {
            Comparable comparable1 = (Comparable)userObject1;
            Comparable comparable2 = (Comparable)userObject2;
            result = comparable1.compareTo(comparable2);
        } else if (userObject1 instanceof Displayable && userObject2 instanceof Displayable) {
            Displayable node1 = (Displayable)userObject1;
            Displayable node2 = (Displayable)userObject2;
            result = this.comparisonString(node1).compareTo(this.comparisonString(node2));
        }
        return result;
    }

    private String comparisonString(Displayable node) {
        return node.getShortLabel() + node.getLongLabel() + System.identityHashCode(node);
    }
}

