/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.core.model;

import java.net.URL;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.fusion.core.model.StudioNode;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.model.Localizable;
import oracle.bpm.project.model.ProjectObject;
import oracle.ide.controller.MenuFilter;
import oracle.ide.model.DataContainer;

public abstract class AbstractDataContainerNode<E>
extends DataContainer
implements StudioNode<E>,
Comparable<AbstractDataContainerNode<E>> {
    private MenuFilter menuFilter;
    private E object;

    public AbstractDataContainerNode() {
    }

    public AbstractDataContainerNode(URL url) {
        super(url);
    }

    @Override
    public MenuFilter getMenuFilter() {
        return this.menuFilter;
    }

    public void setMenuFilter(MenuFilter menuFilter) {
        this.menuFilter = menuFilter;
    }

    @Override
    public E getObject() {
        return this.object;
    }

    @Override
    public <T> T as(Class<T> targetType) {
        T result = null;
        E object = this.getObject();
        if (object != null) {
            if (targetType.isAssignableFrom(object.getClass())) {
                result = targetType.cast(object);
            } else if (object instanceof Adaptable) {
                Adaptable adaptable = (Adaptable)object;
                result = adaptable.as(targetType);
            }
        }
        return result;
    }

    @Override
    public Class<? extends E> getObjectClass() {
        return this.object.getClass();
    }

    @Override
    public void postChildModified() {
        this.refreshTimestamp();
    }

    @Override
    public int compareTo(AbstractDataContainerNode<E> other) {
        return this.compareNames(this.getObject(), other.getObject());
    }

    private int compareNames(E element1, E element2) {
        String label1 = this.getLabel(element1);
        String label2 = this.getLabel(element2);
        int result = 0;
        if (label1 != null && label2 != null) {
            result = label1.compareTo(label2);
        }
        if (result == 0 && element1 != element2) {
            String id1 = this.getId(element1);
            String id2 = this.getId(element2);
            result = id1.compareTo(id2);
        }
        return result;
    }

    private String getLabel(E element) {
        String label = null;
        if (element instanceof Localizable) {
            Localizable localizable = (Localizable)element;
            label = localizable.getDefaultLabel();
        }
        return label;
    }

    private String getId(E element) {
        String id = "";
        if (element instanceof ProjectObject) {
            id = ((ProjectObject)element).getId();
        }
        if (id == null) {
            id = "";
        }
        id = id + element.toString();
        id = id + Platform.getAdapterService().adaptTo(element, URL.class);
        id = id + System.identityHashCode(element);
        return id;
    }
}

