/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi.util;

import java.util.BitSet;
import java.util.Map;
import java.util.TreeMap;

public class ObjectRegistry {
    private BitSet bitmap;
    private Object[] fast = new Object[3];
    private Map<String, Integer> indexes;
    private Map<String, Object> slow = new TreeMap<String, Object>();

    public ObjectRegistry() {
        this.indexes = new TreeMap<String, Integer>();
        this.bitmap = new BitSet();
    }

    public static void main(String[] args) throws Throwable {
        int i;
        ObjectRegistry registry = new ObjectRegistry();
        System.out.println("@ Registering all");
        for (String arg : args) {
            System.out.println(arg + " = " + registry.register(arg, arg));
        }
        System.out.println("@ Deregistering half");
        for (i = 0; i < args.length / 2; ++i) {
            String arg = args[i];
            System.out.println("  remove:" + registry.deregister(arg));
        }
        System.out.println("@ Registering all (again in reverse order) ");
        for (i = args.length - 1; i >= 0; --i) {
            String arg = args[i];
            System.out.println(arg + " = " + registry.register(arg, arg));
        }
        System.out.println("@ Fast find of the oldest ones ");
        for (i = 0; i < args.length; ++i) {
            System.out.println("[" + i + "] = " + registry.find(i));
        }
    }

    public Object deregister(String name) {
        Object object = this.slow.remove(name);
        if (object != null) {
            this.deallocateIndex(name);
        }
        return object;
    }

    public Object find(String name) {
        return this.slow.get(name);
    }

    public Object find(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + index);
        }
        Object object = null;
        if (index < this.fast.length) {
            object = this.fast[index];
        }
        return object;
    }

    public int indexOf(String name) {
        Integer index = this.indexes.get(name);
        return index == null ? -1 : index;
    }

    public int register(String name, Object object) {
        int index;
        Object old = this.slow.put(name, object);
        if (old != null) {
            index = this.indexOf(name);
            this.fast[index] = object;
        } else {
            index = this.allocateIndex(name, object);
        }
        return index;
    }

    private int allocateIndex(String name, Object object) {
        int index = this.bitmap.nextClearBit(0);
        if (index >= this.fast.length) {
            Object[] enlarged = new Object[index + 10];
            System.arraycopy(this.fast, 0, enlarged, 0, this.fast.length);
            this.fast = enlarged;
        }
        this.fast[index] = object;
        this.bitmap.set(index);
        this.indexes.put(name, index);
        return index;
    }

    private void deallocateIndex(String name) {
        int index = this.indexes.remove(name);
        this.fast[index] = null;
        this.bitmap.clear(index);
    }
}

