/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi.nio;

import fuego.rmi.nio.FrameHeader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;

public class Test {
    public static void main(String[] args) throws IOException {
        Test t = new Test();
        t.testPing();
    }

    public void testOldSocks() throws IOException {
        ServerSocket sock = new ServerSocket(6060);
        Socket s = sock.accept();
        DataInputStream dis = new DataInputStream(s.getInputStream());
        int howmany = 0;
        while (true) {
            dis.readInt();
            int len = dis.readInt();
            byte[] data = new byte[len];
            dis.readFully(data);
            if (++howmany % 10 != 0) continue;
            System.out.println("Frame len is " + data.length + ", received: " + howmany);
        }
    }

    public void testPing() throws IOException {
        int frameLen = (int)(Math.random() * 32000.0 + 65000.0);
        ByteBuffer out = ByteBuffer.allocateDirect(frameLen);
        ByteBuffer in = ByteBuffer.allocateDirect(frameLen);
        in.order(ByteOrder.BIG_ENDIAN);
        out.order(ByteOrder.BIG_ENDIAN);
        FrameHeader header = new FrameHeader();
        header.setLength(frameLen - 8);
        header.put(out);
        SocketChannel ch = SocketChannel.open();
        ch.configureBlocking(true);
        ch.connect(new InetSocketAddress("localhost", 6060));
        int howMany = 1000;
        int total = howMany * frameLen;
        System.out.println("Sending " + total + " bytes ...");
        long start = System.currentTimeMillis();
        for (int i = 0; i < howMany; ++i) {
            out.clear();
            ch.write(out);
            in.clear();
            while (in.hasRemaining()) {
                if (ch.read(in) != -1) continue;
                throw new EOFException("Unexpected EOF");
            }
            out.flip();
            in.flip();
            if (in.equals(out)) continue;
            throw new RuntimeException("Sent data is different than received data");
        }
        long end = System.currentTimeMillis();
        System.out.println("Done!");
        System.out.println("Took: " + (end - start) + "ms.");
        ch.close();
    }

    public void testSend() throws IOException {
        ByteBuffer data = ByteBuffer.allocateDirect(8008);
        data.order(ByteOrder.BIG_ENDIAN);
        data.putInt(619493733);
        data.putInt(data.capacity() - 8);
        SocketChannel ch = SocketChannel.open();
        ch.configureBlocking(true);
        ch.connect(new InetSocketAddress("localhost", 6060));
        int howMany = 1000;
        System.out.println("Sending " + howMany * data.capacity() + " bytes ...");
        long start = System.currentTimeMillis();
        for (int i = 0; i < howMany; ++i) {
            data.clear();
            ch.write(data);
        }
        long end = System.currentTimeMillis();
        System.out.println("Done!");
        System.out.println("Took: " + (end - start) + "ms.");
        ch.close();
    }
}

