/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi.nio;

import fuego.rmi.nio.Endpoint;
import fuego.rmi.nio.Environment;
import fuego.rmi.nio.FrameCorruptedException;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.bpm.log.Log;
import oracle.bpm.util.LifecycleLock;
import oracle.bpm.util.Rendezvous;

public class SocketHandler {
    private final Map<Integer, Endpoint> available;
    private Environment env = null;
    private LifecycleLock lock = new LifecycleLock();
    private final LinkedList<Endpoint> readRegistrations;
    private Selector readSelector = null;
    private final Set<Endpoint> readyToSend;
    private Receiver receiver;
    private Sender sender;
    private volatile Rendezvous shutdown;
    private Selector writeSelector = null;

    public SocketHandler(Environment env) {
        this.env = env;
        this.readyToSend = new HashSet<Endpoint>();
        this.available = new TreeMap<Integer, Endpoint>();
        this.readRegistrations = new LinkedList();
    }

    public Environment getEnvironment() {
        return this.env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SocketChannel ch) throws IOException {
        this.lock.beginWork();
        try {
            System.out.println("Adding " + ch);
            ch.configureBlocking(false);
            Endpoint ep = new Endpoint(this, ch);
            Object object = this.available;
            synchronized (object) {
                this.available.put(ep.getId(), ep);
            }
            object = this.readRegistrations;
            synchronized (object) {
                this.readRegistrations.add(ep);
                this.readRegistrations.notify();
            }
            this.readSelector.wakeup();
        }
        finally {
            this.lock.endWork();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Integer endpoint, byte[] frame) {
        this.lock.beginWork();
        try {
            Endpoint ep;
            Object object = this.available;
            synchronized (object) {
                ep = this.available.get(endpoint);
            }
            if (ep == null) {
                throw new IllegalArgumentException("Illegal endpoint");
            }
            object = this.readyToSend;
            synchronized (object) {
                ep.enqueue(frame);
                this.readyToSend.add(ep);
                this.readyToSend.notify();
            }
            this.writeSelector.wakeup();
        }
        finally {
            this.lock.endWork();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.lock.beginShutdown();
        try {
            block23: {
                block22: {
                    this.readSelector.wakeup();
                    this.writeSelector.wakeup();
                    Collection<Endpoint> collection = this.readyToSend;
                    synchronized (collection) {
                        this.readyToSend.clear();
                        this.readyToSend.notify();
                    }
                    collection = this.readRegistrations;
                    synchronized (collection) {
                        this.readRegistrations.clear();
                        this.readRegistrations.notify();
                    }
                    try {
                        this.shutdown.meet(this.env.getShutdownTimeout());
                    }
                    catch (InterruptedException e) {
                        Log.logWarning(e);
                    }
                    Map<Integer, Endpoint> e = this.available;
                    synchronized (e) {
                        Iterator<Endpoint> it = this.available.values().iterator();
                        while (it.hasNext()) {
                            block21: {
                                Endpoint ep = it.next();
                                try {
                                    ep.getChannel().close();
                                }
                                catch (IOException e2) {
                                    if (!Log.isDebugging()) break block21;
                                    Log.logDebug(e2);
                                }
                            }
                            it.remove();
                        }
                    }
                    try {
                        this.readSelector.close();
                    }
                    catch (IOException e2) {
                        if (!Log.isDebugging()) break block22;
                        Log.logDebug(e2);
                    }
                }
                try {
                    this.writeSelector.close();
                }
                catch (IOException e) {
                    if (!Log.isDebugging()) break block23;
                    Log.logDebug(e);
                }
            }
            this.readSelector = null;
            this.writeSelector = null;
            this.sender = null;
            this.receiver = null;
            this.readRegistrations.clear();
        }
        finally {
            this.lock.endShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        this.lock.beginStartup();
        try {
            this.shutdown = new Rendezvous(3);
            this.readRegistrations.clear();
            this.readSelector = Selector.open();
            this.writeSelector = Selector.open();
            this.receiver = new Receiver();
            this.receiver.start();
            this.sender = new Sender();
            this.sender.start();
        }
        finally {
            this.lock.endStartup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel(SelectionKey key) {
        Endpoint ep = (Endpoint)key.attachment();
        key.cancel();
        Set<Endpoint> set = this.readyToSend;
        synchronized (set) {
            if (ep.isEmpty()) {
                this.readyToSend.remove(ep);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel(Endpoint ep) {
        block11: {
            SocketChannel ch;
            block10: {
                Socket socket;
                block9: {
                    System.out.println("Canceling: " + ep);
                    Map<Integer, Endpoint> map = this.available;
                    synchronized (map) {
                        this.available.remove(ep.getId());
                    }
                    ch = ep.getChannel();
                    socket = ch.socket();
                    try {
                        socket.shutdownOutput();
                    }
                    catch (IOException e) {
                        if (!Log.isDebugging()) break block9;
                        Log.logDebug(e);
                    }
                }
                try {
                    socket.close();
                }
                catch (IOException e) {
                    if (!Log.isDebugging()) break block10;
                    Log.logDebug(e);
                }
            }
            try {
                ch.close();
            }
            catch (IOException e) {
                if (!Log.isDebugging()) break block11;
                Log.logDebug(e);
            }
        }
        this.readSelector.wakeup();
    }

    private class Sender
    extends Thread {
        public Sender() {
            super("RMI Sender");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block30: {
                try {
                    while (!SocketHandler.this.lock.isShuttingDown()) {
                        Iterator<Object> it;
                        SocketHandler.this.writeSelector.selectNow();
                        Set set = SocketHandler.this.readyToSend;
                        synchronized (set) {
                            if (SocketHandler.this.lock.isShuttingDown()) {
                                break;
                            }
                            while (SocketHandler.this.readyToSend.isEmpty()) {
                                SocketHandler.this.readyToSend.wait();
                                if (!SocketHandler.this.lock.isShuttingDown()) continue;
                                break block30;
                            }
                            it = SocketHandler.this.readyToSend.iterator();
                            while (it.hasNext()) {
                                Endpoint ep = (Endpoint)it.next();
                                try {
                                    ep.getChannel().register(SocketHandler.this.writeSelector, 4, ep);
                                }
                                catch (IOException e) {
                                    Log.logWarning(e);
                                    it.remove();
                                }
                            }
                        }
                        SocketHandler.this.writeSelector.select();
                        Set<SelectionKey> selectedKeys = SocketHandler.this.writeSelector.selectedKeys();
                        if (selectedKeys.size() == 0) continue;
                        it = selectedKeys.iterator();
                        while (it.hasNext()) {
                            SelectionKey key = (SelectionKey)it.next();
                            Endpoint ep = (Endpoint)key.attachment();
                            try {
                                if (ep.send()) {
                                    SocketHandler.this.cancel(key);
                                }
                            }
                            catch (IOException e) {
                                Log.logWarning(e);
                                SocketHandler.this.cancel(key);
                                SocketHandler.this.cancel(ep);
                            }
                            catch (Exception e) {
                                Log.logSevere(e);
                                SocketHandler.this.cancel(key);
                                SocketHandler.this.cancel(ep);
                            }
                            it.remove();
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (Log.isDebugging()) {
                        Log.logDebug(e);
                    }
                }
                catch (Exception e) {
                    Log.logSevere(e);
                }
                finally {
                    try {
                        SocketHandler.this.shutdown.meet(SocketHandler.this.env.getShutdownTimeout());
                    }
                    catch (InterruptedException e) {
                        Log.logWarning(e);
                    }
                }
            }
        }
    }

    private class Receiver
    extends Thread {
        public Receiver() {
            super("RMI Receiver");
            super.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block27: {
                try {
                    while (!SocketHandler.this.lock.isShuttingDown()) {
                        SocketHandler.this.readSelector.selectNow();
                        LinkedList linkedList = SocketHandler.this.readRegistrations;
                        synchronized (linkedList) {
                            while (SocketHandler.this.readRegistrations.isEmpty()) {
                                if (SocketHandler.this.readSelector.keys().isEmpty()) {
                                    System.out.println("Nothing to do... just wait for a connection");
                                    SocketHandler.this.readRegistrations.wait();
                                    if (!SocketHandler.this.lock.isShuttingDown()) continue;
                                    break block27;
                                }
                                System.out.println("readSelector.keys().size() = " + SocketHandler.this.readSelector.keys().size());
                                break;
                            }
                            while (!SocketHandler.this.readRegistrations.isEmpty()) {
                                Endpoint ep = (Endpoint)SocketHandler.this.readRegistrations.removeFirst();
                                try {
                                    ep.getChannel().register(SocketHandler.this.readSelector, 1, ep);
                                }
                                catch (ClosedChannelException e) {
                                    Log.logWarning(e);
                                    SocketHandler.this.cancel(ep);
                                }
                            }
                        }
                        SocketHandler.this.readSelector.select();
                        Set<SelectionKey> ready = SocketHandler.this.readSelector.selectedKeys();
                        if (ready.size() == 0) {
                            System.out.println("recv: nothing has been selected, retrying...");
                            continue;
                        }
                        Iterator<SelectionKey> it = ready.iterator();
                        while (it.hasNext()) {
                            SelectionKey key = it.next();
                            Endpoint ep = (Endpoint)key.attachment();
                            try {
                                if (ep.receive()) {
                                    SocketHandler.this.cancel(ep);
                                }
                            }
                            catch (IOException e) {
                                Log.logWarning(e);
                                SocketHandler.this.cancel(ep);
                            }
                            catch (FrameCorruptedException e) {
                                Log.logWarning(e);
                                SocketHandler.this.cancel(ep);
                            }
                            catch (Exception e) {
                                Log.logSevere(e);
                                SocketHandler.this.cancel(ep);
                            }
                            it.remove();
                        }
                    }
                }
                catch (Exception e) {
                    Log.logSevere(e);
                }
                finally {
                    try {
                        SocketHandler.this.shutdown.meet(SocketHandler.this.env.getShutdownTimeout());
                    }
                    catch (InterruptedException e) {
                        Log.logWarning(e);
                    }
                }
            }
        }
    }
}

