/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi.nio;

import fuego.rmi.nio.Environment;
import fuego.rmi.nio.FrameCorruptedException;
import fuego.rmi.nio.FrameHeader;
import fuego.rmi.nio.SocketHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;

class Endpoint {
    private int bytesReceived = 0;
    private int bytesSent = 0;
    private SocketChannel channel;
    private SocketHandler handler;
    private Integer id;
    private byte[] incomming;
    private final LinkedList<byte[]> outgoing;
    private FrameHeader readHeader = new FrameHeader();
    private ByteBuffer recvBuffer;
    private ByteBuffer sendBuffer;
    private FrameHeader writeHeader = new FrameHeader();
    private static int nextId = 0;

    Endpoint(SocketHandler handler, SocketChannel channel) {
        Environment env = handler.getEnvironment();
        if (env.getSendBufferSize() < 8) {
            throw new IllegalArgumentException("Send buffer is too small, bytesReceived: " + env.getSendBufferSize());
        }
        this.handler = handler;
        this.recvBuffer = ByteBuffer.allocateDirect(env.getReceiveBufferSize());
        this.recvBuffer.order(ByteOrder.BIG_ENDIAN);
        this.sendBuffer = ByteBuffer.allocateDirect(env.getSendBufferSize());
        this.sendBuffer.limit(0);
        this.sendBuffer.order(ByteOrder.BIG_ENDIAN);
        this.channel = channel;
        this.incomming = new byte[env.getFrameBufferSize()];
        this.outgoing = new LinkedList();
        this.id = Endpoint.next();
    }

    public String toString() {
        return "[id=" + this.id + ", channel=" + this.channel + "]";
    }

    SocketChannel getChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEmpty() {
        LinkedList<byte[]> linkedList = this.outgoing;
        synchronized (linkedList) {
            return this.outgoing.isEmpty();
        }
    }

    Integer getId() {
        return this.id;
    }

    ByteBuffer getRecvBuffer() {
        return this.recvBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(byte[] frame) {
        LinkedList<byte[]> linkedList = this.outgoing;
        synchronized (linkedList) {
            this.outgoing.add(frame);
        }
    }

    boolean receive() throws IOException, FrameCorruptedException {
        this.recvBuffer.clear();
        if (this.channel.read(this.recvBuffer) == -1) {
            return true;
        }
        this.process(this.recvBuffer);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean send() throws IOException {
        byte[] data;
        if (this.sendBuffer.remaining() > 0) {
            this.channel.write(this.sendBuffer);
            if (this.sendBuffer.remaining() > 0) {
                return false;
            }
        }
        LinkedList<byte[]> linkedList = this.outgoing;
        synchronized (linkedList) {
            data = this.outgoing.isEmpty() ? null : this.outgoing.getFirst();
        }
        if (data == null) {
            this.sendBuffer.limit(0);
            this.bytesSent = 0;
            return true;
        }
        while (data != null) {
            this.sendBuffer.clear();
            while (this.sendBuffer.remaining() >= 8 && data != null) {
                int remaining = data.length + 8 - this.bytesSent;
                if (this.sendBuffer.remaining() < remaining) {
                    this.bytesSent += this.writeFrame(data, this.bytesSent, this.sendBuffer.remaining());
                    continue;
                }
                this.writeFrame(data, this.bytesSent, remaining);
                this.bytesSent = 0;
                LinkedList<byte[]> linkedList2 = this.outgoing;
                synchronized (linkedList2) {
                    this.outgoing.removeFirst();
                    data = this.outgoing.isEmpty() ? null : this.outgoing.getFirst();
                }
            }
            this.sendBuffer.flip();
            this.channel.write(this.sendBuffer);
            if (this.sendBuffer.remaining() <= 0) continue;
            return false;
        }
        return true;
    }

    private static synchronized Integer next() {
        return nextId++;
    }

    private int checkFrame(int off) throws FrameCorruptedException {
        if (off + 8 > this.bytesReceived) {
            return -1;
        }
        this.readHeader.get(this.incomming, off);
        int nextOffset = off + 8 + this.readHeader.getLength();
        if (nextOffset > this.bytesReceived) {
            return -1;
        }
        return nextOffset;
    }

    private void checkFrames() throws FrameCorruptedException {
        int current = 0;
        while (current != -1) {
            int next = this.checkFrame(current);
            if (next != -1) {
                byte[] frame = new byte[next - (current + 8)];
                System.arraycopy(this.incomming, current + 8, frame, 0, frame.length);
                this.processFrame(frame);
            } else if (current != 0) {
                this.bytesReceived -= current;
                System.arraycopy(this.incomming, current, this.incomming, 0, this.bytesReceived);
            }
            current = next;
        }
    }

    private void process(ByteBuffer d) throws FrameCorruptedException {
        int len = d.position();
        d.clear();
        if (len + this.bytesReceived > this.incomming.length) {
            byte[] tmp = new byte[len + this.bytesReceived];
            System.arraycopy(this.incomming, 0, tmp, 0, this.bytesReceived);
            this.incomming = tmp;
        }
        d.get(this.incomming, this.bytesReceived, len);
        this.bytesReceived += len;
        this.checkFrames();
    }

    private void processFrame(byte[] frame) {
        this.handler.send(this.getId(), frame);
    }

    private int writeFrame(byte[] data, int off, int len) {
        int howmany = len;
        if (off == 0) {
            howmany -= 8;
            this.writeHeader.setLength(data.length);
            this.writeHeader.put(this.sendBuffer);
        } else {
            if (off < 8) {
                throw new IllegalArgumentException("Illegal offset");
            }
            off -= 8;
        }
        this.sendBuffer.put(data, off, howmany);
        return len;
    }
}

