/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi.mmp;

import fuego.rmi.mmp.SSLProperties;
import fuego.rmi.mmp.SocketTransport;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import oracle.bpm.extensionpoint.metadata.TransportMetadata;

@TransportMetadata
public class SSLTransport
extends SocketTransport {
    private SSLContext context;
    private String[] enabledCipherSuites;
    private boolean needsClientAuth;
    private boolean wantsClientAuth;

    @Override
    public int getPriority() {
        return 30;
    }

    @Override
    public String getProtocol() {
        return "ssl";
    }

    @Override
    protected ServerSocket createServerSocket(InetAddress host, int port) throws IOException {
        SSLServerSocket sock = (SSLServerSocket)this.context.getServerSocketFactory().createServerSocket(port, 5, host);
        String[] enabled = this.enabledCipherSuites;
        if (enabled == null) {
            enabled = sock.getSupportedCipherSuites();
        }
        sock.setEnabledCipherSuites(enabled);
        sock.setUseClientMode(false);
        sock.setWantClientAuth(this.wantsClientAuth);
        sock.setNeedClientAuth(this.needsClientAuth);
        return sock;
    }

    @Override
    protected Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket sock = (SSLSocket)this.context.getSocketFactory().createSocket(host, port);
        String[] enabled = this.enabledCipherSuites;
        if (enabled == null) {
            enabled = sock.getSupportedCipherSuites();
        }
        sock.setEnabledCipherSuites(enabled);
        sock.setUseClientMode(true);
        sock.setWantClientAuth(this.wantsClientAuth);
        sock.setNeedClientAuth(this.needsClientAuth);
        sock.startHandshake();
        return sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, FileNotFoundException, CertificateException, IOException, NoSuchProviderException {
        SSLProperties properties = SSLProperties.create();
        KeyManager[] keyManagers = null;
        TrustManager[] trustManagers = null;
        try {
            this.context = properties.getSslProvider() == null ? SSLContext.getInstance(properties.getSslProtocol()) : SSLContext.getInstance(properties.getSslProtocol(), properties.getSslProvider());
            String keystore = properties.getKeystoreFile();
            if (keystore != null) {
                KeyManagerFactory kmf = properties.getKeyManagerProvider() == null ? KeyManagerFactory.getInstance(properties.getKeyManagerFactory()) : KeyManagerFactory.getInstance(properties.getKeyManagerFactory(), properties.getKeyManagerProvider());
                KeyStore ks = KeyStore.getInstance(properties.getKeystoreType());
                char[] passphrase = properties.getKeystorePassword();
                FileInputStream stream = new FileInputStream(keystore);
                try {
                    ks.load(stream, passphrase);
                }
                finally {
                    stream.close();
                }
                kmf.init(ks, passphrase);
                TrustManagerFactory tmf = properties.getTrustManagerProvider() == null ? TrustManagerFactory.getInstance(properties.getTrustManagerFactory()) : TrustManagerFactory.getInstance(properties.getTrustManagerFactory(), properties.getTrustManagerProvider());
                tmf.init(ks);
                keyManagers = kmf.getKeyManagers();
                trustManagers = tmf.getTrustManagers();
            }
            this.enabledCipherSuites = properties.getEnabledCipherSuites();
            this.wantsClientAuth = properties.wantsClientAuthentication();
            this.needsClientAuth = properties.needsClientAuthentication();
        }
        finally {
            properties.clear();
        }
        this.context.init(keyManagers, trustManagers, null);
    }
}

