/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi.local;

import fuego.rmi.local.LocalListener;
import fuego.rmi.spi.ConnectException;
import fuego.rmi.spi.Connection;
import fuego.rmi.spi.ListenException;
import fuego.rmi.spi.Listener;
import fuego.rmi.spi.Transport;
import fuego.rmi.spi.TransportException;
import java.net.BindException;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.extensionpoint.metadata.TransportMetadata;
import oracle.bpm.util.NetURL;

@TransportMetadata
public class LocalTransport
implements Transport {
    private Map<String, LocalListener> ports = new TreeMap<String, LocalListener>();

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public String getProtocol() {
        return "local";
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    public void clear() {
        LocalListener[] l;
        for (LocalListener localListener : l = this.ports.values().toArray(new LocalListener[this.ports.size()])) {
            try {
                localListener.dismiss();
            }
            catch (TransportException e) {
                // empty catch block
            }
        }
    }

    @Override
    public Connection connect(NetURL url) throws TransportException {
        String host = url.getHost();
        int port = url.getPort();
        String address = host + ":" + port;
        LocalListener l = this.find(address);
        if (l == null) {
            throw new ConnectException(address);
        }
        return l.createConnection();
    }

    @Override
    public Listener createListener(NetURL url) throws TransportException {
        String host = url.getHost();
        int port = url.getPort();
        String address = host + ":" + port;
        LocalListener l = this.find(address);
        if (l != null) {
            throw new ListenException(new BindException("Address already in use: " + address));
        }
        l = new LocalListener(address, this);
        this.open(address, l);
        return l;
    }

    LocalListener close(String address) {
        return this.ports.remove(address);
    }

    LocalListener find(String address) {
        return this.ports.get(address);
    }

    void open(String address, LocalListener listener) {
        this.ports.put(address, listener);
    }
}

