/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi.local;

import fuego.rmi.local.LocalConnection;
import fuego.rmi.local.LocalTransport;
import fuego.rmi.spi.Connection;
import fuego.rmi.spi.Listener;
import fuego.rmi.spi.TransportException;
import java.util.LinkedList;
import oracle.bpm.util.NetURL;

public class LocalListener
implements Listener {
    private LinkedList<LocalConnection> acceptQ = new LinkedList();
    private String address;
    private volatile boolean dismissed = false;
    private LocalTransport transport;

    LocalListener(String address, LocalTransport transport) {
        this.address = address;
        this.transport = transport;
    }

    @Override
    public NetURL getURL() throws TransportException {
        return new NetURL(this.transport.getProtocol() + "://" + this.address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dismiss() throws TransportException {
        if (this.dismissed) {
            return;
        }
        LocalListener localListener = this;
        synchronized (localListener) {
            if (this.dismissed) {
                return;
            }
            this.dismissed = true;
            this.notify();
        }
        this.transport.close(this.address);
    }

    @Override
    public synchronized Connection waitForConnection() throws TransportException {
        if (this.dismissed) {
            return null;
        }
        while (this.acceptQ.isEmpty()) {
            try {
                this.wait();
                if (!this.dismissed) continue;
                return null;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return this.acceptQ.removeFirst();
    }

    synchronized Connection createConnection() throws TransportException {
        LocalConnection l = new LocalConnection(this.address);
        LocalConnection r = new LocalConnection(this.address, l);
        this.acceptQ.addLast(l);
        this.notifyAll();
        return r;
    }
}

