/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi.local;

import fuego.rmi.Packet;
import fuego.rmi.StreamFactory;
import fuego.rmi.spi.Connection;
import fuego.rmi.spi.PacketHandler;
import fuego.rmi.spi.SendException;
import fuego.rmi.spi.SerializationException;
import fuego.rmi.spi.TransportException;
import fuego.rmi.util.BufferOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.LinkedList;

public class LocalConnection
implements Connection {
    private String address;
    private final BufferOutputStream buffer;
    private volatile boolean dismissed;
    private StreamFactory factory;
    private volatile PacketHandler handler;
    private LocalConnection peer;
    private final LinkedList<byte[]> queue;
    private Receiver receiver;

    LocalConnection(String address) {
        this.address = address;
        this.queue = new LinkedList();
        this.buffer = new BufferOutputStream(1024);
    }

    LocalConnection(String address, LocalConnection peer) {
        this(address);
        this.peer = peer;
        this.peer.peer = this;
    }

    @Override
    public void setPacketHandler(PacketHandler handler) throws TransportException {
        this.handler = handler;
        if (this.receiver == null) {
            this.receiver = new Receiver();
            this.receiver.start();
        }
    }

    @Override
    public String getPeerID() throws TransportException {
        return this.address;
    }

    @Override
    public void setStreamFactory(StreamFactory factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dismiss() {
        if (this.dismissed) {
            return;
        }
        this.dismissed = true;
        this.peer.dismiss();
        LinkedList<byte[]> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Packet message) throws TransportException {
        byte[] data;
        BufferOutputStream bufferOutputStream = this.buffer;
        synchronized (bufferOutputStream) {
            this.buffer.reset();
            try {
                message.write(this.buffer, this.factory);
            }
            catch (NotSerializableException e) {
                throw new SerializationException(e);
            }
            catch (IOException e) {
                throw new SendException(e);
            }
            catch (InternalError e) {
                throw new SerializationException(e);
            }
            data = this.buffer.toByteArray();
        }
        this.peer.enqueue(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(byte[] data) {
        LinkedList<byte[]> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.addLast(data);
            this.queue.notifyAll();
        }
    }

    private class Receiver
    extends Thread {
        private DataInputStream dis;
        private ReusableByteArrayInputStream is;

        public Receiver() {
            super("Local Receiver[" + LocalConnection.this.address + "]");
            this.setDaemon(true);
            this.setPriority(10);
            this.is = new ReusableByteArrayInputStream();
            this.dis = new DataInputStream(this.is);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Exception error;
            while (true) {
                byte[] data;
                block10: {
                    data = null;
                    error = null;
                    LinkedList linkedList = LocalConnection.this.queue;
                    synchronized (linkedList) {
                        if (LocalConnection.this.queue.isEmpty() && LocalConnection.this.dismissed) {
                            error = new IOException("connection closed");
                            break block10;
                        }
                        while (LocalConnection.this.queue.isEmpty()) {
                            try {
                                LocalConnection.this.queue.wait();
                            }
                            catch (InterruptedException e) {
                                error = e;
                                break block10;
                            }
                            if (!LocalConnection.this.queue.isEmpty() || !LocalConnection.this.dismissed) continue;
                            error = new IOException("connection closed");
                            break block10;
                        }
                        data = (byte[])LocalConnection.this.queue.removeFirst();
                    }
                }
                if (error != null) break;
                this.is.reset(data);
                try {
                    Packet packet = Packet.read(this.dis, LocalConnection.this.factory);
                    LocalConnection.this.handler.received(packet);
                }
                catch (Throwable e) {
                    LocalConnection.this.handler.exception(e);
                }
            }
            LocalConnection.this.handler.exception(error);
        }
    }

    private static class ReusableByteArrayInputStream
    extends ByteArrayInputStream {
        public ReusableByteArrayInputStream() {
            super(new byte[0]);
        }

        public void reset(byte[] buf) {
            this.buf = buf;
            this.pos = 0;
            this.count = buf.length;
            this.mark = 0;
        }
    }
}

