/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi;

import fuego.rmi.TransportNotFoundException;
import fuego.rmi.spi.Transport;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.TransportMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.log.Log;

public final class TransportFactory {
    private static Map<String, Transport> registeredTransports;

    private TransportFactory() {
    }

    public static Transport find(String name) throws TransportNotFoundException {
        Transport t = TransportFactory.getRegisteredTransports().get(name.toLowerCase());
        if (t == null) {
            throw new TransportNotFoundException(name);
        }
        return t;
    }

    public static String[] list() {
        TreeSet<Transport> s = new TreeSet<Transport>(new TransportComparator());
        for (Transport transport : TransportFactory.getRegisteredTransports().values()) {
            if (!transport.isVisible()) continue;
            s.add(transport);
        }
        String[] transports = new String[s.size()];
        int i = 0;
        for (Transport transport : s) {
            transports[i++] = transport.getProtocol();
        }
        return transports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, Transport> getRegisteredTransports() {
        if (registeredTransports != null) return registeredTransports;
        Class<TransportFactory> clazz = TransportFactory.class;
        synchronized (TransportFactory.class) {
            if (registeredTransports != null) return registeredTransports;
            HashMap<String, Transport> transports = new HashMap<String, Transport>();
            ExtensionService service = Platform.getExtensionService();
            List<Extension<TransportMetadata>> extensions = service.getExtensionsByPoint(TransportMetadata.class);
            for (Extension<TransportMetadata> extension : extensions) {
                try {
                    Transport transport = extension.instantiateAs(Transport.class);
                    String protocol = transport.getProtocol().toLowerCase();
                    transports.put(protocol, transport);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    Log.logSevere(e);
                }
            }
            registeredTransports = transports;
            // ** MonitorExit[var0] (shouldn't be in output)
            return registeredTransports;
        }
    }

    private static class TransportComparator
    implements Comparator<Transport> {
        private TransportComparator() {
        }

        @Override
        public int compare(Transport l, Transport r) {
            return l.getPriority() - r.getPriority();
        }
    }
}

