/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi;

import fuego.rmi.Channel;
import fuego.rmi.ChannelListener;
import fuego.rmi.ClientCluster;
import fuego.rmi.Endpoint;
import fuego.rmi.Packet;
import fuego.rmi.RMIException;
import fuego.rmi.Remote;
import fuego.rmi.RemoteProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.bpm.log.Log;
import oracle.bpm.util.NetURL;

public class ServerChannel
implements Channel {
    private boolean dismissed;
    private final Object dismissLock = new Object();
    private ClientCluster endpoint;
    private Object extraData;
    private final List<ChannelListener> listeners;
    private String objectId;
    private NetURL target;
    private static final SortedMap<String, ServerChannel> activeChannels = new TreeMap<String, ServerChannel>();
    private static Integer proxyId;

    private ServerChannel(NetURL target, ClientCluster ep, String objectId) {
        this.target = target;
        this.objectId = objectId;
        this.endpoint = ep;
        this.listeners = new ArrayList<ChannelListener>();
    }

    public static ServerChannel open(Remote proxy, String objectId) throws RMIException {
        return ServerChannel.open(proxy.getRemoteProxy(), objectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerChannel open(NetURL url, Integer sessionId, String objectId) throws RMIException {
        ClientCluster ep = ClientCluster.find(url);
        ServerChannel channel = new ServerChannel(url, ep, objectId);
        proxyId = ep.nextId();
        ep.register(proxyId, sessionId, channel);
        SortedMap<String, ServerChannel> sortedMap = activeChannels;
        synchronized (sortedMap) {
            activeChannels.put(objectId, channel);
        }
        return channel;
    }

    public String getChannelID() {
        return this.objectId;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setExtraData(Object data) {
        this.extraData = data;
    }

    public Object getExtraData() {
        return this.extraData;
    }

    public NetURL getURL() {
        return this.target;
    }

    public void dismiss() {
        this.notify(Packet.createDismiss(proxyId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(ChannelListener l) {
        List<ChannelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    public String toString() {
        return "ServerChannel[url=" + this.target + ", channelId=" + this.objectId + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(ChannelListener l) {
        List<ChannelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void piggyBack(Map<String, List<Object>> notifications) {
        TreeMap<String, ServerChannel> channels;
        if (notifications == null) {
            return;
        }
        SortedMap<String, ServerChannel> sortedMap = activeChannels;
        synchronized (sortedMap) {
            channels = new TreeMap<String, ServerChannel>(activeChannels);
        }
        for (Map.Entry<String, List<Object>> e : notifications.entrySet()) {
            String channelName = e.getKey();
            List<Object> messages = e.getValue();
            ServerChannel channel = (ServerChannel)channels.get(channelName);
            if (channel == null) continue;
            for (Object message : messages) {
                channel.notify(Packet.createNotification(proxyId, message));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notify(Packet m) {
        ArrayList<ChannelListener> target;
        List<ChannelListener> list = this.listeners;
        synchronized (list) {
            target = new ArrayList<ChannelListener>(this.listeners);
        }
        for (ChannelListener l : target) {
            try {
                if (m.isException()) {
                    l.handleException((Throwable)m.getValue());
                    continue;
                }
                if (m.isNotify()) {
                    l.processMessage(m.getNotification());
                    continue;
                }
                if (m.isDismiss()) {
                    l.dismiss(this);
                    continue;
                }
                l.handleException(new IllegalArgumentException("Unexpected RMI message: " + m));
            }
            catch (Exception warn) {
                Log.logWarning(warn);
            }
        }
        if (m.isDismiss()) {
            this.dismissInternal();
        }
    }

    private static ServerChannel open(RemoteProxy remoteProxy, String objectId) throws RMIException {
        return ServerChannel.open(remoteProxy.getUrl(), remoteProxy.getSessionId(), objectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dismissInternal() {
        Object object = this.dismissLock;
        synchronized (object) {
            if (this.dismissed) {
                return;
            }
            this.dismissed = true;
        }
        this.endpoint.deregister(proxyId);
        object = this.listeners;
        synchronized (object) {
            this.listeners.clear();
        }
        object = activeChannels;
        synchronized (object) {
            activeChannels.remove(this.objectId);
        }
    }
}

