/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi;

import fuego.rmi.Channel;
import fuego.rmi.ConnectionAcceptor;
import fuego.rmi.ConnectionLimitException;
import fuego.rmi.RMIException;
import fuego.rmi.ServerCluster;
import fuego.rmi.ServerShutdownException;
import fuego.rmi.TransportFactory;
import fuego.rmi.spi.Listener;
import fuego.rmi.spi.Transport;
import fuego.rmi.util.ObjectRegistry;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.bpm.component.Principal;
import oracle.bpm.util.LifecycleLock;
import oracle.bpm.util.NetURL;
import oracle.bpm.util.ObjectWatch;

public class Server {
    private NetURL[] bound;
    private final Map<Integer, ServerCluster> clusters = new HashMap<Integer, ServerCluster>();
    private final Object connectionLock = new Object();
    private int connections = 0;
    private ConnectionAcceptor[] dispatchers;
    private Map<String, Channel> exportedChannels;
    private volatile int handShakeTimeout = 300;
    private volatile int maxConnections = 50;
    private volatile int maxConnectionsPerCluster = 5;
    private Principal principal;
    private ObjectRegistry registeredObjects;
    private LifecycleLock shutdown = new LifecycleLock();
    private NetURL[] url;
    private static final Set<WeakReference<Server>> servers = new HashSet<WeakReference<Server>>();

    public Server(Principal principal, NetURL[] url) {
        if (principal == null) {
            throw new NullPointerException("'principal' can't be null");
        }
        if (url == null) {
            throw new NullPointerException("'url' can't be null");
        }
        for (int i = 0; i < url.length; ++i) {
            if (url[i] != null) continue;
            throw new NullPointerException("'url[" + i + "]' can't be null");
        }
        this.registeredObjects = new ObjectRegistry();
        this.exportedChannels = new TreeMap<String, Channel>();
        this.principal = principal;
        this.url = url;
        Server.addServer(this);
    }

    public NetURL[] getBoundUrls() {
        return this.bound;
    }

    public Principal getDefaultPrincipal() {
        return this.principal;
    }

    public void setHandShakeTimeout(int handShakeTimeout) {
        this.handShakeTimeout = handShakeTimeout;
    }

    public int getHandShakeTimeout() {
        return this.handShakeTimeout;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnectionsPerCluster(int maxConnectionsPerCluster) {
        this.maxConnectionsPerCluster = maxConnectionsPerCluster;
    }

    public int getMaxConnectionsPerCluster() {
        return this.maxConnectionsPerCluster;
    }

    public synchronized void exportChannel(String name, Channel obj) {
        this.exportedChannels.put(name, obj);
    }

    public synchronized Channel findChannel(String name) {
        return this.exportedChannels.get(name);
    }

    public synchronized Principal findObject(String name) {
        return (Principal)this.registeredObjects.find(name);
    }

    public synchronized void registerObject(String name, Principal obj) {
        this.registeredObjects.register(name, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws RMIException {
        this.shutdown.beginStartup();
        try {
            this.dispatchers = new ConnectionAcceptor[this.url.length];
            this.bound = new NetURL[this.url.length];
            for (int i = 0; i < this.url.length; ++i) {
                NetURL netURL = this.url[i];
                Transport transport = TransportFactory.find(netURL.getProtocol());
                Listener listener = transport.createListener(netURL);
                this.bound[i] = listener.getURL();
                this.dispatchers[i] = new ConnectionAcceptor(this, listener, netURL.toString());
                this.dispatchers[i].start();
            }
        }
        finally {
            this.shutdown.endStartup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws RMIException {
        this.shutdown.beginShutdown();
        try {
            for (ConnectionAcceptor dispatcher : this.dispatchers) {
                dispatcher.stop();
            }
            this.dispatchers = null;
            this.bound = null;
            Iterator<Map.Entry<Integer, ServerCluster>> it = this.clusters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, ServerCluster> entry = it.next();
                ServerCluster cluster = entry.getValue();
                cluster.release(new ServerShutdownException());
                it.remove();
            }
        }
        finally {
            this.shutdown.endShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void allocateConnection() throws ConnectionLimitException {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.connections >= this.maxConnections) {
                throw ConnectionLimitException.createPerServerLimit(this.maxConnections);
            }
            ++this.connections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerCluster createCluster() {
        this.shutdown.beginWork();
        try {
            ServerCluster cluster = new ServerCluster(this);
            Object object = this.clusters;
            synchronized (object) {
                this.clusters.put(cluster.getId(), cluster);
            }
            object = cluster;
            return object;
        }
        finally {
            this.shutdown.endWork();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deallocateConnection() {
        Object object = this.connectionLock;
        synchronized (object) {
            --this.connections;
            assert (this.connections >= 0) : "connections cannot be smaller than zero";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerCluster findCluster(Integer id) {
        this.shutdown.beginWork();
        try {
            Map<Integer, ServerCluster> map = this.clusters;
            synchronized (map) {
                ServerCluster serverCluster = this.clusters.get(id);
                return serverCluster;
            }
        }
        finally {
            this.shutdown.endWork();
        }
    }

    synchronized Principal findObject(int index) {
        return (Principal)this.registeredObjects.find(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerCluster removeCluster(Integer id) {
        try {
            this.shutdown.beginWork();
        }
        catch (IllegalStateException e) {
            return null;
        }
        try {
            Map<Integer, ServerCluster> map = this.clusters;
            synchronized (map) {
                ServerCluster serverCluster = this.clusters.remove(id);
                return serverCluster;
            }
        }
        finally {
            this.shutdown.endWork();
        }
    }

    synchronized int resolveObject(String objectName) {
        return this.registeredObjects.indexOf(objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addServer(Server server) {
        Set<WeakReference<Server>> set = servers;
        synchronized (set) {
            servers.add(new WeakReference<Server>(server));
        }
    }

    static {
        ObjectWatch.register("Fuego RMI", "rmiServers", "Currently running RMI Servers", servers);
    }
}

