/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi;

import fuego.rmi.ClientCluster;
import fuego.rmi.Endpoint;
import fuego.rmi.ObjectNotFoundException;
import fuego.rmi.Packet;
import fuego.rmi.RMIException;
import fuego.rmi.RMIRuntimeException;
import fuego.rmi.Remote;
import fuego.rmi.Session;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.bpm.component.Batch;
import oracle.bpm.component.ExecutorClient;
import oracle.bpm.component.Proxy;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.util.NetURL;

public class RemoteProxy
implements Proxy {
    private final Object correlationIdLock = new Object();
    private ClientCluster endpoint;
    private boolean invalid;
    private int nextCorrelationId = 0;
    private int objectId;
    private String objectName;
    private Integer proxyId;
    private Integer sessionId = Session.NEW;
    private NetURL url;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteProxy(RemoteProxy other, String objectName) throws RMIException {
        RemoteProxy remoteProxy = other;
        synchronized (remoteProxy) {
            this.endpoint = other.endpoint;
            this.proxyId = this.endpoint.nextId();
            this.endpoint.addRef();
            this.register(this.proxyId, this.nextCorrelationId(), other.sessionId, objectName);
            this.url = other.url;
            this.sessionId = other.sessionId;
        }
    }

    public RemoteProxy(NetURL target, String objectName) throws RMIException {
        this.url = target;
        this.endpoint = ClientCluster.find(target);
        this.proxyId = this.endpoint.nextId();
        this.sessionId = this.register(this.proxyId, this.nextCorrelationId(), Session.NEW, objectName);
    }

    public static Object createProxy(NetURL url, String objectId, Class[] interfaces) throws RMIException {
        RemoteProxy proxy = new RemoteProxy(url, objectId);
        return RemoteProxy.createProxy(proxy, interfaces);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object createProxy(Object other, String objectId, Class[] interfaces) throws RMIException {
        RemoteProxy proxy;
        if (java.lang.reflect.Proxy.isProxyClass(other.getClass())) {
            InvocationHandler handler = java.lang.reflect.Proxy.getInvocationHandler(other);
            if (!(handler instanceof Remote)) throw new IllegalArgumentException("Invalid proxy");
            Remote remote = (Remote)((Object)handler);
            proxy = remote.getRemoteProxy();
        } else if (other instanceof Remote) {
            Remote remote = (Remote)other;
            proxy = remote.getRemoteProxy();
        } else {
            if (!(other instanceof RemoteProxy)) throw new IllegalArgumentException("cannot get a remote proxy from: " + other);
            proxy = (RemoteProxy)other;
        }
        proxy = new RemoteProxy(proxy, objectId);
        return RemoteProxy.createProxy(proxy, interfaces);
    }

    public Integer getSessionId() {
        return this.sessionId;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public synchronized void dismiss() {
        if (this.invalid) {
            return;
        }
        this.invalid = true;
        this.endpoint.release(this.proxyId);
        this.endpoint = null;
    }

    @Override
    public Batch processBatch(Batch requests) {
        Packet m = Packet.createProcessBatch(this.nextCorrelationId(), this.proxyId, this.sessionId, this.objectId, requests.getId(), requests);
        try {
            m = this.endpoint.transact(m);
        }
        catch (RMIException e) {
            throw new RMIRuntimeException(e);
        }
        this.sessionId = m.getSessionId();
        if (m.isResult()) {
            return (Batch)m.getValue();
        }
        if (m.getValue() instanceof RuntimeException) {
            throw (RuntimeException)RemoteProxy.fixStackTrace(m.getValue());
        }
        if (m.getValue() instanceof ObjectNotFoundException) {
            ((ObjectNotFoundException)m.getValue()).translate(this.objectName);
        }
        throw new RMIRuntimeException(RemoteProxy.fixStackTrace(m.getValue()));
    }

    public String toString() {
        return "RemoteProxy[url=" + this.url + ", id=" + this.sessionId + ", objectId=" + this.objectId + "]";
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dismiss();
    }

    NetURL getUrl() {
        return this.url;
    }

    private static Object createProxy(RemoteProxy proxy, Class[] interfaces) {
        ClassLoader cl = interfaces[0].getClassLoader();
        boolean remoteIncluded = false;
        Class[] withRemote = new Class[interfaces.length + 1];
        for (int i = 0; i < interfaces.length; ++i) {
            Class anInterface = interfaces[i];
            if (Remote.class.isAssignableFrom(anInterface)) {
                remoteIncluded = true;
            }
            withRemote[i] = anInterface;
        }
        withRemote[interfaces.length] = Remote.class;
        Handler handler = new Handler(proxy);
        return java.lang.reflect.Proxy.newProxyInstance(cl, remoteIncluded ? interfaces : withRemote, (InvocationHandler)handler);
    }

    private static Throwable fixStackTrace(Object o) {
        Throwable t = (Throwable)o;
        StackTraceElement[] remote = t.getStackTrace();
        t.fillInStackTrace();
        StackTraceElement[] local = t.getStackTrace();
        StackTraceElement[] resulting = new StackTraceElement[remote.length + local.length - 1];
        System.arraycopy(remote, 0, resulting, 0, remote.length);
        System.arraycopy(local, 1, resulting, remote.length, local.length - 1);
        t.setStackTrace(resulting);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer nextCorrelationId() {
        Object object = this.correlationIdLock;
        synchronized (object) {
            return ++this.nextCorrelationId;
        }
    }

    private Integer register(Integer proxyId, Integer correlationId, Integer sessionId, String objectName) throws RMIException {
        Packet pkt = Packet.createRegisterProxy(proxyId, correlationId, sessionId, objectName);
        if ((pkt = this.endpoint.transact(pkt)).isException()) {
            throw (RMIException)RemoteProxy.fixStackTrace(pkt.getValue());
        }
        this.objectId = pkt.getObjectId();
        this.objectName = objectName;
        return pkt.getSessionId();
    }

    private static class Handler
    implements InvocationHandler,
    Remote {
        private ExecutorClient client;
        private RemoteProxy proxy;
        private Map<Method, String> signatures;

        public Handler(RemoteProxy proxy) {
            this.proxy = proxy;
            this.client = new ExecutorClient(this.proxy);
            this.signatures = Collections.synchronizedMap(new WeakHashMap());
        }

        @Override
        public ExecutorClient getExecutorClient() {
            return this.client;
        }

        @Override
        public RemoteProxy getRemoteProxy() {
            return this.proxy;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?> declaringClass = method.getDeclaringClass();
            if (Remote.class.isAssignableFrom(declaringClass) || !declaringClass.isInterface()) {
                try {
                    return method.invoke((Object)this, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            return this.client.invoke(this.getSignature(method), args);
        }

        public String toString() {
            return this.proxy.toString();
        }

        private String getSignature(Method method) {
            String sig = this.signatures.get(method);
            if (sig == null) {
                sig = JavaClass.getSignature(method);
                this.signatures.put(method, sig);
            }
            return sig;
        }
    }
}

