/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.editor;

import java.io.StringWriter;
import java.io.Writer;
import oracle.bpm.cil.CilException;
import oracle.bpm.compiler.CompletionResult;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.xpath.XPathGeneratorUtils;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorCompiler {
    @NotNull
    private final FuegoCompiler fuegoCompiler = XPathGeneratorUtils.buildCompiler();
    @Nullable
    private static volatile EditorCompiler sharedCompiler;

    EditorCompiler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EditorCompiler get() {
        EditorCompiler result = sharedCompiler;
        if (result != null) return result;
        Class<EditorCompiler> clazz = EditorCompiler.class;
        synchronized (EditorCompiler.class) {
            result = sharedCompiler;
            if (result != null) return result;
            sharedCompiler = result = new EditorCompiler();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileMethod(MethodTypeDescription method, SourceCode code, TypeDescription parent) throws CilException {
        this.checkLock();
        MethodTypeDescription methodTypeDescription = method;
        synchronized (methodTypeDescription) {
            method.setCode(code);
            FuegoCompiler compiler = this.fuegoCompiler;
            compiler.reset();
            compiler.addObjectClass((TypeRef)parent.asObject());
            compiler.compile((TypeDescription)method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionResult complete(int caretPosition, MethodTypeDescription method, char[] chars) throws CilException {
        CompletionResult result;
        SourceCode code = SourceCode.create(chars, method.getCodeLanguage());
        MethodTypeDescription methodTypeDescription = method;
        synchronized (methodTypeDescription) {
            method.setCode(code);
            FuegoCompiler compiler = this.fuegoCompiler;
            compiler.reset();
            compiler.addObjectClass(method.getParentRef());
            result = compiler.complete(method, caretPosition);
        }
        return result;
    }

    public SourceCode translate(MethodTypeDescription method, char[] chars, LanguageSpec targetLanguage, boolean refactor) throws CilException {
        SourceCode result;
        this.checkLock();
        SourceCode code = SourceCode.create(chars, method.getCodeLanguage());
        if (code.isEmpty()) {
            result = SourceCode.create("", targetLanguage.getId());
        } else {
            this.compileMethod(method, code, method.getParent());
            SourceGenerator generator = targetLanguage.createSourceGenerator();
            FuegoCompiler compiler = this.fuegoCompiler;
            if (refactor) {
                compiler.refactor(generator.getStyle(), (TypeDescription)method);
            }
            StringWriter out = new StringWriter();
            generator.setWriter((Writer)out);
            compiler.generateSource(generator, (TypeDescription)method);
            result = SourceCode.create(out.toString(), targetLanguage.getId());
        }
        return result;
    }

    @NotNull
    public FuegoCompiler getFuegoCompiler() {
        return this.fuegoCompiler;
    }

    private void checkLock() {
        assert (Thread.holdsLock(this)) : "Must synchronize over this compiler";
    }
}

