/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.editor;

import java.io.File;
import oracle.bpm.compiler.CodeDebugger;
import oracle.bpm.compiler.CodeRunner;
import oracle.bpm.compiler.DebuggerActionManager;
import oracle.bpm.compiler.IDebuggerRunnable;
import oracle.bpm.editor.WebDebuggerClient;
import oracle.bpm.editor.msg.EditorMsg;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.fs.FileProjectWriter;
import oracle.bpm.project.io.fs.WebRoot;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.util.FuegoDirectories;

public class DebuggerKit {

    public static class SuspendAction
    extends BaseDebuggerAction {
        static final long serialVersionUID = -2296882426974625998L;
        static final long serialCheck = 2807740671266399969L;

        public SuspendAction(CodeDebugger debugger) {
            super(EditorMsg.SUSPEND, debugger);
        }

        public void run() {
            this.debugger.suspend();
        }
    }

    public static class StopAction
    extends BaseDebuggerAction {
        static final long serialVersionUID = 4355160496244750748L;
        static final long serialCheck = -8162483963541877891L;

        public StopAction(CodeDebugger debugger) {
            super(EditorMsg.STOP, debugger);
        }

        public void run() {
            WebDebuggerClient instance = WebDebuggerClient.getInstance();
            instance.finishDebugging();
            this.debugger.stop();
        }
    }

    public static class StepOverAction
    extends BaseDebuggerAction {
        private final Project project;
        static final long serialVersionUID = 2473776785131871184L;
        static final long serialCheck = 1849722327323040929L;

        public StepOverAction(CodeDebugger debugger, Project project) {
            super(EditorMsg.STEP, debugger);
            this.project = project;
        }

        public void run() {
            if (!this.debugger.isRunning()) {
                WebDebuggerClient.setDebugger(new WebDebuggerClient(this.project){

                    protected CodeRunner.DebuggerRunnable initDebugger() {
                        CodeRunner.DebuggerRunnable debbugerRunnable = StepOverAction.this.debugger.beginDebugging();
                        this.setDebuggerRunnable((IDebuggerRunnable)debbugerRunnable);
                        StepOverAction.this.debugger.stepOver();
                        return debbugerRunnable;
                    }
                });
                WebDebuggerClient.getInstance().beginDebugging();
            } else {
                this.debugger.stepOver();
            }
        }
    }

    public static class StepIntoAction
    extends BaseDebuggerAction {
        static final long serialVersionUID = 4596926647674521398L;
        static final long serialCheck = -737840236158423162L;

        public StepIntoAction(CodeDebugger debugger) {
            super(EditorMsg.STEP_INTO, debugger);
        }

        public void run() {
            this.debugger.stepInto();
        }
    }

    public static class RunAction
    extends BaseDebuggerAction {
        private Project project;
        static final long serialVersionUID = -8965476310085980021L;
        static final long serialCheck = -1393741972614890157L;

        public RunAction(CodeDebugger debugger, Project project) {
            super(EditorMsg.RUN, debugger);
            this.project = project;
        }

        public void run() {
            if (!this.debugger.isRunning()) {
                WebDebuggerClient.setDebugger(new WebDebuggerClient(this.project){

                    protected CodeRunner.DebuggerRunnable initDebugger() {
                        CodeRunner.DebuggerRunnable debuggerRunnable = RunAction.this.debugger.beginDebugging();
                        this.setDebuggerRunnable((IDebuggerRunnable)debuggerRunnable);
                        RunAction.this.debugger.run();
                        return debuggerRunnable;
                    }
                });
                WebDebuggerClient instance = WebDebuggerClient.getInstance();
                instance.beginDebugging();
            } else {
                this.debugger.run();
            }
        }
    }

    public static class IgnoreStepAction
    extends BaseDebuggerAction {
        static final long serialVersionUID = -5293177124550509079L;
        static final long serialCheck = 7410012751661280494L;

        public IgnoreStepAction(CodeDebugger debugger) {
            super(EditorMsg.IGNORE_STEP, debugger);
        }

        public void run() {
            this.debugger.ignoreStep();
        }
    }

    public static class ExitAction
    extends BaseDebuggerAction {
        static final long serialVersionUID = -3008164955493603912L;
        static final long serialCheck = 6946436831341707196L;

        public ExitAction(CodeDebugger debugger) {
            super(EditorMsg.EXIT, debugger);
        }

        public void run() {
            this.debugger.exit();
        }
    }

    public static abstract class BaseDebuggerAction
    extends BaseAction
    implements DebuggerActionManager.DebuggerAction {
        protected CodeDebugger debugger;
        static final long serialVersionUID = 8567535958504207045L;
        static final long serialCheck = 5630007585113545811L;

        public BaseDebuggerAction(Msg msg, CodeDebugger debugger) {
            super(msg);
            this.debugger = debugger;
        }

        public void copyProjectJSPResources(Project project) {
            String webDebuggerDir = FuegoDirectories.webAppsInstallation() + "webdebugger";
            if (Log.isDebugging()) {
                Log.logDebug("Copying JSP files and resources to:" + webDebuggerDir);
            }
            File webdebbugerDir = new File(webDebuggerDir);
            FileProjectWriter projectWriter = (FileProjectWriter)project.getWriter();
            WebRoot.copyWebRootTo((ProjectWriter)projectWriter, (File)webdebbugerDir);
        }

        protected void setEnvironment() {
        }
    }
}

