/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.editor;

import oracle.bpm.compiler.FuegoInvokeable;
import oracle.bpm.component.Component;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.ConnectorServiceInterface;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.lang.Environment;
import oracle.bpm.project.FuegoProject;

public class DebuggerEnvironment {
    private Environment environment;
    private FuegoProject project;
    private ConnectorService service;

    public DebuggerEnvironment(FuegoProject project, Environment env) {
        this.project = project;
        this.environment = env;
        this.resetEnvironment();
    }

    public static void close() {
    }

    public void setInvokeable(FuegoInvokeable invokeable) {
        this.resetEnvironment();
    }

    public void resetEnvironment() {
        this.initConnectorService();
        Component.setConnectorService(this.service);
        Component.setRunningOnDebugger();
    }

    private void initConnectorService() {
        ConnectorServiceInterface prevService;
        this.service = this.getProject().getConnectorService(this.environment);
        boolean test = Boolean.valueOf(System.getProperty("fuego.test.RunSimTestSuite", "false"));
        if (!test && !this.service.equals(prevService = ConnectorTransaction.getDefaultConnectorService())) {
            if (prevService != null && prevService.isStarted()) {
                prevService.stop();
            }
            ConnectorTransaction.setDefaultConnectorService(this.service);
        }
    }

    private FuegoProject getProject() {
        return this.project;
    }
}

