/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.editor;

import javax.swing.text.BadLocationException;
import oracle.bpm.cil.CilException;
import oracle.bpm.compiler.CompiledTemplate;
import oracle.bpm.compiler.CompletionResult;
import oracle.bpm.compiler.CompletionSuggestion;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.SourceTemplate;
import oracle.bpm.compiler.TemplateParameter;
import oracle.bpm.editor.EditorCompiler;
import oracle.bpm.editor.EditorDocument;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.ui.Beep;
import org.jetbrains.annotations.Nullable;

public class CompletionSupport {
    private CompletionSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CompletionResult completeCodeAt(EditorDocument doc, int caretPosition) {
        EditorCompiler compiler = EditorCompiler.get();
        CompletionResult result = null;
        EditorCompiler editorCompiler = compiler;
        synchronized (editorCompiler) {
            try {
                TypeDescription parent;
                MethodTypeDescription method = doc.getMethod();
                TypeDescription typeDescription = parent = method != null ? method.getParent() : null;
                if (method != null && parent != null) {
                    char[] chars = doc.getChars();
                    int length = chars.length;
                    if (length < caretPosition) {
                        CompletionResult completionResult = null;
                        return completionResult;
                    }
                    result = compiler.complete(caretPosition, method, chars);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            catch (CilException ignore) {
                compiler.getFuegoCompiler().reset();
            }
            finally {
                compiler.getFuegoCompiler().reset();
            }
            return result;
        }
    }

    public static void paste(EditorDocument doc, CompletionSuggestion completion, int selectionStart, int selectionEnd) {
        SourceTemplate template = completion.createTemplate();
        try {
            if (selectionStart >= 0) {
                doc.removeText(selectionStart, selectionEnd - selectionStart);
            }
            CompletionSupport.paste(doc, template, completion.getPasteOffset(), completion.getPasteLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public static void paste(EditorDocument doc, SourceTemplate template, int offset) {
        CompletionSupport.paste(doc, template, offset, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paste(EditorDocument doc, SourceTemplate template, int offset, int length) {
        block11: {
            CompiledTemplate compiledTemplate;
            FuegoCompiler compiler;
            FuegoCompiler fuegoCompiler = compiler = EditorCompiler.get().getFuegoCompiler();
            synchronized (fuegoCompiler) {
                compiledTemplate = template.compile(compiler, doc.getMethod(), offset);
            }
            try {
                doc.clearTemplateMarks();
                String code = compiledTemplate.getCode();
                String indent = CompletionSupport.getIndent(doc.getLineTextOfOffset(offset));
                int indentLenght = indent.length();
                boolean needsIndentation = indentLenght > 0;
                String[] lines = new String[]{};
                if (needsIndentation) {
                    lines = code.split("\r\n|[\n\r\u2028\u2029\u0085]");
                    if (lines.length > 1) {
                        code = CompletionSupport.indentCode(lines, indent);
                    } else {
                        needsIndentation = false;
                    }
                }
                doc.replaceText(offset, length, code);
                int newCaretPos = offset + code.length();
                doc.select(newCaretPos, newCaretPos);
                int parameterCount = compiledTemplate.getParameterCount();
                for (int i = 0; i < parameterCount; ++i) {
                    TemplateParameter parameter = compiledTemplate.getParameter(i);
                    if (needsIndentation) {
                        int pasteOffset = parameter.getPasteOffset();
                        int pasteLine = CompletionSupport.findParameterLine(lines, pasteOffset - offset);
                        parameter.setPasteOffset(pasteOffset + indentLenght * pasteLine);
                    }
                    doc.addTemplateMark(parameter);
                }
                if (parameterCount > 0) {
                    doc.addTemplateMark(offset + code.length(), 0);
                    doc.activateTemplateMark(offset, true);
                }
            }
            catch (BadLocationException e) {
                Beep.play();
                if (!Log.isDebugging()) break block11;
                Log.logDebug(e);
            }
        }
    }

    private static int findParameterLine(String[] lines, int offset) throws BadLocationException {
        int currentLineEnd0ffset = -1;
        for (int i = 0; i < lines.length; ++i) {
            int lenght = lines[i].length();
            if (offset >= (currentLineEnd0ffset += lenght)) continue;
            return i;
        }
        throw new BadLocationException("Offset out of bounds.", offset);
    }

    private static String indentCode(String[] lines, String indent) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (i > 0) {
                result.append(indent);
            }
            result.append(line);
            result.append("\n");
        }
        return result.toString();
    }

    private static String getIndent(String lineText) {
        char ch;
        int i;
        int length = lineText.length();
        for (i = 0; i < length && ((ch = lineText.charAt(i)) == ' ' || ch == '\t'); ++i) {
        }
        return lineText.substring(0, i);
    }
}

