/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.editor;

import java.util.List;
import oracle.bpm.editor.CodeEditor;
import oracle.bpm.editor.EditorSupport;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.CodeEditorMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;

public abstract class CodeEditorFactory {
    private static CodeEditorFactory editorFactory;

    public abstract CodeEditor create(UiContainer var1, String var2);

    public static CodeEditor create(UiContainer parent, EditorSupport support, String language) {
        if (editorFactory == null) {
            ExtensionService service = Platform.getExtensionService();
            List<Extension<CodeEditorMetadata>> extensions = service.getExtensionsByPoint(CodeEditorMetadata.class);
            for (Extension<CodeEditorMetadata> extension : extensions) {
                CodeEditorMetadata metadata = extension.getMetadata();
                System.out.println("CodeEditorFactory.create()" + Ui.getType().toString());
                System.out.println("CodeEditorFactory.create()" + metadata.uiType());
                if (!metadata.uiType().equals(Ui.getType().toString())) continue;
                try {
                    editorFactory = extension.instantiateAs(CodeEditorFactory.class);
                    System.out.println("CodeEditorFactory.create()" + editorFactory);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        CodeEditor editor = null;
        if (editorFactory != null) {
            editor = editorFactory.create(parent, language);
            editor.setSupport(support);
        }
        return editor;
    }
}

