/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard.model.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import oracle.bpel.services.workflow.common.model.PrincipleRefType;
import oracle.bpel.services.workflow.user.model.UserApplicationDataType;
import oracle.bpm.services.processdashboard.model.PrincipleRef;
import oracle.bpm.services.processdashboard.model.Widget;
import oracle.bpm.services.processdashboard.model.WidgetView;
import oracle.bpm.services.processdashboard.model.impl.ModelTypeFactory;
import oracle.bpm.services.processdashboard.model.impl.PrincipleRefImpl;
import oracle.bpm.services.processdashboard.model.impl.WidgetImpl;
import oracle.bpm.services.processdashboard.model.jaxb.WidgetType;
import org.jetbrains.annotations.NotNull;

public class WidgetViewImpl
implements WidgetView {
    UserApplicationDataType userApplicationDataType = ModelTypeFactory.getUserModelFactory().createUserApplicationDataType();
    WidgetImpl widgetImpl;
    private static final long serialVersionUID = 20090824095400L;

    private WidgetViewImpl() {
        this.userApplicationDataType.setApplicationDataType("BAM-WIDGET");
        this.widgetImpl = WidgetImpl.create();
    }

    public static WidgetViewImpl create() {
        return new WidgetViewImpl();
    }

    public static WidgetViewImpl create(UserApplicationDataType userApplicationDataType) {
        WidgetViewImpl widgetView = new WidgetViewImpl();
        widgetView.setUserApplicationDataType(userApplicationDataType);
        return widgetView;
    }

    public UserApplicationDataType getUserApplicationDataType() {
        this.userApplicationDataType.setData(ModelTypeFactory.getXMLFromWidget(this.widgetImpl.getWidgetType()));
        return this.userApplicationDataType;
    }

    public void setUserApplicationDataType(UserApplicationDataType userApplicationDataType) {
        this.userApplicationDataType = userApplicationDataType;
        this.userApplicationDataType.setApplicationDataType("BAM-WIDGET");
        if (this.userApplicationDataType.getData() != null) {
            WidgetType widgetType = ModelTypeFactory.createWidgetType(this.userApplicationDataType.getData());
            this.widgetImpl = WidgetImpl.create(widgetType);
        }
    }

    @Override
    public String getId() {
        return this.userApplicationDataType.getId();
    }

    @Override
    public String getName() {
        return this.userApplicationDataType.getName();
    }

    @Override
    public void setName(@NotNull String name) {
        this.userApplicationDataType.setName(name);
    }

    @Override
    public String getOwner() {
        return this.userApplicationDataType.getOwner();
    }

    @Override
    public String getCreatedBy() {
        return this.userApplicationDataType.getCreatedBy();
    }

    @Override
    public Calendar getCreatedDate() {
        return this.userApplicationDataType.getCreatedDate();
    }

    @Override
    public String getUpdatedBy() {
        return this.userApplicationDataType.getUpdatedBy();
    }

    @Override
    public Calendar getUpdatedDate() {
        return this.userApplicationDataType.getUpdatedDate();
    }

    @Override
    public List<PrincipleRef> getGrantees() {
        ArrayList<PrincipleRef> principleRefList = new ArrayList<PrincipleRef>();
        if (this.userApplicationDataType.getGrantees() != null && this.userApplicationDataType.getGrantees().getParticipant() != null) {
            for (Object object : this.userApplicationDataType.getGrantees().getParticipant()) {
                principleRefList.add(PrincipleRefImpl.create((PrincipleRefType)object));
            }
        }
        return principleRefList;
    }

    @Override
    public void addGrantee(@NotNull PrincipleRef principleRef) {
        if (this.userApplicationDataType.getGrantees() == null) {
            this.userApplicationDataType.setGrantees(ModelTypeFactory.getWorkflowModelFactory().createPrincipleListType());
        }
        this.userApplicationDataType.getGrantees().getParticipant().add(ModelTypeFactory.createPrincipleRefType(principleRef));
    }

    @Override
    public void removeGrantee(@NotNull PrincipleRef principleRef) {
        this.userApplicationDataType.getGrantees().getParticipant().remove(ModelTypeFactory.createPrincipleRefType(principleRef));
    }

    @Override
    public void clearGrantees() {
        this.userApplicationDataType.getGrantees().getParticipant().clear();
    }

    @Override
    public boolean hasWidget() {
        return this.widgetImpl != null;
    }

    @Override
    public Widget getWidget() {
        return this.widgetImpl;
    }

    @Override
    public void setWidget(@NotNull Widget widget) {
        this.widgetImpl = widget instanceof WidgetImpl ? (WidgetImpl)widget : WidgetImpl.create(widget);
    }
}

