/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard.model.impl;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import oracle.bpm.services.processdashboard.model.ValueData;
import oracle.bpm.services.processdashboard.model.impl.ModelTypeFactory;
import oracle.bpm.services.processdashboard.model.jaxb.ValueDataType;
import org.jetbrains.annotations.NotNull;

public class ValueDataImpl
implements ValueData {
    private transient Object value;
    private ValueDataType valueDataType = ModelTypeFactory.getWidgetTypeFactory().createValueDataType();

    private ValueDataImpl() {
    }

    public static ValueDataImpl create() {
        return new ValueDataImpl();
    }

    public static ValueDataImpl create(@NotNull ValueDataType valueDataType) {
        ValueDataImpl valueData = new ValueDataImpl();
        valueData.valueDataType = valueDataType;
        return valueData;
    }

    @Override
    public Object getValue() {
        if (!this.isNull() && this.value == null) {
            this.value = this.valueDataType.isSetJavaType() ? this.getJavaObject(this.valueDataType.getJavaType(), this.valueDataType.getValue()) : this.valueDataType.getValue();
        }
        return this.value;
    }

    @Override
    public String getJavaType() {
        return this.valueDataType.isSetJavaType() ? this.valueDataType.getJavaType() : null;
    }

    @Override
    public String getLabel() {
        return this.valueDataType.isSetLabel() ? this.valueDataType.getLabel() : (this.getValue() == null ? "" : this.getValue().toString());
    }

    @Override
    public String getShortLabel() {
        return this.valueDataType.isSetShortlabel() ? this.valueDataType.getShortlabel() : this.getLabel();
    }

    @Override
    public boolean isNull() {
        return this.valueDataType.isSetNull() && this.valueDataType.isNull();
    }

    private Object getJavaObject(String javaType, String value) {
        if (javaType == null) {
            return value;
        }
        if (String.class.getName().equals(javaType)) {
            return value;
        }
        if (Integer.class.getName().equals(javaType)) {
            return Integer.valueOf(value);
        }
        if (Long.class.getName().equals(javaType)) {
            return Long.valueOf(value);
        }
        if (Float.class.getName().equals(javaType)) {
            return Float.valueOf(value);
        }
        if (Double.class.getName().equals(javaType)) {
            return Double.valueOf(value);
        }
        if (BigDecimal.class.getName().equals(javaType)) {
            return new BigDecimal(value);
        }
        if (Date.class.getName().equals(javaType)) {
            try {
                return DateFormat.getDateInstance(3, Locale.US).parse(value);
            }
            catch (ParseException initCause) {
                throw new IllegalArgumentException("Invalid date format", initCause);
            }
        }
        return value;
    }
}

