/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard.model.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import oracle.bpm.services.processdashboard.model.DataSource;
import oracle.bpm.services.processdashboard.model.Dimension;
import oracle.bpm.services.processdashboard.model.Dimensions;
import oracle.bpm.services.processdashboard.model.Measurement;
import oracle.bpm.services.processdashboard.model.ModelFactory;
import oracle.bpm.services.processdashboard.model.Predicate;
import oracle.bpm.services.processdashboard.model.Series;
import oracle.bpm.services.processdashboard.model.impl.DimensionImpl;
import oracle.bpm.services.processdashboard.model.impl.DimensionsImpl;
import oracle.bpm.services.processdashboard.model.impl.MeasurementImpl;
import oracle.bpm.services.processdashboard.model.impl.ModelTypeFactory;
import oracle.bpm.services.processdashboard.model.impl.PredicateImpl;
import oracle.bpm.services.processdashboard.model.jaxb.DrillDownType;
import oracle.bpm.services.processdashboard.model.jaxb.SeriesType;
import org.jetbrains.annotations.NotNull;

public class SeriesImpl
implements Series {
    private SeriesType seriesType = ModelTypeFactory.getWidgetTypeFactory().createSeriesType();
    private static final long serialVersionUID = 20090824095400L;

    private SeriesImpl() {
    }

    public static SeriesImpl create() {
        return new SeriesImpl();
    }

    public static SeriesImpl create(SeriesType seriesType) {
        SeriesImpl series = new SeriesImpl();
        series.setSeriesType(seriesType);
        return series;
    }

    public SeriesType getSeriesType() {
        return this.seriesType;
    }

    public void setSeriesType(SeriesType seriesType) {
        this.seriesType = seriesType;
    }

    @Override
    public boolean hasDataSource() {
        return this.seriesType.isSetDataSource();
    }

    @Override
    public DataSource getDataSource() {
        return ModelTypeFactory.getDataSource(this.seriesType.getDataSource());
    }

    @Override
    public void setDataSource(@NotNull DataSource dataSource) {
        this.seriesType.setDataSource(ModelTypeFactory.getDataSourceTypeEnum(dataSource));
    }

    @Override
    public boolean hasProcess() {
        return this.seriesType.isSetProcess();
    }

    @Override
    public String getProcess() {
        return this.seriesType.getProcess();
    }

    @Override
    public void setProcess(@NotNull String process) {
        this.seriesType.setProcess(process);
    }

    @Override
    public boolean hasMeasurement() {
        return this.seriesType.isSetMeasurement();
    }

    @Override
    public Measurement getMeasurement() {
        return MeasurementImpl.create(this.seriesType.getMeasurement());
    }

    @Override
    public void setMeasurement(@NotNull Measurement measurement) {
        this.seriesType.setMeasurement(ModelTypeFactory.createMeasurementType(measurement));
    }

    @Override
    public boolean hasDimentions() {
        return this.seriesType.isSetDimensions();
    }

    @Override
    public Dimensions getDimensions() {
        return DimensionsImpl.create(this.seriesType.getDimensions());
    }

    @Override
    public void setDimensions(@NotNull Dimensions dimensions) {
        this.seriesType.setDimensions(ModelTypeFactory.createDimensionsType(dimensions));
    }

    @Override
    public boolean hasPredicate() {
        return this.seriesType.isSetPredicate();
    }

    @Override
    public Predicate getPredicate() {
        if (this.seriesType.isSetPredicate()) {
            return PredicateImpl.create(this.seriesType.getPredicate());
        }
        return ModelFactory.createPredicate();
    }

    @Override
    public void setPredicate(@NotNull Predicate predicate) {
        this.seriesType.setPredicate(ModelTypeFactory.createPredicateType(predicate));
    }

    @Override
    public void cleanPredicate() {
        this.seriesType.setPredicate(ModelTypeFactory.getWidgetTypeFactory().createPredicateType());
    }

    @Override
    public boolean hasDrillDown() {
        return this.seriesType.isSetDrilldown();
    }

    @Override
    public List<Dimension> getDrillDown() {
        Comparator<DrillDownType> comparator = new Comparator<DrillDownType>(){

            @Override
            public int compare(DrillDownType left, DrillDownType right) {
                if (left == null && right == null) {
                    return 0;
                }
                if (left == null) {
                    return -1;
                }
                if (right == null) {
                    return 1;
                }
                if (!left.isSetOrder() && !right.isSetOrder()) {
                    return 0;
                }
                if (!left.isSetOrder()) {
                    return -1;
                }
                if (!right.isSetOrder()) {
                    return 1;
                }
                return left.getOrder().compareTo(right.getOrder());
            }
        };
        TreeSet<DrillDownType> sortedDrillDown = new TreeSet<DrillDownType>(comparator);
        for (DrillDownType drillDownType : this.seriesType.getDrilldown()) {
            sortedDrillDown.add(drillDownType);
        }
        ArrayList<Dimension> drillDown = new ArrayList<Dimension>();
        for (DrillDownType drillDownType : sortedDrillDown) {
            drillDown.add(DimensionImpl.create(drillDownType.getDimension()));
        }
        return drillDown;
    }

    @Override
    public Dimension getNextDrillDown() {
        DrillDownType drillDown = null;
        for (DrillDownType drillDownType : this.seriesType.getDrilldown()) {
            if (drillDown != null && drillDown.getOrder().compareTo(drillDownType.getOrder()) <= 0) continue;
            drillDown = drillDownType;
        }
        return drillDown == null ? null : DimensionImpl.create(drillDown.getDimension());
    }

    @Override
    public void addDrillDown(@NotNull Dimension dimension, int order) {
        DrillDownType drillDownType = null;
        for (DrillDownType drillDown : this.seriesType.getDrilldown()) {
            if (!drillDown.getDimension().getValue().equalsIgnoreCase(dimension.getDimension())) continue;
            drillDownType = drillDown;
            break;
        }
        if (drillDownType == null) {
            drillDownType = ModelTypeFactory.getWidgetTypeFactory().createDrillDownType();
            this.seriesType.getDrilldown().add(drillDownType);
        }
        drillDownType.setDimension(ModelTypeFactory.createDimensionType(dimension));
        drillDownType.setOrder(BigInteger.valueOf(order));
    }

    @Override
    public void removeDrillDown(@NotNull Dimension dimension) {
        DrillDownType toRemove = null;
        for (DrillDownType drillDown : this.seriesType.getDrilldown()) {
            if (!drillDown.getDimension().getValue().equalsIgnoreCase(dimension.getDimension())) continue;
            toRemove = drillDown;
            break;
        }
        if (toRemove != null) {
            this.seriesType.getDrilldown().remove(toRemove);
        }
    }

    @Override
    public void cleanDrillDown() {
        this.seriesType.getDrilldown().clear();
    }
}

