/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard.model.impl;

import oracle.bpm.services.processdashboard.model.AggregateFunction;
import oracle.bpm.services.processdashboard.model.Measurement;
import oracle.bpm.services.processdashboard.model.ValueType;
import oracle.bpm.services.processdashboard.model.impl.ModelTypeFactory;
import oracle.bpm.services.processdashboard.model.jaxb.AggregateFunctionTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.MeasurementType;
import oracle.bpm.services.processdashboard.model.jaxb.ValueTypeEnum;
import org.jetbrains.annotations.NotNull;

public class MeasurementImpl
implements Measurement {
    private MeasurementType measurementType = ModelTypeFactory.getWidgetTypeFactory().createMeasurementType();
    private static final long serialVersionUID = 20090824095400L;

    private MeasurementImpl() {
        this.measurementType.setAggregateFunction(AggregateFunctionTypeEnum.AVG);
        this.measurementType.setValueType(ValueTypeEnum.VALUE);
    }

    public static MeasurementImpl create() {
        return new MeasurementImpl();
    }

    public static MeasurementImpl create(@NotNull MeasurementType measurementType) {
        MeasurementImpl measurement = new MeasurementImpl();
        measurement.setMeasurementType(measurementType);
        return measurement;
    }

    public MeasurementType getMeasurementType() {
        return this.measurementType;
    }

    public void setMeasurementType(@NotNull MeasurementType measurementType) {
        this.measurementType = measurementType;
    }

    @Override
    public boolean hasVariable() {
        return this.measurementType.isSetVariable();
    }

    @Override
    public String getVariable() {
        return this.measurementType.getVariable();
    }

    public void setVariable(@NotNull String variable) {
        this.measurementType.setVariable(variable);
    }

    @Override
    public boolean hasAggregateFunction() {
        return this.measurementType.isSetAggregateFunction();
    }

    @Override
    public AggregateFunction getAggregateFunction() {
        return ModelTypeFactory.getAggregateFunction(this.measurementType.getAggregateFunction());
    }

    @Override
    public void setAggregateFunction(@NotNull AggregateFunction aggregateFunction) {
        this.measurementType.setAggregateFunction(ModelTypeFactory.getAggregateFunctionTypeEnum(aggregateFunction));
    }

    @Override
    public ValueType getValueType() {
        return ModelTypeFactory.getValueType(this.measurementType.getValueType());
    }

    @Override
    public void setValueType(@NotNull ValueType valueType) {
        this.measurementType.setValueType(ModelTypeFactory.getValueTypeEnum(valueType));
    }

    @Override
    public boolean useRange() {
        return this.measurementType.isSetUseRange() && this.measurementType.isUseRange();
    }

    @Override
    public void setUseRange(boolean useRange) {
        this.measurementType.setUseRange(useRange);
    }
}

