/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard.model.impl;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.services.processdashboard.model.Data;
import oracle.bpm.services.processdashboard.model.Series;
import oracle.bpm.services.processdashboard.model.impl.ModelTypeFactory;
import oracle.bpm.services.processdashboard.model.impl.SeriesImpl;
import oracle.bpm.services.processdashboard.model.jaxb.DataType;
import oracle.bpm.services.processdashboard.model.jaxb.SeriesType;
import org.jetbrains.annotations.NotNull;

public class DataImpl
implements Data {
    private DataType dataType = ModelTypeFactory.getWidgetTypeFactory().createDataType();
    private static final long serialVersionUID = 20090824095400L;

    private DataImpl() {
    }

    public static Data create() {
        return new DataImpl();
    }

    public static Data create(@NotNull DataType dataType) {
        DataImpl data = new DataImpl();
        data.setDataType(dataType);
        return data;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(@NotNull DataType data) {
        this.dataType = data;
    }

    @Override
    public boolean hasSeries() {
        return this.dataType.isSetSeries();
    }

    @Override
    public List<Series> getSeries() {
        ArrayList<Series> series = new ArrayList<Series>();
        for (SeriesType seriesType : this.dataType.getSeries()) {
            series.add(SeriesImpl.create(seriesType));
        }
        return series;
    }

    @Override
    public void addSeries(@NotNull Series series) {
        this.dataType.getSeries().add(ModelTypeFactory.createSeriesType(series));
    }

    @Override
    public void removeSeries(@NotNull Series series) {
        this.dataType.getSeries().remove(ModelTypeFactory.createSeriesType(series));
    }

    @Override
    public void clear() {
        this.dataType.getSeries().clear();
    }
}

