/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard.model;

import java.util.Locale;
import oracle.bpm.services.processdashboard.model.AggregateFunction;
import oracle.bpm.services.processdashboard.model.Condition;
import oracle.bpm.services.processdashboard.model.Data;
import oracle.bpm.services.processdashboard.model.Dimension;
import oracle.bpm.services.processdashboard.model.Dimensions;
import oracle.bpm.services.processdashboard.model.Measurement;
import oracle.bpm.services.processdashboard.model.Predicate;
import oracle.bpm.services.processdashboard.model.PrincipleRef;
import oracle.bpm.services.processdashboard.model.Series;
import oracle.bpm.services.processdashboard.model.Title;
import oracle.bpm.services.processdashboard.model.ValueType;
import oracle.bpm.services.processdashboard.model.Visualization;
import oracle.bpm.services.processdashboard.model.Widget;
import oracle.bpm.services.processdashboard.model.WidgetView;
import oracle.bpm.services.processdashboard.model.impl.ConditionImpl;
import oracle.bpm.services.processdashboard.model.impl.DataImpl;
import oracle.bpm.services.processdashboard.model.impl.DimensionImpl;
import oracle.bpm.services.processdashboard.model.impl.DimensionsImpl;
import oracle.bpm.services.processdashboard.model.impl.MeasurementImpl;
import oracle.bpm.services.processdashboard.model.impl.PredicateImpl;
import oracle.bpm.services.processdashboard.model.impl.PrincipleRefImpl;
import oracle.bpm.services.processdashboard.model.impl.SeriesImpl;
import oracle.bpm.services.processdashboard.model.impl.TitleImpl;
import oracle.bpm.services.processdashboard.model.impl.VisualizationImpl;
import oracle.bpm.services.processdashboard.model.impl.WidgetImpl;
import oracle.bpm.services.processdashboard.model.impl.WidgetViewImpl;
import org.jetbrains.annotations.NotNull;

public final class ModelFactory {
    public static WidgetView createWidgetView(@NotNull String name) {
        WidgetViewImpl widgetView = WidgetViewImpl.create();
        widgetView.setName(name);
        return widgetView;
    }

    public static Widget createWidget() {
        return WidgetImpl.create();
    }

    public static Visualization createVisualization() {
        return VisualizationImpl.create();
    }

    public static Data createData() {
        return DataImpl.create();
    }

    public static Series createSeries() {
        return SeriesImpl.create();
    }

    public static Measurement createMeasurement(@NotNull String variable, @NotNull AggregateFunction aggregateFunction) {
        MeasurementImpl measurement = MeasurementImpl.create();
        measurement.setVariable(variable);
        measurement.setAggregateFunction(aggregateFunction);
        measurement.setValueType(ValueType.VALUE);
        return measurement;
    }

    public static Dimensions createDimensions(@NotNull String xSeries) {
        DimensionsImpl dimensions = DimensionsImpl.create();
        dimensions.setXSeries(xSeries);
        return dimensions;
    }

    public static Dimension createDimension(@NotNull String dimension) {
        DimensionImpl dimensionImpl = DimensionImpl.create();
        dimensionImpl.setDimension(dimension);
        return dimensionImpl;
    }

    public static Predicate createPredicate() {
        return PredicateImpl.create();
    }

    public static Condition createCondition() {
        return ConditionImpl.create();
    }

    public static Title createTitle(@NotNull Locale locale, @NotNull String value) {
        TitleImpl title = TitleImpl.create();
        title.setLocale(locale);
        title.setValue(value);
        return title;
    }

    public static PrincipleRef createPrincipleRef(@NotNull String name, String realm, @NotNull String type) {
        PrincipleRefImpl principleRef = PrincipleRefImpl.create();
        principleRef.setName(name);
        principleRef.setRealm(realm);
        principleRef.setType(type);
        return principleRef;
    }
}

