/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.instancequery.impl;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import oracle.bpm.services.instancequery.IAuditVariable;
import oracle.bpm.services.instancequery.IAuditVariableRange;

public class AuditVariable
implements IAuditVariable {
    private int mAttribute;
    private String mDataType;
    private String mName;
    private String mTable;
    private String mType;
    private Object mValue;
    private TreeSet<IAuditVariableRange> mRanges;
    private String mRangeName;
    static final long serialVersionUID = 4784301771654142541L;

    public static IAuditVariable newInstance() {
        return new AuditVariable();
    }

    @Override
    public void setName(String name) {
        this.mName = name;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void setDataType(String type) {
        this.mDataType = type;
    }

    @Override
    public String getDataType() {
        return this.mDataType;
    }

    @Override
    public void setValue(Object value) {
        this.mValue = value;
        this.mRangeName = null;
    }

    @Override
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public void setTable(String table) {
        this.mTable = table;
    }

    @Override
    public String getTable() {
        return this.mTable;
    }

    @Override
    public void setAttribute(int attribute) {
        this.mAttribute = attribute;
    }

    @Override
    public int getAttribute() {
        return this.mAttribute;
    }

    public String toString() {
        return this.getName() + "=" + String.valueOf(this.mValue);
    }

    @Override
    public void setType(String type) {
        this.mType = type;
    }

    @Override
    public String getType() {
        return this.mType;
    }

    @Override
    public void setRanges(List<IAuditVariableRange> ranges) {
        this.mRanges = new TreeSet<IAuditVariableRange>(new Comparator<IAuditVariableRange>(){

            @Override
            public int compare(IAuditVariableRange obj1, IAuditVariableRange obj2) {
                return obj1.getNumberRangeStart().compareTo(obj2.getNumberRangeStart());
            }
        });
        this.mRanges.addAll(ranges);
    }

    @Override
    public boolean isDimension() {
        return "D".equals(this.mType);
    }

    @Override
    public boolean isMeasure() {
        return "M".equals(this.mType);
    }

    @Override
    public boolean isCounter() {
        return "C".equals(this.mType);
    }

    @Override
    public boolean hasRange() {
        return this.mRanges != null && this.mRanges.size() > 0;
    }

    @Override
    public String getRangeValue() {
        if (this.mRangeName != null) {
            return this.mRangeName;
        }
        return this.initRangeValue();
    }

    private String initRangeValue() {
        IAuditVariableRange range = null;
        if ("NUMBER".equals(this.mDataType)) {
            BigDecimal val = new BigDecimal(String.valueOf(this.mValue == null ? Integer.valueOf(0) : this.mValue));
            for (IAuditVariableRange r : this.mRanges) {
                if (r.getNumberRangeStart() != null && r.getNumberRangeStart().compareTo(val) > 0 || r.getNumberRangeEnd() != null && r.getNumberRangeEnd().compareTo(val) < 0) continue;
                range = r;
                break;
            }
        }
        if (range != null) {
            this.mRangeName = range.getRangeName();
            return range.getRangeName();
        }
        return "";
    }
}

