/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.instancequery.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.services.common.model.CompositeDNModel;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IAuditVariable;
import oracle.bpm.services.instancequery.IAuditVariableMetadata;
import oracle.bpm.services.instancequery.impl.AuditVariable;

public class AuditInstance
implements IAuditInstance {
    private String mCompositeInstanceId;
    private Long mParentThreadId;
    private Long mQueryId;
    private Long mStep;
    private Long mLoopCount;
    private Long mThreadId;
    private Long mPriority;
    private String mActivityId;
    private String mActivityName;
    private String mActivityType;
    private String mAuditInstanceType;
    private byte[] mAuditLog;
    private String mComponentInstanceId;
    private String mComponentName;
    private String mComponentType;
    private String mCompositeDn;
    private String mCompositeName;
    private boolean mFaultIsrecoverable;
    private String mFaultType;
    private String mFlowElementType;
    private String mInvokedComponentName;
    private String mLabel;
    private String mOperation;
    private String mParticipant;
    private String mProcessName;
    private String mReferenceId;
    private String mRoleId;
    private String mSourceActivity;
    private String mTargetActivity;
    private String mTitle;
    private Calendar mCreateTime;
    private Calendar mDueDate;
    private Calendar mProcessDueDate;
    private Calendar mPartitionDate;
    private Calendar[] mDateValue;
    private BigDecimal[] mNumberValue;
    private String[] mStringValue;
    private List<String> mAssociatedVariables;
    private transient Map<String, IAuditVariable> mVariables;
    private transient CompositeDNModel compositeDNModel;
    private IAuditVariableMetadata mMetadata;
    private boolean mVariablesAvailable;
    private Long mMultiInstanceCount;
    private String mScopeId;
    static final long serialVersionUID = -5301645008269986896L;

    public AuditInstance() {
    }

    private AuditInstance(IAuditVariableMetadata metadata) {
        this.init(metadata);
    }

    public static IAuditInstance newInstance(IAuditVariableMetadata metadata) {
        return new AuditInstance(metadata);
    }

    @Override
    public IAuditVariable getVariable(String name) {
        if (!this.isVariablesAvailable()) {
            return null;
        }
        if (this.mVariables == null) {
            this.mVariables = new HashMap<String, IAuditVariable>();
        }
        if (this.mVariables.containsKey(name)) {
            return this.mVariables.get(name);
        }
        int slot = 0;
        IAuditVariable v = null;
        slot = this.mMetadata.getNumberNames().indexOf(name) + 1;
        v = slot > 0 ? this.createVariable(name, this.mMetadata.getNumberType(slot), "NUMBER", slot, "AUDIT_QUERY", this.getNumberValue(slot)) : ((slot = this.mMetadata.getStringNames().indexOf(name) + 1) > 0 ? this.createVariable(name, this.mMetadata.getStringType(slot), "STRING", slot, "AUDIT_QUERY", this.getStringValue(slot)) : ((slot = this.mMetadata.getDateNames().indexOf(name) + 1) > 0 ? this.createVariable(name, this.mMetadata.getDateType(slot), "DATE", slot, "AUDIT_QUERY", this.getDateValue(slot)) : null));
        if (v != null) {
            this.mVariables.put(v.getName(), v);
        }
        return v;
    }

    @Override
    public Map<String, IAuditVariable> getVariables() {
        if (!this.isVariablesAvailable()) {
            Map<String, IAuditVariable> vars = null;
            return vars;
        }
        ArrayList<String> names = new ArrayList<String>();
        if (this.mAssociatedVariables == null || this.mAssociatedVariables.size() <= 0) {
            return this.getAllVariables();
        }
        names.addAll(this.mAssociatedVariables);
        return this.createVariableList(names);
    }

    @Override
    public Map<String, IAuditVariable> getAllVariables() {
        if (!this.isVariablesAvailable()) {
            Map<String, IAuditVariable> vars = null;
            return vars;
        }
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.mMetadata.getNumberNames());
        names.addAll(this.mMetadata.getStringNames());
        names.addAll(this.mMetadata.getDateNames());
        return this.createVariableList(names);
    }

    private CompositeDNModel getCompositeDNModel() {
        if (this.compositeDNModel == null) {
            this.compositeDNModel = CompositeDNModel.parseCompositeDN(this.getCompositeDn());
        }
        return this.compositeDNModel;
    }

    @Override
    public String getDNApplicationName() {
        return this.getCompositeDNModel().getApplicationName();
    }

    @Override
    public String getDNCompositeName() {
        return this.getCompositeDNModel().getCompositeName();
    }

    @Override
    public String getDN() {
        return this.getCompositeDn();
    }

    @Override
    public String getDNLabel() {
        return this.getCompositeDNModel().getLabel();
    }

    @Override
    public String getDNRevision() {
        return this.getCompositeDNModel().getRevision();
    }

    @Override
    public void setCompositeInstanceId(String compositeInstanceId) {
        this.mCompositeInstanceId = compositeInstanceId;
    }

    @Override
    public String getCompositeInstanceId() {
        return this.mCompositeInstanceId;
    }

    @Override
    public void setPartitionDate(Calendar ciPartionDate) {
        this.mPartitionDate = ciPartionDate;
    }

    @Override
    public Calendar getPartitionDate() {
        return this.mPartitionDate;
    }

    @Override
    public void setParentThreadId(Long parentThreadId) {
        this.mParentThreadId = parentThreadId;
    }

    @Override
    public Long getParentThreadId() {
        return this.mParentThreadId;
    }

    @Override
    public void setPriority(Long priority) {
        this.mPriority = priority;
    }

    @Override
    public Long getPriority() {
        return this.mPriority;
    }

    @Override
    public void setQueryId(Long queryId) {
        this.mQueryId = queryId;
    }

    @Override
    public Long getQueryId() {
        return this.mQueryId;
    }

    @Override
    public void setStep(Long step) {
        this.mStep = step;
    }

    @Override
    public Long getStep() {
        return this.mStep;
    }

    @Override
    public void setLoopCount(Long value) {
        this.mLoopCount = value;
    }

    @Override
    public Long getLoopCount() {
        return this.mLoopCount;
    }

    @Override
    public void setThreadId(Long threadId) {
        this.mThreadId = threadId;
    }

    @Override
    public Long getThreadId() {
        return this.mThreadId;
    }

    @Override
    public void setActivityId(String activityId) {
        this.mActivityId = activityId;
    }

    @Override
    public String getActivityId() {
        return this.mActivityId;
    }

    @Override
    public void setActivityName(String activityName) {
        this.mActivityName = activityName;
    }

    @Override
    public String getActivityName() {
        return this.mActivityName;
    }

    @Override
    public void setActivityType(String mActivityType) {
        this.mActivityType = mActivityType;
    }

    @Override
    public String getActivityType() {
        return this.mActivityType;
    }

    @Override
    public void setAuditInstanceType(String auditInstanceType) {
        this.mAuditInstanceType = auditInstanceType;
    }

    @Override
    public String getAuditInstanceType() {
        return this.mAuditInstanceType;
    }

    @Override
    public void addAuditPayloadElement(IAuditVariable element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, IAuditVariable> getPayloadElements() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAuditLog(byte[] auditLog) {
        this.mAuditLog = auditLog;
    }

    @Override
    public byte[] getAuditLog() {
        return this.mAuditLog;
    }

    @Override
    public void setComponentInstanceId(String componentInstanceId) {
        this.mComponentInstanceId = componentInstanceId;
    }

    @Override
    public String getComponentInstanceId() {
        return this.mComponentInstanceId;
    }

    @Override
    public void setComponentName(String componentName) {
        this.mComponentName = componentName;
    }

    @Override
    public String getComponentName() {
        return this.mComponentName;
    }

    @Override
    public void setComponentType(String componentType) {
        this.mComponentType = componentType;
    }

    @Override
    public String getComponentType() {
        return this.mComponentType;
    }

    @Override
    public void setCompositeDn(String compositeDn) {
        this.compositeDNModel = CompositeDNModel.parseCompositeDN(compositeDn);
        this.mCompositeDn = this.compositeDNModel.getDNString();
    }

    @Override
    public String getCompositeDn() {
        return this.mCompositeDn;
    }

    @Override
    public void setCompositeName(String compositeName) {
        this.mCompositeName = compositeName;
    }

    @Override
    public String getCompositeName() {
        return this.mCompositeName;
    }

    @Override
    public void setProcessName(String processName) {
        this.mProcessName = processName;
    }

    @Override
    public String getProcessName() {
        return this.mProcessName;
    }

    @Override
    public void setFaultIsrecoverable(boolean faultIsrecoverable) {
        this.mFaultIsrecoverable = faultIsrecoverable;
    }

    @Override
    public boolean getFaultIsrecoverable() {
        return this.mFaultIsrecoverable;
    }

    @Override
    public void setFaultType(String faultType) {
        this.mFaultType = faultType;
    }

    @Override
    public String getFaultType() {
        return this.mFaultType;
    }

    @Override
    public void setFlowElementType(String flowElementType) {
        this.mFlowElementType = flowElementType;
    }

    @Override
    public String getFlowElementType() {
        return this.mFlowElementType;
    }

    @Override
    public void setInvokedComponentName(String invokedComponentName) {
        this.mInvokedComponentName = invokedComponentName;
    }

    @Override
    public String getInvokedComponentName() {
        return this.mInvokedComponentName;
    }

    @Override
    public void setLabel(String mLabel) {
        this.mLabel = mLabel;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public void setOperation(AuditInstanceOperation operation) {
        this.mOperation = operation != null ? operation.toString() : null;
    }

    @Override
    public AuditInstanceOperation getOperation() {
        return AuditInstanceOperation.valueOf(this.mOperation);
    }

    @Override
    public void setParticipant(String participant) {
        this.mParticipant = participant;
    }

    @Override
    public String getParticipant() {
        return this.mParticipant;
    }

    @Override
    public void setReferenceId(String referenceId) {
        this.mReferenceId = referenceId;
    }

    @Override
    public String getReferenceId() {
        return this.mReferenceId;
    }

    @Override
    public void setRoleId(String roleId) {
        this.mRoleId = roleId;
    }

    @Override
    public String getRoleId() {
        return this.mRoleId;
    }

    @Override
    public void setSourceActivity(String sourceActivity) {
        this.mSourceActivity = sourceActivity;
    }

    @Override
    public String getSourceActivity() {
        return this.mSourceActivity;
    }

    @Override
    public void setTargetActivity(String targetActivity) {
        this.mTargetActivity = targetActivity;
    }

    @Override
    public String getTargetActivity() {
        return this.mTargetActivity;
    }

    @Override
    public void setTitle(String title) {
        this.mTitle = title;
    }

    @Override
    public String getTitle() {
        return this.mTitle;
    }

    @Override
    public void setCreateTime(Calendar createTime) {
        this.mCreateTime = createTime;
    }

    @Override
    public Calendar getCreateTime() {
        return this.mCreateTime;
    }

    @Override
    public void setDueDate(Calendar dueDate) {
        this.mDueDate = dueDate;
    }

    @Override
    public Calendar getDueDate() {
        return this.mDueDate;
    }

    @Override
    public void setProcessDueDate(Calendar processDueDate) {
        this.mProcessDueDate = processDueDate;
    }

    @Override
    public Calendar getProcessDueDate() {
        return this.mProcessDueDate;
    }

    @Override
    public Calendar getDateValue(int slot) {
        return this.mDateValue[slot - 1];
    }

    @Override
    public void setDateValue(int slot, Calendar value) {
        this.mDateValue[slot - 1] = value;
    }

    @Override
    public BigDecimal getNumberValue(int slot) {
        return this.mNumberValue[slot - 1];
    }

    @Override
    public void setNumberValue(int slot, BigDecimal value) {
        this.mNumberValue[slot - 1] = value;
    }

    @Override
    public String getStringValue(int slot) {
        return this.mStringValue[slot - 1];
    }

    @Override
    public void setStringValue(int slot, String value) {
        this.mStringValue[slot - 1] = value;
    }

    @Override
    public void setDateValues(List<Calendar> values) {
        for (int i = 0; i < values.size(); ++i) {
            this.mDateValue[i] = values.get(i);
        }
    }

    @Override
    public void setNumberValues(List<BigDecimal> values) {
        for (int i = 0; i < values.size(); ++i) {
            this.mNumberValue[i] = values.get(i);
        }
    }

    @Override
    public void setStringValues(List<String> values) {
        for (int i = 0; i < values.size(); ++i) {
            this.mStringValue[i] = values.get(i);
        }
    }

    @Override
    public List<String> getStringValues() {
        return Arrays.asList(this.mStringValue);
    }

    @Override
    public List<BigDecimal> getNumberValues() {
        return Arrays.asList(this.mNumberValue);
    }

    @Override
    public List<Calendar> getDateValues() {
        return Arrays.asList(this.mDateValue);
    }

    @Override
    public boolean hasPayload() {
        return this.mAuditLog != null && this.mAuditLog.length > 0;
    }

    @Override
    public void addAssociatedVariable(String name) {
        if (this.mAssociatedVariables == null) {
            this.mAssociatedVariables = new ArrayList<String>();
        }
        if (!this.mAssociatedVariables.contains(name)) {
            this.mAssociatedVariables.add(name);
        }
    }

    @Override
    public void setAssociatedVariables(List<String> associatedVariables) {
        this.mAssociatedVariables = associatedVariables;
    }

    @Override
    public void setInstanceCount(Long multiInstanceCount) {
        this.mMultiInstanceCount = multiInstanceCount;
    }

    @Override
    public Long getInstanceCount() {
        return this.mMultiInstanceCount;
    }

    @Override
    public void setScopeId(String scopeId) {
        this.mScopeId = scopeId;
    }

    @Override
    public String getScopeId() {
        return this.mScopeId;
    }

    private void init(IAuditVariableMetadata metadata) {
        this.mMetadata = metadata;
        this.mVariablesAvailable = metadata != null;
        this.mDateValue = new Calendar[10];
        this.mNumberValue = new BigDecimal[30];
        this.mStringValue = new String[20];
    }

    private IAuditVariable createVariable(String name, String type, String dataType, int slot, String table, Object value) {
        IAuditVariable v = AuditVariable.newInstance();
        v.setAttribute(slot);
        v.setName(name);
        v.setTable(table);
        v.setDataType(dataType);
        v.setType(type);
        v.setValue(value);
        v.setRanges(this.mMetadata.getRanges(name));
        return v;
    }

    private Map<String, IAuditVariable> createVariableList(List<String> names) {
        HashMap<String, IAuditVariable> variables = new HashMap<String, IAuditVariable>();
        for (String name : names) {
            if (name == null || name.length() <= 0) continue;
            IAuditVariable var = this.getVariable(name);
            variables.put(name, var);
        }
        return variables;
    }

    private boolean isVariablesAvailable() {
        return this.mVariablesAvailable;
    }
}

