/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.common.logger;

import java.util.logging.Logger;
import oracle.bpm.services.common.exception.i18n.BPMExceptionList;

public enum LoggerComponent {
    COMPONENT_COMMON("oracle.bpm.common", 0, 0),
    COMPONENT_COMPOSER("oracle.bpm.composer", 20000, 29999),
    COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT("oracle.bpm.analytics.measurement", 50000, 50999),
    COMPONENT_ANALYTICS_DASHBOARD_CUBES("oracle.bpm.analytics.cubes", 51000, 51999),
    COMPONENT_ANALYTICS_DASHBOARD_DASHBOARDS("oracle.bpm.analytics.dashboards", 52000, 52999),
    COMPONENT_ANALYTICS_DASHBOARD_BAM("oracle.bpm.analytics.bam", 53000, 53999),
    COMPONENT_STUDIO("oracle.bpm.studio", 60000, 69999),
    COMPONENT_PROCESS_DASHBOARD_SERVICE("oracle.bpm.services.processDashboard", 70000, 70199),
    COMPONENT_INSTANCE_MANAGEMENT_SERVICE("oracle.bpm.services.instanceManagement", 70200, 70399),
    COMPONENT_INSTANCE_QUERY_SERVICE("oracle.bpm.services.instanceQuery", 70400, 70599),
    COMPONENT_ORGANIZATIONS_SERVICE("oracle.bpm.services.organization", 70600, 70799),
    COMPONENT_PROCESS_METADATA_SERVICE("oracle.bpm.services.processMetadata", 70800, 70999),
    COMPONENT_AG_METADATA_SERVICE("oracle.bpm.services.activityguide.metadata", 71000, 71024),
    COMPONENT_AG_QUERY_SERVICE("oracle.bpm.services.activityguide.query", 71025, 71049),
    COMPONENT_USER_AUTHENTICATION_SERVICE("oracle.bpm.services.authentication", 71050, 71199),
    COMPONENT_PROCESS_MODEL_SERVICE("oracle.bpm.services.internal.processModel", 71200, 71299),
    COMPONENT_AUDIT_CORE("oracle.bpm.bpmn.engine.service.audit", 71300, 71399),
    COMPONENT_ENGINE_DEPLOY_SCHEMA("oracle.bpm.bpmn.engine.model.deploy.schema", 71400, 71499),
    COMPONENT_PROJECT_CATALOG("oracle.bpm.project.catalog", 71500, 71699),
    COMPONENT_PROJECT_COMPILER("oracle.bpm.project.compiler", 71700, 71899),
    COMPONENT_LIBRARIES("oracle.bpm.lib", 71900, 72199);

    private final String componentName;
    private final int lower;
    private final int upper;
    private final Logger logger;

    private LoggerComponent(String componentName, int lowerRange, int upperRange) {
        this.componentName = componentName;
        this.lower = lowerRange;
        this.upper = upperRange;
        this.logger = Logger.getLogger(componentName, BPMExceptionList.class.getName());
    }

    public String getName() {
        return this.componentName;
    }

    public Logger logger() {
        return this.logger;
    }

    public static LoggerComponent getLogComponent(int errorCode) {
        for (LoggerComponent component : LoggerComponent.values()) {
            if (errorCode < component.lower || errorCode > component.upper) continue;
            return component;
        }
        return COMPONENT_COMMON;
    }
}

