/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.common.logger;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.exception.BPMExceptionContext;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public final class BPMLogger {
    private BPMLogger() {
    }

    public static void log(LoggerComponent component, Severity severity, String className, String methodName, String message) {
        Logger logger = component.logger();
        if (BPMLogger.canLog(component, severity) && message != null) {
            logger.logp(severity.level(), className, methodName, message);
        }
    }

    public static void log(LoggerComponent component, Severity severity, String message) {
        BPMLogger.log(component, severity, null, null, message);
    }

    public static void log(LoggerComponent component, Severity severity, Throwable thrown) {
        BPMLogger.log(component, severity, null, null, thrown);
    }

    public static void log(BPMException ex) {
        if (ex == null) {
            Logger logger = LoggerComponent.COMPONENT_COMMON.logger();
            logger.log(Level.SEVERE, "Cannot log exception. Exception object cannot be null");
            return;
        }
        BPMExceptionContext exCtx = ex.getExceptionContext();
        Severity severity = exCtx.getSeverity() != null ? exCtx.getSeverity() : Severity.ERRORS;
        Throwable t = exCtx.getThrowable();
        int errorCode = exCtx.getErrorCode();
        LoggerComponent component = errorCode != 0 ? LoggerComponent.getLogComponent(errorCode) : exCtx.getComponent();
        if (BPMLogger.canLog(component, severity)) {
            Logger logger = component.logger();
            logger.logp(severity.level(), exCtx.getClassName(), exCtx.getMethodName(), ex.getMessage(), t);
        }
    }

    public static void log(LoggerComponent component, Severity severity, String sourceClass, String sourceMethod, Throwable thrown) {
        if (thrown == null) {
            return;
        }
        if (BPMLogger.canLog(component, severity)) {
            Logger logger = component.logger();
            logger.logp(severity.level(), sourceClass, sourceMethod, "Exception", thrown);
        }
    }

    public static void log(LoggerComponent component, Throwable thrown) {
        BPMLogger.log(component, Severity.ERRORS, thrown);
    }

    public static void log(Throwable thrown) {
        BPMLogger.log(LoggerComponent.COMPONENT_COMMON, Severity.ERRORS, thrown);
    }

    public static boolean canLog(LoggerComponent component, Severity severity) {
        return Level.OFF != severity.level() && component.logger().isLoggable(severity.level());
    }

    public static void main(String[] args) {
        BPMLogger.test();
    }

    public static void test() {
        BPMLogger.log(LoggerComponent.COMPONENT_COMMON, Severity.WARNING, "ClassName", "MethodName", "DEBUG Message");
        BPMLogger.log(new Exception());
        BPMLogger.log(new Exception("My message"));
        new BPMException(Severity.WARNING, 70901, new Object[]{"LPG"}, null);
        BPMExceptionContext exCtx = new BPMExceptionContext();
        exCtx.setClassName("MyClass");
        exCtx.setMethodName("MyMethod");
        exCtx.setSeverity(Severity.ERRORS);
        exCtx.setErrorCode(70908);
        exCtx.setMessageArguments(new Object[]{"jcooper"});
        new BPMException(exCtx);
        new BPMException(Severity.WARNING, 70901, new Object[]{"LPG"}, new Exception("My Exception", new Exception("Another Exception", new Exception("Original Exception"))));
    }
}

