/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.common.exception;

import java.util.HashMap;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class BPMExceptionResourceBundles {
    private static final int MAX_EXCEPTION = 100000;
    private static final int START_EXCEPTION_INDEX = 1;
    private static final String LIST_BUNDLE_NAME = "oracle.bpm.services.common.exception.i18n.BPMExceptionList";
    private static final String KEY_PREFIX = "bpmExceptionList";
    private static Map<String, ListResourceBundle> sResourceBundleMap = null;
    private static Locale mListLocale = null;

    public static void setLocale(Locale locale) {
        BPMExceptionResourceBundles.loadResourceBundles(locale);
    }

    private static void loadResourceBundles(Locale locale) {
        try {
            sResourceBundleMap = new HashMap<String, ListResourceBundle>();
            int index = 1;
            while (true) {
                String bundelName = LIST_BUNDLE_NAME;
                String keyName = KEY_PREFIX + index;
                if (index != 1) {
                    bundelName = LIST_BUNDLE_NAME + index;
                }
                ++index;
                ListResourceBundle resourceBundle = (ListResourceBundle)ResourceBundle.getBundle(bundelName, locale);
                sResourceBundleMap.put(keyName, resourceBundle);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private static String getKeyName(int exceptionIndex) {
        String keyName = KEY_PREFIX;
        int size = sResourceBundleMap.size();
        int startIndex = 1;
        int endIndex = 100001;
        for (int i = 1; i <= size; ++i) {
            if (exceptionIndex >= startIndex && exceptionIndex < endIndex) {
                keyName = keyName + i;
                break;
            }
            startIndex += 100000;
            endIndex += 100000;
        }
        return keyName;
    }

    public static String getResourceString(String key) throws MissingResourceException {
        try {
            StringTokenizer tokenizer = new StringTokenizer(key, ".");
            String firstToken = tokenizer.nextToken();
            String secondToken = tokenizer.nextToken();
            int exceptionIndex = Integer.parseInt(secondToken);
            String keyName = BPMExceptionResourceBundles.getKeyName(exceptionIndex);
            ListResourceBundle resourceObj = sResourceBundleMap.get(keyName);
            if (resourceObj != null) {
                return resourceObj.getString(key);
            }
            throw new MissingResourceException(null, null, key);
        }
        catch (MissingResourceException exc) {
            throw exc;
        }
        catch (Throwable exc) {
            throw new MissingResourceException(null, null, key);
        }
    }

    static {
        BPMExceptionResourceBundles.loadResourceBundles(Locale.getDefault());
    }
}

