/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.common.exception;

import java.io.Serializable;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class BPMExceptionContext
implements Serializable {
    private LoggerComponent component = LoggerComponent.COMPONENT_COMMON;
    private String mClassName = "";
    private int mErrorCode = 0;
    private String mMessage = null;
    private Object[] mMessageArguments = null;
    private String mMethodName = "";
    private Severity mSeverity = Severity.ERRORS;
    private Throwable mThrowable = null;

    public BPMExceptionContext() {
        this.mClassName = "";
        this.mMethodName = "";
    }

    public BPMExceptionContext(Severity severity, Throwable t) {
        this.mSeverity = severity;
        this.mThrowable = t;
    }

    public BPMExceptionContext(LoggerComponent componentId, String className, String methodName) {
        this.component = componentId;
        this.mClassName = className;
        this.mMethodName = methodName;
    }

    public BPMExceptionContext(Severity severity, String className, String methodName, int errorCode, Object[] objs, Throwable t) {
        this.mSeverity = severity;
        this.mClassName = className != null ? className : "";
        this.mMethodName = methodName != null ? methodName : "";
        this.mMessageArguments = objs;
        this.mErrorCode = errorCode;
        this.mThrowable = t;
    }

    public LoggerComponent getComponent() {
        return this.component;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public void setClassName(String className) {
        this.mClassName = className;
    }

    public String getMethodName() {
        return this.mMethodName;
    }

    public void setMethodName(String methodName) {
        this.mMethodName = methodName;
    }

    public void setMessage(String message) {
        this.mMessage = message;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public void setSeverity(Severity severity) {
        this.mSeverity = severity;
    }

    public Severity getSeverity() {
        return this.mSeverity;
    }

    public void setErrorCode(int errorCode) {
        this.mErrorCode = errorCode;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    public void setMessageArguments(Object[] objs) {
        this.mMessageArguments = objs;
    }

    public Object[] getMessageArguments() {
        return this.mMessageArguments;
    }

    public void setThrowable(Throwable t) {
        this.mThrowable = t;
    }

    public Throwable getThrowable() {
        return this.mThrowable;
    }
}

