/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IAuditVariable;
import org.jetbrains.annotations.NotNull;

public class AuditTrail
implements Iterable<Node> {
    private Map<String, Node> nodes = new TreeMap<String, Node>(String.CASE_INSENSITIVE_ORDER);
    private Node rootNode;
    private static final String PATH_SEPARATOR = ":";

    private AuditTrail() {
    }

    public static AuditTrail create(List<IAuditInstance> auditInstances) {
        if (auditInstances == null) {
            throw new IllegalArgumentException("Argument auditInstances cannot be null.");
        }
        AuditTrailFactory factory = AuditTrailFactory.create();
        return factory.createAuditTrail(auditInstances);
    }

    public static AuditTrail create(Object auditInstances) {
        if (!(auditInstances instanceof List)) {
            throw new IllegalArgumentException("Argument is not of required type. Argument: '" + auditInstances + "'");
        }
        return AuditTrail.create((List)auditInstances);
    }

    public Node getNode(String id) {
        if (id == null) {
            throw new NullPointerException("Argument id can not be null.");
        }
        String nodeId = id;
        int indexOf = id.lastIndexOf(PATH_SEPARATOR);
        if (indexOf != -1) {
            nodeId = id.substring(indexOf + 1);
        }
        return this.nodes.get(nodeId);
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    @Override
    public Iterator<Node> iterator() {
        return this.getRootNode().getDescendants().iterator();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("AuditTrail : BPMN Component Instance ").append(this.getRootNode().getAuditInstance().getComponentInstanceId()).append("\n").append(this.rootNode.toString());
        return stringBuffer.toString();
    }

    private static class DummyAuditInstance
    implements IAuditInstance {
        private String activityId;
        private String activityName;
        private String activityType;
        private String auditInstanceType;
        private String componentDn;
        private String componentInstanceId;
        private String componentName;
        private String componentType;
        private String compositeInstanceId;
        private String compositeName;
        private Calendar creationTime;
        private String dn;
        private String dnApplicationName;
        private String dnCompositeName;
        private String dnLabel;
        private String dnRevision;
        private String flowElementType;
        private String label;
        private Long loopCount;
        private Long multiInstanceCount;
        private AuditInstanceOperation operation;
        private Long parentThreadId;
        private Calendar partitionDate;
        private Long priority;
        private Calendar processDueDate;
        private String processName;
        private Long queryId;
        private String roleId;
        private String scopeId;
        private Long step;
        private Long threadId;
        private String title;
        private static final long serialVersionUID = 200908041800L;

        private DummyAuditInstance() {
        }

        public static IAuditInstance create() {
            DummyAuditInstance dummyAuditInstance = new DummyAuditInstance();
            dummyAuditInstance.setQueryId(0L);
            dummyAuditInstance.setTitle("");
            dummyAuditInstance.setStep(0L);
            dummyAuditInstance.setLoopCount(0L);
            dummyAuditInstance.setActivityId("");
            dummyAuditInstance.setActivityName("");
            dummyAuditInstance.setActivityType("");
            dummyAuditInstance.setAuditInstanceType("");
            dummyAuditInstance.setComponentInstanceId("");
            dummyAuditInstance.setComponentName("");
            dummyAuditInstance.setComponentType("");
            dummyAuditInstance.setCompositeDn("");
            dummyAuditInstance.setCompositeInstanceId("");
            dummyAuditInstance.setCompositeName("");
            dummyAuditInstance.setProcessName("");
            dummyAuditInstance.setCreateTime(Calendar.getInstance());
            dummyAuditInstance.setDN("");
            dummyAuditInstance.setDNApplicationName("");
            dummyAuditInstance.setDNCompositeName("");
            dummyAuditInstance.setDNLabel("");
            dummyAuditInstance.setDNRevision("");
            dummyAuditInstance.setFlowElementType("");
            dummyAuditInstance.setLabel("");
            dummyAuditInstance.setOperation(AuditInstanceOperation.INSTANCE_CREATED);
            dummyAuditInstance.setParentThreadId(-1L);
            dummyAuditInstance.setProcessDueDate(Calendar.getInstance());
            dummyAuditInstance.setRoleId("");
            dummyAuditInstance.setThreadId(0L);
            dummyAuditInstance.setInstanceCount(0L);
            dummyAuditInstance.setScopeId("");
            return dummyAuditInstance;
        }

        public static IAuditInstance create(IAuditInstance auditInstance, String title) {
            DummyAuditInstance dummyAuditInstance = new DummyAuditInstance();
            dummyAuditInstance.setQueryId(auditInstance.getQueryId());
            dummyAuditInstance.setTitle(title);
            dummyAuditInstance.setStep(auditInstance.getStep());
            dummyAuditInstance.setLoopCount(auditInstance.getLoopCount());
            dummyAuditInstance.setActivityId(auditInstance.getActivityId());
            dummyAuditInstance.setActivityName(auditInstance.getActivityName());
            dummyAuditInstance.setActivityType(auditInstance.getActivityType());
            dummyAuditInstance.setAuditInstanceType(auditInstance.getAuditInstanceType());
            dummyAuditInstance.setComponentInstanceId(auditInstance.getComponentInstanceId());
            dummyAuditInstance.setComponentName(auditInstance.getComponentName());
            dummyAuditInstance.setComponentType(auditInstance.getComponentType());
            dummyAuditInstance.setCompositeDn(auditInstance.getCompositeDn());
            dummyAuditInstance.setCompositeInstanceId(auditInstance.getCompositeInstanceId());
            dummyAuditInstance.setCompositeName(auditInstance.getCompositeName());
            dummyAuditInstance.setProcessName(auditInstance.getProcessName());
            dummyAuditInstance.setCreateTime(auditInstance.getCreateTime());
            dummyAuditInstance.setDN(auditInstance.getDN());
            dummyAuditInstance.setDNApplicationName(auditInstance.getDNApplicationName());
            dummyAuditInstance.setDNCompositeName(auditInstance.getDNCompositeName());
            dummyAuditInstance.setDNLabel(auditInstance.getDNLabel());
            dummyAuditInstance.setDNRevision(auditInstance.getDNRevision());
            dummyAuditInstance.setFlowElementType(auditInstance.getFlowElementType());
            dummyAuditInstance.setLabel(auditInstance.getLabel());
            dummyAuditInstance.setOperation(auditInstance.getOperation());
            dummyAuditInstance.setParentThreadId(auditInstance.getParentThreadId());
            dummyAuditInstance.setProcessDueDate(auditInstance.getProcessDueDate());
            dummyAuditInstance.setRoleId(auditInstance.getRoleId());
            dummyAuditInstance.setThreadId(auditInstance.getThreadId());
            dummyAuditInstance.setInstanceCount(auditInstance.getInstanceCount());
            dummyAuditInstance.setScopeId(auditInstance.getScopeId());
            return dummyAuditInstance;
        }

        public static IAuditInstance createActivity(IAuditInstance auditInstance, String title) {
            return DummyAuditInstance.create(auditInstance, title);
        }

        public static IAuditInstance createGateway(IAuditInstance auditInstance, String title) {
            IAuditInstance dummyAuditInstance = DummyAuditInstance.create(auditInstance, title);
            dummyAuditInstance.setActivityId("");
            dummyAuditInstance.setActivityName("");
            dummyAuditInstance.setLabel("Threads");
            return dummyAuditInstance;
        }

        @Override
        public IAuditVariable getVariable(String name) {
            return null;
        }

        @Override
        public Map<String, IAuditVariable> getVariables() {
            return new TreeMap<String, IAuditVariable>();
        }

        @Override
        public Map<String, IAuditVariable> getAllVariables() {
            return Collections.emptyMap();
        }

        @Override
        public void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        @Override
        public String getActivityId() {
            return this.activityId;
        }

        @Override
        public void setActivityName(String activityName) {
            this.activityName = activityName;
        }

        @Override
        public String getActivityName() {
            return this.activityName;
        }

        @Override
        public void setActivityType(String activityType) {
            this.activityType = activityType;
        }

        @Override
        public String getActivityType() {
            return this.activityType;
        }

        @Override
        public void setAuditInstanceType(String auditInstanceType) {
            this.auditInstanceType = auditInstanceType;
        }

        @Override
        public String getAuditInstanceType() {
            return this.auditInstanceType;
        }

        @Override
        public void setComponentInstanceId(String componenetInstanceId) {
            this.componentInstanceId = componenetInstanceId;
        }

        @Override
        public String getComponentInstanceId() {
            return this.componentInstanceId;
        }

        @Override
        public void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public String getComponentName() {
            return this.componentName;
        }

        @Override
        public void setComponentType(String componentType) {
            this.componentType = componentType;
        }

        @Override
        public String getComponentType() {
            return this.componentType;
        }

        @Override
        public void setCompositeDn(String compositeDn) {
            this.componentDn = compositeDn;
        }

        @Override
        public String getCompositeDn() {
            return this.componentDn;
        }

        @Override
        public void setCompositeInstanceId(String compositeInstanceId) {
            this.compositeInstanceId = compositeInstanceId;
        }

        @Override
        public String getCompositeInstanceId() {
            return this.compositeInstanceId;
        }

        @Override
        public void setCompositeName(String compositeName) {
            this.compositeName = compositeName;
        }

        @Override
        public String getCompositeName() {
            return this.compositeName;
        }

        @Override
        public void setProcessName(String processName) {
            this.processName = processName;
        }

        @Override
        public String getProcessName() {
            return this.processName;
        }

        @Override
        public void setStep(Long step) {
            this.step = step;
        }

        @Override
        public Long getStep() {
            return this.step;
        }

        @Override
        public void setLoopCount(Long value) {
            this.loopCount = value;
        }

        @Override
        public Long getLoopCount() {
            return this.loopCount;
        }

        @Override
        public void setCreateTime(Calendar createTime) {
            this.creationTime = createTime;
        }

        @Override
        public Calendar getCreateTime() {
            return this.creationTime;
        }

        @Override
        public void setDueDate(Calendar dueDate) {
        }

        @Override
        public Calendar getDueDate() {
            return null;
        }

        @Override
        public void setFaultIsrecoverable(boolean isFailutRecoverable) {
        }

        @Override
        public boolean getFaultIsrecoverable() {
            return false;
        }

        @Override
        public void setFaultType(String faultType) {
        }

        @Override
        public String getFaultType() {
            return null;
        }

        @Override
        public void setFlowElementType(String flowElementType) {
            this.flowElementType = flowElementType;
        }

        @Override
        public String getFlowElementType() {
            return this.flowElementType;
        }

        @Override
        public void setInvokedComponentName(String invokedComponentName) {
        }

        @Override
        public String getInvokedComponentName() {
            return null;
        }

        @Override
        public void setLabel(String label) {
            this.label = label;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public void setOperation(AuditInstanceOperation operation) {
            this.operation = operation;
        }

        @Override
        public AuditInstanceOperation getOperation() {
            return this.operation;
        }

        @Override
        public void setParentThreadId(Long parentThreadId) {
            this.parentThreadId = parentThreadId;
        }

        @Override
        public Long getParentThreadId() {
            return this.parentThreadId;
        }

        @Override
        public void setParticipant(String participant) {
        }

        @Override
        public String getParticipant() {
            return null;
        }

        @Override
        public void setProcessDueDate(Calendar processDueDate) {
            this.processDueDate = processDueDate;
        }

        @Override
        public Calendar getProcessDueDate() {
            return this.processDueDate;
        }

        @Override
        public void setQueryId(Long queryId) {
            this.queryId = queryId;
        }

        @Override
        public Long getQueryId() {
            return this.queryId;
        }

        @Override
        public void setReferenceId(String referenceId) {
        }

        @Override
        public String getReferenceId() {
            return null;
        }

        @Override
        public void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        @Override
        public String getRoleId() {
            return this.roleId;
        }

        @Override
        public void setSourceActivity(String sourceActivity) {
        }

        @Override
        public String getSourceActivity() {
            return null;
        }

        @Override
        public void setTargetActivity(String targetActivity) {
        }

        @Override
        public String getTargetActivity() {
            return null;
        }

        @Override
        public void setThreadId(Long threadId) {
            this.threadId = threadId;
        }

        @Override
        public Long getThreadId() {
            return this.threadId;
        }

        @Override
        public void setTitle(String title) {
            this.title = title;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public void setAuditLog(byte[] auditLog) {
        }

        @Override
        public byte[] getAuditLog() {
            return new byte[0];
        }

        @Override
        public String getDNApplicationName() {
            return this.dnApplicationName;
        }

        @Override
        public String getDNCompositeName() {
            return this.dnCompositeName;
        }

        @Override
        public String getDN() {
            return this.dn;
        }

        @Override
        public String getDNLabel() {
            return this.dnLabel;
        }

        @Override
        public String getDNRevision() {
            return this.dnRevision;
        }

        @Override
        public void setPartitionDate(Calendar partitionDate) {
            this.partitionDate = partitionDate;
        }

        @Override
        public Calendar getPartitionDate() {
            return this.partitionDate;
        }

        @Override
        public void setPriority(Long priority) {
            this.priority = priority;
        }

        @Override
        public Long getPriority() {
            return this.priority;
        }

        @Override
        public void addAuditPayloadElement(IAuditVariable element) {
        }

        @Override
        public Map<String, IAuditVariable> getPayloadElements() {
            return Collections.emptyMap();
        }

        @Override
        public Calendar getDateValue(int slot) {
            return null;
        }

        @Override
        public void setDateValue(int slot, Calendar value) {
        }

        @Override
        public BigDecimal getNumberValue(int slot) {
            return null;
        }

        @Override
        public void setNumberValue(int slot, BigDecimal value) {
        }

        @Override
        public String getStringValue(int slot) {
            return null;
        }

        @Override
        public void setStringValue(int slot, String value) {
        }

        @Override
        public void setDateValues(List<Calendar> values) {
        }

        @Override
        public void setNumberValues(List<BigDecimal> values) {
        }

        @Override
        public void setStringValues(List<String> values) {
        }

        @Override
        public List<String> getStringValues() {
            return new ArrayList<String>();
        }

        @Override
        public List<BigDecimal> getNumberValues() {
            return new ArrayList<BigDecimal>();
        }

        @Override
        public List<Calendar> getDateValues() {
            return new ArrayList<Calendar>();
        }

        @Override
        public boolean hasPayload() {
            return false;
        }

        @Override
        public void addAssociatedVariable(String name) {
        }

        @Override
        public void setAssociatedVariables(List<String> associatedVariables) {
        }

        @Override
        public void setInstanceCount(Long multiInstanceCount) {
            this.multiInstanceCount = multiInstanceCount;
        }

        @Override
        public Long getInstanceCount() {
            return this.multiInstanceCount;
        }

        @Override
        public void setScopeId(String scopeId) {
            this.scopeId = scopeId;
        }

        @Override
        public String getScopeId() {
            return this.scopeId;
        }

        protected void setDNApplicationName(String dnApplicationName) {
            this.dnApplicationName = dnApplicationName;
        }

        protected void setDNCompositeName(String dnCompositeName) {
            this.dnCompositeName = dnCompositeName;
        }

        protected void setDN(String dn) {
            this.dn = dn;
        }

        protected void setDNLabel(String dnLabel) {
            this.dnLabel = dnLabel;
        }

        protected void setDNRevision(String dnRevision) {
            this.dnRevision = dnRevision;
        }
    }

    private static class AuditTrailFactory {
        private Map<Long, SortedSet<IAuditInstance>> auditThreads;
        private AuditTrail auditTrail;
        private Map<Long, SortedSet<Long>> childrenThreads;
        private Map<Long, Calendar> firstThreadEvent;
        private long nodeIndex;
        private Set<Long> processedThreads;

        private AuditTrailFactory() {
        }

        public static AuditTrailFactory create() {
            return new AuditTrailFactory();
        }

        public AuditTrail createAuditTrail(List<IAuditInstance> auditInstances) {
            this.auditTrail = new AuditTrail();
            if (auditInstances != null && !auditInstances.isEmpty()) {
                this.generateAuxiliarObjects(auditInstances);
                this.auditTrail.rootNode = this.generateThreadTree(null, this.auditThreads.get(0L));
            } else {
                this.auditTrail.rootNode = new Node(DummyAuditInstance.create(), NodeType.ROOT, null, 0L);
            }
            this.cleanAuxiliarObjects();
            return this.auditTrail;
        }

        public AuditTrail getAuditTrail() {
            return this.auditTrail;
        }

        private Node generateThreadTree(Node parent, SortedSet<IAuditInstance> auditInstances) {
            Node unprocessedGateway;
            IAuditInstance _auditInstance = auditInstances.first();
            this.processedThreads.add(_auditInstance.getThreadId());
            Node rootNode = this.createRootNode(parent, _auditInstance);
            this.auditTrail.nodes.put(rootNode.getId(), rootNode);
            Stack<Node> activityStack = new Stack<Node>();
            activityStack.push(rootNode);
            Node parentNode = rootNode;
            Calendar lastCreationTime = parentNode.getTimestamp();
            IAuditInstance lastAuditInstance = _auditInstance;
            for (IAuditInstance auditInstance : auditInstances) {
                switch (auditInstance.getOperation()) {
                    case INSTANCE_TERMINATED: 
                    case INSTANCE_ABORTED: 
                    case INSTANCE_SYSTEM_FAULT: 
                    case STALE_ABORTED: 
                    case STALE_COMPLETED: {
                        Node auditNode = new Node(auditInstance, NodeType.AUDIT, parentNode, ++this.nodeIndex);
                        this.auditTrail.nodes.put(auditNode.getId(), auditNode);
                        NodeEvent flowNodeEvent = this.getFlowNodeEvent(auditInstance.getOperation());
                        if (parentNode.getType() == NodeType.FLOW_ELEMENT) {
                            parentNode.setEvent(flowNodeEvent);
                            parentNode.setTimestamp(auditInstance.getCreateTime());
                        }
                        while (!activityStack.isEmpty()) {
                            parentNode = (Node)activityStack.pop();
                            if (parentNode == null) continue;
                            this.terminateInstance(parentNode, auditInstance);
                        }
                        this.terminateInstance(rootNode, auditInstance);
                        break;
                    }
                    case INSTANCE_CREATED: 
                    case FLOW_NODE_IN: {
                        unprocessedGateway = this.generateUnprocessedChildren(parentNode, auditInstance);
                        if (unprocessedGateway != null) {
                            this.auditTrail.nodes.put(unprocessedGateway.getId(), unprocessedGateway);
                            for (Node childNode : unprocessedGateway.getChildren()) {
                                childNode.setTimestamp(auditInstance.getCreateTime());
                            }
                        }
                        Node activityNode = this.createActivityNode(parentNode, auditInstance);
                        activityStack.push(parentNode);
                        parentNode = activityNode;
                        Node _node = new Node(auditInstance, NodeType.AUDIT, parentNode, ++this.nodeIndex);
                        this.auditTrail.nodes.put(_node.getId(), _node);
                        break;
                    }
                    case INSTANCE_FAULT: 
                    case FLOW_NODE_OUT: 
                    case FLOW_NODE_CANCELLED: {
                        Node _node = new Node(auditInstance, NodeType.AUDIT, parentNode, ++this.nodeIndex);
                        this.auditTrail.nodes.put(_node.getId(), _node);
                        this.terminateFlow(parentNode, auditInstance, lastCreationTime);
                        if (!activityStack.isEmpty()) {
                            parentNode = (Node)activityStack.pop();
                        }
                        if ((unprocessedGateway = this.generateUnprocessedChildren(parentNode, auditInstance)) == null) break;
                        this.auditTrail.nodes.put(unprocessedGateway.getId(), unprocessedGateway);
                        for (Node childNode : unprocessedGateway.getChildren()) {
                            childNode.setTimestamp(auditInstance.getCreateTime());
                        }
                        break;
                    }
                    default: {
                        Node _node = new Node(auditInstance, NodeType.AUDIT, parentNode, ++this.nodeIndex);
                        this.auditTrail.nodes.put(_node.getId(), _node);
                    }
                }
                lastCreationTime = auditInstance.getCreateTime();
                lastAuditInstance = auditInstance;
            }
            unprocessedGateway = this.generateNotProcessedChildren(rootNode, _auditInstance);
            if (unprocessedGateway != null) {
                this.auditTrail.nodes.put(unprocessedGateway.getId(), unprocessedGateway);
            }
            if (lastAuditInstance != null) {
                String auditInstanceType = lastAuditInstance.getAuditInstanceType();
                if (unprocessedGateway != null || auditInstanceType != null && auditInstanceType.equalsIgnoreCase("END")) {
                    this.terminateFlow(parentNode, lastAuditInstance, lastCreationTime);
                }
            }
            return rootNode;
        }

        private Node createActivityNode(Node parentNode, IAuditInstance auditInstance) {
            Node activityNode = new Node(DummyAuditInstance.create(auditInstance, auditInstance.getActivityId()), NodeType.FLOW_ELEMENT, parentNode, ++this.nodeIndex);
            activityNode.setEvent(NodeEvent.FLOW_ELEMENT_RUNNING);
            this.auditTrail.nodes.put(activityNode.getId(), activityNode);
            return activityNode;
        }

        private NodeEvent getFlowNodeEvent(AuditInstanceOperation operation) {
            switch (operation) {
                case FLOW_NODE_IN: {
                    return NodeEvent.FLOW_ELEMENT_RUNNING;
                }
                case FLOW_NODE_OUT: {
                    return NodeEvent.FLOW_ELEMENT_COMPLETED;
                }
                case FLOW_NODE_CANCELLED: {
                    return NodeEvent.FLOW_ELEMENT_CANCELLED;
                }
                case INSTANCE_ABORTED: {
                    return NodeEvent.FLOW_ELEMENT_ABORTED;
                }
                case INSTANCE_CREATED: {
                    return NodeEvent.FLOW_ELEMENT_RUNNING;
                }
                case INSTANCE_FAULT: {
                    return NodeEvent.FLOW_ELEMENT_FAULT;
                }
                case INSTANCE_SYSTEM_FAULT: {
                    return NodeEvent.FLOW_ELEMENT_SYSTEM_FAULT;
                }
                case INSTANCE_TERMINATED: {
                    return NodeEvent.FLOW_ELEMENT_COMPLETED;
                }
                case MEASUREMENT_COUNTER: {
                    return NodeEvent.FLOW_ELEMENT_COMPLETED;
                }
                case MEASUREMENT_START: {
                    return NodeEvent.FLOW_ELEMENT_RUNNING;
                }
                case MEASUREMENT_START_STOP: {
                    return NodeEvent.FLOW_ELEMENT_COMPLETED;
                }
                case MEASUREMENT_STOP: {
                    return NodeEvent.FLOW_ELEMENT_COMPLETED;
                }
                case STALE_ABORTED: {
                    return NodeEvent.FLOW_ELEMENT_ABORTED;
                }
                case STALE_COMPLETED: {
                    return NodeEvent.FLOW_ELEMENT_COMPLETED;
                }
            }
            throw new IllegalArgumentException("Invalid Audit Operation '" + operation.name() + "'");
        }

        private NodeEvent getThreadNodeEvent(AuditInstanceOperation operation) {
            switch (operation) {
                case FLOW_NODE_IN: {
                    return NodeEvent.THREAD_RUNNING;
                }
                case FLOW_NODE_OUT: {
                    return NodeEvent.THREAD_COMPLETED;
                }
                case FLOW_NODE_CANCELLED: {
                    return NodeEvent.THREAD_CANCELLED;
                }
                case INSTANCE_ABORTED: {
                    return NodeEvent.THREAD_ABORTED;
                }
                case INSTANCE_CREATED: {
                    return NodeEvent.THREAD_CREATED;
                }
                case INSTANCE_FAULT: {
                    return NodeEvent.THREAD_FAULT;
                }
                case INSTANCE_SYSTEM_FAULT: {
                    return NodeEvent.THREAD_SYSTEM_FAULT;
                }
                case INSTANCE_TERMINATED: {
                    return NodeEvent.THREAD_COMPLETED;
                }
                case MEASUREMENT_COUNTER: {
                    return NodeEvent.THREAD_COMPLETED;
                }
                case MEASUREMENT_START: {
                    return NodeEvent.THREAD_RUNNING;
                }
                case MEASUREMENT_START_STOP: {
                    return NodeEvent.THREAD_COMPLETED;
                }
                case MEASUREMENT_STOP: {
                    return NodeEvent.THREAD_COMPLETED;
                }
                case STALE_ABORTED: {
                    return NodeEvent.THREAD_ABORTED;
                }
                case STALE_COMPLETED: {
                    return NodeEvent.THREAD_COMPLETED;
                }
            }
            throw new IllegalArgumentException("Invalid Audit Operation '" + operation.name() + "'");
        }

        private NodeEvent getRootNodeEvent(AuditInstanceOperation operation) {
            switch (operation) {
                case FLOW_NODE_IN: {
                    return NodeEvent.INSTANCE_RUNNING;
                }
                case FLOW_NODE_OUT: {
                    return NodeEvent.INSTANCE_RUNNING;
                }
                case FLOW_NODE_CANCELLED: {
                    return NodeEvent.INSTANCE_TERMINATED;
                }
                case INSTANCE_ABORTED: {
                    return NodeEvent.INSTANCE_ABORTED;
                }
                case INSTANCE_CREATED: {
                    return NodeEvent.INSTANCE_CREATED;
                }
                case INSTANCE_FAULT: {
                    return NodeEvent.INSTANCE_FAULT;
                }
                case INSTANCE_SYSTEM_FAULT: {
                    return NodeEvent.INSTANCE_SYSTEM_FAULT;
                }
                case INSTANCE_TERMINATED: {
                    return NodeEvent.INSTANCE_TERMINATED;
                }
                case MEASUREMENT_COUNTER: {
                    return NodeEvent.INSTANCE_RUNNING;
                }
                case MEASUREMENT_START: {
                    return NodeEvent.INSTANCE_RUNNING;
                }
                case MEASUREMENT_START_STOP: {
                    return NodeEvent.INSTANCE_RUNNING;
                }
                case MEASUREMENT_STOP: {
                    return NodeEvent.INSTANCE_RUNNING;
                }
                case STALE_ABORTED: {
                    return NodeEvent.INSTANCE_ABORTED;
                }
                case STALE_COMPLETED: {
                    return NodeEvent.INSTANCE_TERMINATED;
                }
            }
            throw new IllegalArgumentException("Invalid Audit Operation '" + operation.name() + "'");
        }

        private void terminateInstance(Node parentNode, IAuditInstance auditInstance) {
            switch (parentNode.getType()) {
                case FLOW_ELEMENT: {
                    parentNode.setEvent(this.getFlowNodeEvent(auditInstance.getOperation()));
                    parentNode.setTimestamp(auditInstance.getCreateTime());
                    break;
                }
                case THREAD: {
                    parentNode.setEvent(this.getThreadNodeEvent(auditInstance.getOperation()));
                    parentNode.setTimestamp(auditInstance.getCreateTime());
                    break;
                }
                case ROOT: {
                    parentNode.setEvent(this.getRootNodeEvent(auditInstance.getOperation()));
                    parentNode.setTimestamp(auditInstance.getCreateTime());
                }
            }
        }

        private void terminateFlow(Node parentNode, IAuditInstance auditInstance, Calendar lastCreationTime) {
            switch (parentNode.getType()) {
                case FLOW_ELEMENT: {
                    parentNode.setEvent(this.getFlowNodeEvent(auditInstance.getOperation()));
                    parentNode.setTimestamp(lastCreationTime);
                    break;
                }
                case THREAD: {
                    parentNode.setEvent(this.getThreadNodeEvent(auditInstance.getOperation()));
                    parentNode.setTimestamp(auditInstance.getCreateTime());
                }
            }
        }

        private Node generateUnprocessedChildren(Node parentNode, @NotNull IAuditInstance auditInstance) {
            Map<Long, SortedSet<IAuditInstance>> unprocessedChildren = this.getUnprocessedChildren(auditInstance.getThreadId(), auditInstance.getQueryId());
            Node unprocessedGateway = null;
            if (!unprocessedChildren.isEmpty()) {
                unprocessedGateway = new Node(DummyAuditInstance.createGateway(auditInstance, "Gateway"), NodeType.GROUP_THREAD, parentNode, ++this.nodeIndex);
                for (SortedSet<IAuditInstance> child : unprocessedChildren.values()) {
                    unprocessedGateway.addChild(this.generateThreadTree(unprocessedGateway, child));
                }
            }
            return unprocessedGateway;
        }

        private Node generateNotProcessedChildren(Node parentNode, @NotNull IAuditInstance auditInstance) {
            Map<Long, SortedSet<IAuditInstance>> unprocessedChildren = this.getUnprocessedChildren(auditInstance.getThreadId());
            Node unprocessedGateway = null;
            if (!unprocessedChildren.isEmpty()) {
                unprocessedGateway = new Node(DummyAuditInstance.createGateway(auditInstance, "Gateway"), NodeType.GROUP_THREAD, parentNode, ++this.nodeIndex);
                for (SortedSet<IAuditInstance> child : unprocessedChildren.values()) {
                    unprocessedGateway.addChild(this.generateThreadTree(unprocessedGateway, child));
                }
            }
            return unprocessedGateway;
        }

        private Node createRootNode(Node parent, IAuditInstance auditInstance) {
            Node rootNode;
            String title = auditInstance.getComponentInstanceId();
            IAuditInstance dummyAuditInstance = DummyAuditInstance.create(auditInstance, title);
            if (parent == null) {
                rootNode = new Node(dummyAuditInstance, NodeType.ROOT, parent, ++this.nodeIndex);
                rootNode.setEvent(NodeEvent.INSTANCE_RUNNING);
                rootNode.setTimestamp(auditInstance.getCreateTime());
            } else {
                rootNode = new Node(dummyAuditInstance, NodeType.THREAD, parent, ++this.nodeIndex);
                rootNode.setEvent(NodeEvent.THREAD_RUNNING);
                rootNode.setTimestamp(auditInstance.getCreateTime());
            }
            return rootNode;
        }

        private Map<Long, SortedSet<IAuditInstance>> getUnprocessedChildren(long parentThread, long queryId) {
            HashMap<Long, SortedSet<IAuditInstance>> children = new HashMap<Long, SortedSet<IAuditInstance>>();
            if (this.childrenThreads.containsKey(parentThread)) {
                for (Long threadId : this.childrenThreads.get(parentThread)) {
                    SortedSet<IAuditInstance> auditInstances = this.auditThreads.get(threadId);
                    if (auditInstances == null || auditInstances.isEmpty()) continue;
                    IAuditInstance auditInstance = auditInstances.first();
                    if (queryId != 0L && auditInstance.getQueryId() >= queryId || this.processedThreads.contains(auditInstance.getThreadId())) continue;
                    children.put(threadId, auditInstances);
                }
            }
            return children;
        }

        private Map<Long, SortedSet<IAuditInstance>> getUnprocessedChildren(long parentThread) {
            HashMap<Long, SortedSet<IAuditInstance>> children = new HashMap<Long, SortedSet<IAuditInstance>>();
            if (this.childrenThreads.containsKey(parentThread)) {
                for (Long threadId : this.childrenThreads.get(parentThread)) {
                    IAuditInstance auditInstance;
                    SortedSet<IAuditInstance> auditInstances = this.auditThreads.get(threadId);
                    if (auditInstances == null || auditInstances.isEmpty() || this.processedThreads.contains((auditInstance = auditInstances.first()).getThreadId())) continue;
                    children.put(threadId, auditInstances);
                }
            }
            return children;
        }

        private void generateAuxiliarObjects(List<IAuditInstance> auditInstances) {
            HashMap<Long, SortedSet<IAuditInstance>> auditThreads = new HashMap<Long, SortedSet<IAuditInstance>>();
            HashMap<Long, SortedSet<Long>> childrenThreads = new HashMap<Long, SortedSet<Long>>();
            HashMap<Long, Calendar> firstThreadEvent = new HashMap<Long, Calendar>();
            for (IAuditInstance auditInstance : auditInstances) {
                TreeSet<IAuditInstance> threadAuditInstances = (TreeSet<IAuditInstance>)auditThreads.get(auditInstance.getThreadId());
                if (threadAuditInstances == null) {
                    threadAuditInstances = new TreeSet<IAuditInstance>(AuditInstanceComparator.create());
                    auditThreads.put(auditInstance.getThreadId(), threadAuditInstances);
                }
                threadAuditInstances.add(auditInstance);
                TreeSet<Long> brotherThreads = (TreeSet<Long>)childrenThreads.get(auditInstance.getParentThreadId());
                if (brotherThreads == null) {
                    brotherThreads = new TreeSet<Long>();
                    childrenThreads.put(auditInstance.getParentThreadId(), brotherThreads);
                }
                brotherThreads.add(auditInstance.getThreadId());
                Calendar firstEvent = (Calendar)firstThreadEvent.get(auditInstance.getThreadId());
                if (firstEvent != null && firstEvent.compareTo(auditInstance.getCreateTime()) <= 0) continue;
                firstThreadEvent.put(auditInstance.getThreadId(), auditInstance.getCreateTime());
            }
            this.processedThreads = new HashSet<Long>();
            this.auditThreads = auditThreads;
            this.childrenThreads = childrenThreads;
            this.firstThreadEvent = firstThreadEvent;
        }

        private void cleanAuxiliarObjects() {
            if (this.processedThreads != null) {
                this.processedThreads.clear();
            }
            if (this.auditThreads != null) {
                this.auditThreads.clear();
            }
            if (this.firstThreadEvent != null) {
                this.firstThreadEvent.clear();
            }
            if (this.childrenThreads != null) {
                this.childrenThreads.clear();
            }
            this.processedThreads = null;
            this.auditThreads = null;
            this.firstThreadEvent = null;
            this.childrenThreads = null;
            this.nodeIndex = 0L;
        }

        public static enum FlowElementType {
            SEQUENCE,
            ACTIVITY,
            GATEWAY;

        }
    }

    private static class AuditInstanceComparator
    implements Comparator<IAuditInstance>,
    Serializable {
        private static final long serialVersionUID = 2334883749398773051L;

        private AuditInstanceComparator() {
        }

        public static AuditInstanceComparator create() {
            return new AuditInstanceComparator();
        }

        @Override
        public int compare(IAuditInstance left, IAuditInstance right) {
            if (left == null || right == null) {
                throw new NullPointerException("Arguments must not be null ('" + left + "', '" + right + "').");
            }
            int compareValue = left.getCreateTime().compareTo(right.getCreateTime());
            return compareValue != 0 ? compareValue : left.getQueryId().compareTo(right.getQueryId());
        }
    }

    public static class Node
    implements Comparable<Node> {
        private IAuditInstance auditInstance;
        private Set<Node> children;
        private NodeEvent event;
        private String id;
        private long index;
        private boolean isExpanded;
        private boolean isVisible;
        private Node parent;
        private Calendar timestamp;
        private NodeType type;

        protected Node(IAuditInstance auditInstance, NodeType type, Node parent, long index) {
            this.id = type.name() + "." + auditInstance.getQueryId();
            this.auditInstance = auditInstance;
            this.type = type;
            this.parent = parent;
            this.isVisible = false;
            this.isExpanded = false;
            this.children = new TreeSet<Node>();
            this.event = NodeEvent.NONE;
            this.index = index;
            this.timestamp = auditInstance.getCreateTime();
            if (parent != null) {
                parent.addChild(this);
            }
        }

        public String getId() {
            return this.id;
        }

        public String getPath() {
            return this.parent != null ? this.parent.getPath() + AuditTrail.PATH_SEPARATOR + this.id : this.id;
        }

        public String getActivityName() {
            String label;
            switch (this.getType()) {
                case AUDIT: 
                case FLOW_ELEMENT: {
                    label = this.auditInstance.getLabel();
                    label = label == null || label.isEmpty() ? this.auditInstance.getActivityId() : label;
                    break;
                }
                default: {
                    label = "";
                }
            }
            return label;
        }

        public String getActivityType() {
            switch (this.getType()) {
                case AUDIT: {
                    return this.auditInstance.getActivityName();
                }
                case FLOW_ELEMENT: {
                    return this.auditInstance.getActivityName();
                }
            }
            return "";
        }

        public NodeEvent getEvent() {
            switch (this.getType()) {
                case AUDIT: {
                    try {
                        AuditInstanceOperation operation = this.auditInstance.getOperation();
                        this.event = operation == AuditInstanceOperation.FLOW_NODE_IN ? NodeEvent.ACTIVITY_IN : (operation == AuditInstanceOperation.FLOW_NODE_OUT ? NodeEvent.ACTIVITY_OUT : (operation == AuditInstanceOperation.FLOW_NODE_CANCELLED ? NodeEvent.FLOW_ELEMENT_CANCELLED : NodeEvent.valueOf(operation.toString())));
                    }
                    catch (IllegalArgumentException exception) {
                        this.event = NodeEvent.NONE;
                    }
                    if (this.event != null) break;
                    this.event = NodeEvent.NONE;
                }
            }
            return this.event;
        }

        public String getResponsible() {
            switch (this.getType()) {
                case AUDIT: {
                    return this.auditInstance.getParticipant();
                }
            }
            return "";
        }

        public Calendar getTimestamp() {
            switch (this.getType()) {
                case AUDIT: {
                    return this.auditInstance.getCreateTime();
                }
            }
            return this.timestamp;
        }

        public long getThread() {
            return this.auditInstance.getThreadId();
        }

        public List<Node> getChildren() {
            return new ArrayList<Node>(this.children);
        }

        public String getDescription() {
            switch (this.getType()) {
                case ROOT: {
                    return this.auditInstance.getComponentInstanceId() + " : " + this.getEvent().name();
                }
                case GROUP_THREAD: {
                    return "Group Threads";
                }
                case THREAD: {
                    return "Thread " + this.auditInstance.getThreadId() + " : " + this.getEvent().name();
                }
                case AUDIT: 
                case FLOW_ELEMENT: {
                    return this.getActivityName() + " : " + this.getEvent().name();
                }
            }
            return "";
        }

        public List<Node> getDescendants() {
            ArrayList<Node> descendants = new ArrayList<Node>();
            descendants.add(this);
            for (Node node : this.getChildren()) {
                descendants.addAll(node.getDescendants());
            }
            return descendants;
        }

        public boolean isExpanded() {
            return this.isExpanded;
        }

        public boolean isLeaf() {
            return this.getChildren().isEmpty();
        }

        public int getLevel() {
            return this.getParent() == null ? 0 : this.getParent().getLevel() + 1;
        }

        public Node getParent() {
            return this.parent;
        }

        public NodeType getType() {
            return this.type;
        }

        public boolean isVisible() {
            return this.isVisible;
        }

        public IAuditInstance getAuditInstance() {
            return this.auditInstance;
        }

        public void collapse() {
            this.isExpanded = false;
            for (Node node : this.getChildren()) {
                node.hide();
                if (!node.isExpanded()) continue;
                node.collapse();
            }
        }

        public void expand() {
            this.isExpanded = true;
            for (Node node : this.getChildren()) {
                node.show();
            }
        }

        public void expandAll() {
            this.isExpanded = true;
            for (Node node : this.getChildren()) {
                node.show();
                node.expandAll();
            }
        }

        public void hide() {
            this.isVisible = false;
        }

        public void show() {
            this.isVisible = true;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.getLevel(); ++i) {
                stringBuffer.append("\t");
            }
            stringBuffer.append(this.getId());
            stringBuffer.append(" - ");
            stringBuffer.append(this.getDescription());
            for (Node child : this.getChildren()) {
                stringBuffer.append("\n");
                stringBuffer.append(child.toString());
            }
            return stringBuffer.toString();
        }

        @Override
        public int compareTo(Node node) {
            if (node == null) {
                return 1;
            }
            return (int)(this.getIndex() - node.getIndex());
        }

        protected void addChildren(List<Node> childNodes) {
            for (Node node : childNodes) {
                this.addChild(node);
            }
        }

        protected void addChild(Node node) {
            node.parent = this;
            this.children.add(node);
        }

        protected void removeChild(Node node) {
            this.children.remove(node);
        }

        protected void setEvent(NodeEvent event) {
            this.event = event;
        }

        protected void setTimestamp(Calendar timestamp) {
            this.timestamp = timestamp;
        }

        protected long getIndex() {
            return this.index;
        }
    }

    public static enum NodeEvent {
        NONE,
        FLOW_ELEMENT_RUNNING,
        FLOW_ELEMENT_COMPLETED,
        FLOW_ELEMENT_FAULT,
        FLOW_ELEMENT_SYSTEM_FAULT,
        FLOW_ELEMENT_CANCELLED,
        FLOW_ELEMENT_ABORTED,
        THREAD_RUNNING,
        THREAD_COMPLETED,
        THREAD_ABORTED,
        THREAD_FAULT,
        THREAD_SYSTEM_FAULT,
        THREAD_CANCELLED,
        INSTANCE_CREATED,
        INSTANCE_RUNNING,
        INSTANCE_TERMINATED,
        INSTANCE_ABORTED,
        INSTANCE_FAULT,
        INSTANCE_SYSTEM_FAULT,
        THREAD_CREATED,
        ACTIVITY_IN,
        ACTIVITY_OUT,
        MEASUREMENT_START,
        MEASUREMENT_STOP,
        MEASUREMENT_START_STOP,
        MEASUREMENT_COUNTER,
        INSTANCE_ABORTING,
        INSTANCE_SUSPENDED,
        INSTANCE_RESUMED,
        INSTANCE_SELECTED,
        INSTANCE_UNSELECTED,
        INSTANCE_REASSIGNED,
        INSTANCE_GRABBED,
        INSTANCE_UNGRABBED,
        INSTANCE_BACK,
        INSTANCE_SKIP,
        SUBFLOW_INSTANCE_CREATED,
        SEQUENCE_PROCESSED,
        EVENT_PROCESSED,
        GATEWAY_PROCESSED,
        TASK_STARTED,
        TASK_FINISHED,
        TASK_SELECTED,
        TASK_UNSELECTED,
        TASK_REASSIGNED,
        FLOW_ELEMENT_INTERRUPTED;

    }

    public static enum NodeType {
        ROOT,
        FLOW_ELEMENT,
        GROUP_THREAD,
        THREAD,
        AUDIT;

    }
}

