/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard.model.impl;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.services.processdashboard.model.Condition;
import oracle.bpm.services.processdashboard.model.JoinOperator;
import oracle.bpm.services.processdashboard.model.Predicate;
import oracle.bpm.services.processdashboard.model.impl.ConditionImpl;
import oracle.bpm.services.processdashboard.model.impl.ConditionValueUtil;
import oracle.bpm.services.processdashboard.model.impl.ModelTypeFactory;
import oracle.bpm.services.processdashboard.model.jaxb.ConditionType;
import oracle.bpm.services.processdashboard.model.jaxb.JoinOperatorTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.PredicateType;
import org.jetbrains.annotations.NotNull;

public class PredicateImpl
implements Predicate {
    private PredicateType predicateType = ModelTypeFactory.getWidgetTypeFactory().createPredicateType();
    private static final long serialVersionUID = 20090824095400L;

    private PredicateImpl() {
    }

    public static PredicateImpl create() {
        return new PredicateImpl();
    }

    public static PredicateImpl create(@NotNull PredicateType predicateType) {
        PredicateImpl predicate = new PredicateImpl();
        predicate.setPredicateType(predicateType);
        return predicate;
    }

    public PredicateType getPredicateType() {
        return this.predicateType;
    }

    public void setPredicateType(@NotNull PredicateType predicateType) {
        this.predicateType = predicateType;
    }

    @Override
    public boolean hasConditions() {
        return this.predicateType.isSetConditions();
    }

    @Override
    public List<Condition> getConditions() {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (this.predicateType.isSetConditions()) {
            for (ConditionType condition : this.predicateType.getConditions()) {
                conditions.add(ConditionImpl.create(condition));
            }
        }
        return conditions;
    }

    @Override
    public void addCondition(Condition condition) {
        if (condition != null) {
            this.predicateType.getConditions().add(ModelTypeFactory.createConditionType(condition));
        }
    }

    @Override
    public void removeCondition(Condition condition) {
        if (condition != null) {
            ConditionType conditionToRemove = null;
            for (ConditionType _condition : this.predicateType.getConditions()) {
                boolean equalsValue;
                boolean equalsVariable = condition.getVariable().equalsIgnoreCase(_condition.getVariable());
                boolean equalsOperator = ModelTypeFactory.getOperatorTypeEnum(condition.getOperator()) == _condition.getOperator();
                boolean bl = equalsValue = condition.getValue() == null && _condition.getValue() == null || condition.getValue().equals(ConditionValueUtil.getObjectValue(_condition.getValue()));
                if (!equalsVariable || !equalsOperator || !equalsValue) continue;
                conditionToRemove = _condition;
                break;
            }
            if (conditionToRemove != null) {
                this.predicateType.getConditions().remove(conditionToRemove);
            }
        }
    }

    @Override
    public void cleanConditions() {
        this.predicateType.getConditions().clear();
    }

    @Override
    public boolean hasLeftCondition() {
        return this.predicateType.isSetLeftCondition();
    }

    @Override
    public Predicate getLeftCondition() {
        if (this.predicateType.isSetLeftCondition()) {
            return PredicateImpl.create(this.predicateType.getLeftCondition());
        }
        return null;
    }

    @Override
    public void setLeftCondition(Predicate predicate) {
        if (predicate == null) {
            this.predicateType.setLeftCondition(null);
        } else {
            this.predicateType.setLeftCondition(ModelTypeFactory.createPredicateType(predicate));
        }
    }

    @Override
    public boolean hasRightCondition() {
        return this.predicateType.isSetRightCondition();
    }

    @Override
    public Predicate getRightCondition() {
        if (this.predicateType.isSetRightCondition()) {
            return PredicateImpl.create(this.predicateType.getRightCondition());
        }
        return null;
    }

    @Override
    public void setRightCondition(Predicate predicate) {
        if (predicate == null) {
            this.predicateType.setRightCondition(null);
        } else {
            this.predicateType.setRightCondition(ModelTypeFactory.createPredicateType(predicate));
        }
    }

    @Override
    public boolean hasJoinOperator() {
        return this.predicateType.isSetJoinOperator();
    }

    @Override
    public JoinOperator getJoinOperator() {
        if (this.predicateType.isSetJoinOperator()) {
            return ModelTypeFactory.getJoinOperator(this.predicateType.getJoinOperator());
        }
        return null;
    }

    @Override
    public void setJoinOperator(JoinOperator joinOperator) {
        if (joinOperator == null) {
            this.predicateType.setJoinOperator(null);
        } else {
            this.predicateType.setJoinOperator(ModelTypeFactory.getJoinOperatorTypeEnum(joinOperator));
        }
    }

    public String toString() {
        return super.toString() + "[" + this.toString(this.predicateType) + "]";
    }

    private String toString(PredicateType predicateType) {
        StringBuilder toStringBuilder = new StringBuilder("");
        if (predicateType != null) {
            JoinOperatorTypeEnum joinOperator;
            boolean addJoinOperator = false;
            JoinOperatorTypeEnum joinOperatorTypeEnum = joinOperator = predicateType.isSetJoinOperator() ? predicateType.getJoinOperator() : JoinOperatorTypeEnum.AND;
            if (predicateType.isSetConditions() && !predicateType.getConditions().isEmpty()) {
                toStringBuilder.append("(");
                for (ConditionType condition : predicateType.getConditions()) {
                    if (addJoinOperator) {
                        toStringBuilder.append(" ");
                        toStringBuilder.append(joinOperator.value());
                        toStringBuilder.append(" ");
                    }
                    toStringBuilder.append(condition.getVariable());
                    toStringBuilder.append(" ");
                    toStringBuilder.append(condition.getOperator().value());
                    toStringBuilder.append(" ");
                    toStringBuilder.append(condition.getValue());
                    addJoinOperator = true;
                }
                toStringBuilder.append(")");
            }
            if (predicateType.isSetLeftCondition()) {
                if (addJoinOperator) {
                    toStringBuilder.append(" ");
                    toStringBuilder.append(joinOperator.value());
                    toStringBuilder.append(" ");
                }
                toStringBuilder.append("(");
                toStringBuilder.append(this.toString(predicateType.getLeftCondition()));
                toStringBuilder.append(")");
            }
            if (predicateType.isSetRightCondition()) {
                if (addJoinOperator) {
                    toStringBuilder.append(" ");
                    toStringBuilder.append(joinOperator.value());
                    toStringBuilder.append(" ");
                }
                toStringBuilder.append("(");
                toStringBuilder.append(this.toString(predicateType.getRightCondition()));
                toStringBuilder.append(")");
            }
        }
        return toStringBuilder.toString();
    }
}

