/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard.model.impl;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import oracle.bpel.services.workflow.common.model.PrincipleListType;
import oracle.bpel.services.workflow.common.model.PrincipleRefType;
import oracle.bpel.services.workflow.user.model.UserApplicationDataType;
import oracle.bpm.services.common.exception.BPMRuntimeException;
import oracle.bpm.services.processdashboard.model.AggregateFunction;
import oracle.bpm.services.processdashboard.model.Condition;
import oracle.bpm.services.processdashboard.model.Data;
import oracle.bpm.services.processdashboard.model.DataSource;
import oracle.bpm.services.processdashboard.model.Dimension;
import oracle.bpm.services.processdashboard.model.Dimensions;
import oracle.bpm.services.processdashboard.model.JoinOperator;
import oracle.bpm.services.processdashboard.model.Measurement;
import oracle.bpm.services.processdashboard.model.Operator;
import oracle.bpm.services.processdashboard.model.Predicate;
import oracle.bpm.services.processdashboard.model.PrincipleRef;
import oracle.bpm.services.processdashboard.model.Series;
import oracle.bpm.services.processdashboard.model.Title;
import oracle.bpm.services.processdashboard.model.ValueType;
import oracle.bpm.services.processdashboard.model.Visualization;
import oracle.bpm.services.processdashboard.model.Widget;
import oracle.bpm.services.processdashboard.model.WidgetView;
import oracle.bpm.services.processdashboard.model.impl.ConditionImpl;
import oracle.bpm.services.processdashboard.model.impl.ConditionValueUtil;
import oracle.bpm.services.processdashboard.model.impl.DataImpl;
import oracle.bpm.services.processdashboard.model.impl.DimensionsImpl;
import oracle.bpm.services.processdashboard.model.impl.MeasurementImpl;
import oracle.bpm.services.processdashboard.model.impl.PredicateImpl;
import oracle.bpm.services.processdashboard.model.impl.SeriesImpl;
import oracle.bpm.services.processdashboard.model.impl.VisualizationImpl;
import oracle.bpm.services.processdashboard.model.impl.WidgetImpl;
import oracle.bpm.services.processdashboard.model.impl.WidgetViewImpl;
import oracle.bpm.services.processdashboard.model.jaxb.AggregateFunctionTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.ConditionType;
import oracle.bpm.services.processdashboard.model.jaxb.DataSourceTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.DataType;
import oracle.bpm.services.processdashboard.model.jaxb.DimensionType;
import oracle.bpm.services.processdashboard.model.jaxb.DimensionsType;
import oracle.bpm.services.processdashboard.model.jaxb.JoinOperatorTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.MeasurementType;
import oracle.bpm.services.processdashboard.model.jaxb.ObjectFactory;
import oracle.bpm.services.processdashboard.model.jaxb.OperatorTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.PredicateType;
import oracle.bpm.services.processdashboard.model.jaxb.SeriesType;
import oracle.bpm.services.processdashboard.model.jaxb.TitleType;
import oracle.bpm.services.processdashboard.model.jaxb.ValueTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.VisualizationType;
import oracle.bpm.services.processdashboard.model.jaxb.WidgetType;
import org.jetbrains.annotations.NotNull;

public final class ModelTypeFactory {
    private static JAXBContext jaxbContext;
    private static ObjectFactory dashboardModelFactory;
    private static oracle.bpel.services.workflow.user.model.ObjectFactory userModelFactory;
    private static oracle.bpel.services.workflow.common.model.ObjectFactory workflowModelFactory;
    public static final String USER_APPLICATION_DATA_TYPE = "BAM-WIDGET";

    public static WidgetType createWidgetType(@NotNull Widget widget) {
        if (widget instanceof WidgetImpl) {
            return ((WidgetImpl)widget).getWidgetType();
        }
        WidgetType widgetType = ModelTypeFactory.getWidgetTypeFactory().createWidgetType();
        widgetType.setVisualization(ModelTypeFactory.createVisualizationType(widget.getVisualization()));
        widgetType.setData(ModelTypeFactory.createDataType(widget.getData()));
        return widgetType;
    }

    public static WidgetType createWidgetType(@NotNull String widgetXML) {
        try {
            StringReader stringReader = new StringReader(widgetXML);
            JAXBContext jaxbContext = ModelTypeFactory.getJaxbContext();
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement widgetDoc = (JAXBElement)unmarshaller.unmarshal((Reader)stringReader);
            return (WidgetType)widgetDoc.getValue();
        }
        catch (JAXBException cause) {
            throw new BPMRuntimeException(71404, new String[]{widgetXML}, cause);
        }
    }

    public static VisualizationType createVisualizationType(@NotNull Visualization visualization) {
        if (visualization instanceof VisualizationImpl) {
            return ((VisualizationImpl)visualization).getVisualizationType();
        }
        VisualizationType visualizationType = ModelTypeFactory.getWidgetTypeFactory().createVisualizationType();
        visualizationType.setType(visualization.getComponentType().name());
        visualizationType.setDefinition(visualization.getDefinition());
        for (Map.Entry<Object, Object> entry : visualization.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            visualizationType.getOtherAttributes().put(new QName(key), value);
        }
        return visualizationType;
    }

    public static DataType createDataType(@NotNull Data data) {
        if (data instanceof DataImpl) {
            return ((DataImpl)data).getDataType();
        }
        DataType dataType = ModelTypeFactory.getWidgetTypeFactory().createDataType();
        if (data.hasSeries()) {
            for (Series series : data.getSeries()) {
                dataType.getSeries().add(ModelTypeFactory.createSeriesType(series));
            }
        }
        return dataType;
    }

    public static SeriesType createSeriesType(@NotNull Series series) {
        if (series instanceof SeriesImpl) {
            return ((SeriesImpl)series).getSeriesType();
        }
        SeriesType seriesType = ModelTypeFactory.getWidgetTypeFactory().createSeriesType();
        if (series.hasDataSource()) {
            seriesType.setDataSource(ModelTypeFactory.getDataSourceTypeEnum(series.getDataSource()));
        }
        if (series.hasMeasurement()) {
            seriesType.setMeasurement(ModelTypeFactory.createMeasurementType(series.getMeasurement()));
        }
        if (series.hasDimentions()) {
            seriesType.setDimensions(ModelTypeFactory.createDimensionsType(series.getDimensions()));
        }
        if (series.hasProcess()) {
            seriesType.setProcess(series.getProcess());
        }
        if (series.hasPredicate()) {
            seriesType.setPredicate(ModelTypeFactory.createPredicateType(series.getPredicate()));
        }
        return seriesType;
    }

    public static MeasurementType createMeasurementType(@NotNull Measurement measurement) {
        if (measurement instanceof MeasurementImpl) {
            return ((MeasurementImpl)measurement).getMeasurementType();
        }
        MeasurementType measurementType = ModelTypeFactory.getWidgetTypeFactory().createMeasurementType();
        measurementType.setVariable(measurement.getVariable());
        measurementType.setAggregateFunction(ModelTypeFactory.getAggregateFunctionTypeEnum(measurement.getAggregateFunction()));
        measurementType.setValueType(ModelTypeFactory.getValueTypeEnum(measurement.getValueType()));
        return measurementType;
    }

    public static DimensionsType createDimensionsType(Dimensions dimensions) {
        if (dimensions instanceof DimensionsImpl) {
            return ((DimensionsImpl)dimensions).getDimensionsType();
        }
        DimensionsType dimensionsType = ModelTypeFactory.getWidgetTypeFactory().createDimensionsType();
        if (dimensions.hasXSeries()) {
            dimensionsType.setXSeries(ModelTypeFactory.createDimensionType(dimensions.getXSeries()));
        }
        if (dimensions.hasXGroup()) {
            dimensionsType.setXGroup(ModelTypeFactory.createDimensionType(dimensions.getXGroup()));
        }
        return dimensionsType;
    }

    public static DimensionType createDimensionType(@NotNull Dimension dimension) {
        DimensionType dimensionType = ModelTypeFactory.getWidgetTypeFactory().createDimensionType();
        dimensionType.setValue(dimension.getDimension());
        dimensionType.setUseRange(dimension.useRange());
        return dimensionType;
    }

    public static PredicateType createPredicateType(@NotNull Predicate predicate) {
        if (predicate instanceof PredicateImpl) {
            return ((PredicateImpl)predicate).getPredicateType();
        }
        PredicateType predicateType = ModelTypeFactory.getWidgetTypeFactory().createPredicateType();
        if (predicate.hasConditions()) {
            for (Condition condition : predicate.getConditions()) {
                predicateType.getConditions().add(ModelTypeFactory.createConditionType(condition));
            }
        } else {
            if (predicate.hasLeftCondition()) {
                predicateType.setLeftCondition(ModelTypeFactory.createPredicateType(predicate.getLeftCondition()));
            }
            if (predicate.hasJoinOperator()) {
                predicateType.setJoinOperator(ModelTypeFactory.getJoinOperatorTypeEnum(predicate.getJoinOperator()));
            }
            if (predicate.hasRightCondition()) {
                predicateType.setRightCondition(ModelTypeFactory.createPredicateType(predicate.getRightCondition()));
            }
        }
        return predicateType;
    }

    public static ConditionType createConditionType(@NotNull Condition condition) {
        if (condition instanceof ConditionImpl) {
            return ((ConditionImpl)condition).getConditionType();
        }
        ConditionType conditionType = ModelTypeFactory.getWidgetTypeFactory().createConditionType();
        conditionType.setVariable(condition.getVariable());
        conditionType.setOperator(ModelTypeFactory.getOperatorTypeEnum(condition.getOperator()));
        conditionType.setValue(ConditionValueUtil.getStringValue(condition.getValue()));
        return conditionType;
    }

    public static UserApplicationDataType createUserApplicationDataType(@NotNull WidgetView widgetView) {
        if (widgetView instanceof WidgetViewImpl) {
            return ((WidgetViewImpl)widgetView).getUserApplicationDataType();
        }
        UserApplicationDataType userApplicationDataType = ModelTypeFactory.getUserModelFactory().createUserApplicationDataType();
        userApplicationDataType.setId(widgetView.getId());
        userApplicationDataType.setName(widgetView.getName());
        userApplicationDataType.setOwner(widgetView.getOwner());
        userApplicationDataType.setApplicationDataType(USER_APPLICATION_DATA_TYPE);
        userApplicationDataType.setGrantees(ModelTypeFactory.createPrincipleListType(widgetView.getGrantees()));
        userApplicationDataType.setData(ModelTypeFactory.getXMLFromWidget(ModelTypeFactory.createWidgetType(widgetView.getWidget())));
        return userApplicationDataType;
    }

    public static UserApplicationDataType createStandardUserApplicationDataType(String id, String name, WidgetType widget) {
        UserApplicationDataType userApplicationDataType = ModelTypeFactory.getUserModelFactory().createUserApplicationDataType();
        userApplicationDataType.setId(id);
        userApplicationDataType.setName(name);
        userApplicationDataType.setOwner("");
        userApplicationDataType.setApplicationDataType(USER_APPLICATION_DATA_TYPE);
        userApplicationDataType.setData(ModelTypeFactory.getXMLFromWidget(widget));
        return userApplicationDataType;
    }

    public static PrincipleListType createPrincipleListType(@NotNull Collection<PrincipleRef> priciples) {
        PrincipleListType principleListType = ModelTypeFactory.getWorkflowModelFactory().createPrincipleListType();
        if (!priciples.isEmpty()) {
            for (PrincipleRef principleRef : priciples) {
                principleListType.getParticipant().add(ModelTypeFactory.createPrincipleRefType(principleRef));
            }
        }
        return principleListType;
    }

    public static PrincipleRefType createPrincipleRefType(@NotNull PrincipleRef principleRef) {
        PrincipleRefType principleRefType = ModelTypeFactory.getWorkflowModelFactory().createPrincipleRefType();
        principleRefType.setName(principleRef.getName());
        principleRefType.setRealm(principleRef.getRealm());
        principleRefType.setType(principleRef.getType());
        return principleRefType;
    }

    public static TitleType createTitleType(@NotNull Title title) {
        TitleType titleType = ModelTypeFactory.getWidgetTypeFactory().createTitleType();
        titleType.setLang(title.getLocale().getLanguage());
        titleType.setValue(title.getValue());
        return titleType;
    }

    public static String getXMLFromWidget(@NotNull WidgetType widgetType) {
        try {
            ObjectFactory widgetFactory = new ObjectFactory();
            StringWriter writer = new StringWriter();
            JAXBContext jaxbContext = ModelTypeFactory.getJaxbContext();
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal(widgetFactory.createWidget(widgetType), (Writer)writer);
            writer.flush();
            return writer.toString();
        }
        catch (JAXBException cause) {
            throw new BPMRuntimeException(71405, new String[0], cause);
        }
    }

    public static ObjectFactory getWidgetTypeFactory() {
        if (dashboardModelFactory == null) {
            dashboardModelFactory = new ObjectFactory();
        }
        return dashboardModelFactory;
    }

    public static DataSourceTypeEnum getDataSourceTypeEnum(DataSource dataSource) {
        switch (dataSource) {
            case CUBE_PROCESS_PERFORMANCE: {
                return DataSourceTypeEnum.CUBE_PROCESS_PERFORMANCE;
            }
            case CUBE_TASK_PERFORMANCE: {
                return DataSourceTypeEnum.CUBE_TASK_PERFORMANCE;
            }
            case CUBE_WORKLOAD: {
                return DataSourceTypeEnum.CUBE_WORKLOAD;
            }
        }
        return DataSourceTypeEnum.CUBE_WORKLOAD;
    }

    public static DataSource getDataSource(DataSourceTypeEnum dataSourceTypeEnum) {
        switch (dataSourceTypeEnum) {
            case CUBE_PROCESS_PERFORMANCE: {
                return DataSource.CUBE_PROCESS_PERFORMANCE;
            }
            case CUBE_TASK_PERFORMANCE: {
                return DataSource.CUBE_TASK_PERFORMANCE;
            }
            case CUBE_WORKLOAD: {
                return DataSource.CUBE_WORKLOAD;
            }
        }
        return DataSource.CUBE_WORKLOAD;
    }

    public static AggregateFunctionTypeEnum getAggregateFunctionTypeEnum(AggregateFunction aggregateFunction) {
        switch (aggregateFunction) {
            case AVG: {
                return AggregateFunctionTypeEnum.AVG;
            }
            case SUM: {
                return AggregateFunctionTypeEnum.SUM;
            }
            case MIN: {
                return AggregateFunctionTypeEnum.MIN;
            }
            case MAX: {
                return AggregateFunctionTypeEnum.MAX;
            }
            case COUNT: {
                return AggregateFunctionTypeEnum.COUNT;
            }
        }
        return AggregateFunctionTypeEnum.AVG;
    }

    public static AggregateFunction getAggregateFunction(AggregateFunctionTypeEnum aggregateFunctionTypeEnum) {
        switch (aggregateFunctionTypeEnum) {
            case AVG: {
                return AggregateFunction.AVG;
            }
            case SUM: {
                return AggregateFunction.SUM;
            }
            case MIN: {
                return AggregateFunction.MIN;
            }
            case MAX: {
                return AggregateFunction.MAX;
            }
            case COUNT: {
                return AggregateFunction.COUNT;
            }
        }
        return AggregateFunction.AVG;
    }

    public static ValueTypeEnum getValueTypeEnum(ValueType valueType) {
        switch (valueType) {
            case AUTOMATIC_HANDLE_DATE: {
                return ValueTypeEnum.AUTOMATIC_HANDLE_DATE;
            }
            case DAYS: {
                return ValueTypeEnum.DAYS;
            }
            case HOURS: {
                return ValueTypeEnum.HOURS;
            }
            case MINUTES: {
                return ValueTypeEnum.MINUTES;
            }
            case PERCENTAGE: {
                return ValueTypeEnum.PERCENTAGE;
            }
            case SECONDS: {
                return ValueTypeEnum.SECONDS;
            }
        }
        return ValueTypeEnum.VALUE;
    }

    public static ValueType getValueType(ValueTypeEnum valueTypeEnum) {
        switch (valueTypeEnum) {
            case AUTOMATIC_HANDLE_DATE: {
                return ValueType.AUTOMATIC_HANDLE_DATE;
            }
            case DAYS: {
                return ValueType.DAYS;
            }
            case HOURS: {
                return ValueType.HOURS;
            }
            case MINUTES: {
                return ValueType.MINUTES;
            }
            case PERCENTAGE: {
                return ValueType.PERCENTAGE;
            }
            case SECONDS: {
                return ValueType.SECONDS;
            }
        }
        return ValueType.VALUE;
    }

    public static OperatorTypeEnum getOperatorTypeEnum(Operator operator) {
        switch (operator) {
            case AFTER: {
                return OperatorTypeEnum.AFTER;
            }
            case BEFORE: {
                return OperatorTypeEnum.BEFORE;
            }
            case BEGIN_WITH: {
                return OperatorTypeEnum.BEGIN_WITH;
            }
            case CONTAINS: {
                return OperatorTypeEnum.CONTAINS;
            }
            case END_WITH: {
                return OperatorTypeEnum.END_WITH;
            }
            case EQUALS: {
                return OperatorTypeEnum.EQUALS;
            }
            case GRATER_OR_EQUALS: {
                return OperatorTypeEnum.GRATER_OR_EQUALS;
            }
            case GRATER_THAN: {
                return OperatorTypeEnum.GRATER_THAN;
            }
            case IN: {
                return OperatorTypeEnum.IN;
            }
            case LESS_OR_EQUALS: {
                return OperatorTypeEnum.LESS_OR_EQUALS;
            }
            case LESS_THAN: {
                return OperatorTypeEnum.LESS_THAN;
            }
            case NOT_BEGIN_WITH: {
                return OperatorTypeEnum.NOT_BEGIN_WITH;
            }
            case NOT_CONTAINS: {
                return OperatorTypeEnum.NOT_CONTAINS;
            }
            case NOT_END_WITH: {
                return OperatorTypeEnum.NOT_END_WITH;
            }
            case NOT_EQUALS: {
                return OperatorTypeEnum.NOT_EQUALS;
            }
        }
        return OperatorTypeEnum.EQUALS;
    }

    public static Operator getOperator(OperatorTypeEnum operatorTypeEnum) {
        switch (operatorTypeEnum) {
            case AFTER: {
                return Operator.AFTER;
            }
            case BEFORE: {
                return Operator.BEFORE;
            }
            case BEGIN_WITH: {
                return Operator.BEGIN_WITH;
            }
            case CONTAINS: {
                return Operator.CONTAINS;
            }
            case END_WITH: {
                return Operator.END_WITH;
            }
            case EQUALS: {
                return Operator.EQUALS;
            }
            case GRATER_OR_EQUALS: {
                return Operator.GRATER_OR_EQUALS;
            }
            case GRATER_THAN: {
                return Operator.GRATER_THAN;
            }
            case IN: {
                return Operator.IN;
            }
            case LESS_OR_EQUALS: {
                return Operator.LESS_OR_EQUALS;
            }
            case LESS_THAN: {
                return Operator.LESS_THAN;
            }
            case NOT_BEGIN_WITH: {
                return Operator.NOT_BEGIN_WITH;
            }
            case NOT_CONTAINS: {
                return Operator.NOT_CONTAINS;
            }
            case NOT_END_WITH: {
                return Operator.NOT_END_WITH;
            }
            case NOT_EQUALS: {
                return Operator.NOT_EQUALS;
            }
        }
        return Operator.EQUALS;
    }

    public static JoinOperatorTypeEnum getJoinOperatorTypeEnum(JoinOperator joinOperator) {
        switch (joinOperator) {
            case AND: {
                return JoinOperatorTypeEnum.AND;
            }
            case OR: {
                return JoinOperatorTypeEnum.OR;
            }
        }
        return JoinOperatorTypeEnum.AND;
    }

    public static JoinOperator getJoinOperator(JoinOperatorTypeEnum joinOperatorTypeEnum) {
        switch (joinOperatorTypeEnum) {
            case AND: {
                return JoinOperator.AND;
            }
            case OR: {
                return JoinOperator.OR;
            }
        }
        return JoinOperator.AND;
    }

    public static oracle.bpel.services.workflow.user.model.ObjectFactory getUserModelFactory() {
        if (userModelFactory == null) {
            userModelFactory = new oracle.bpel.services.workflow.user.model.ObjectFactory();
        }
        return userModelFactory;
    }

    public static oracle.bpel.services.workflow.common.model.ObjectFactory getWorkflowModelFactory() {
        if (workflowModelFactory == null) {
            workflowModelFactory = new oracle.bpel.services.workflow.common.model.ObjectFactory();
        }
        return workflowModelFactory;
    }

    private static JAXBContext getJaxbContext() throws JAXBException {
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((String)WidgetType.class.getPackage().getName());
        }
        return jaxbContext;
    }
}

