/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard.model.impl;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.services.processdashboard.model.jaxb.ConditionType;

public class ConditionValueUtil {
    private static final String VALUE_CLASS_SEPARATOR = "#!";

    public static Object getObjectValue(String value) {
        if (value == null) {
            return value;
        }
        String stringValue = value;
        int indexOf = stringValue.lastIndexOf(VALUE_CLASS_SEPARATOR);
        if (indexOf < 0) {
            return stringValue;
        }
        int startClazz = indexOf + VALUE_CLASS_SEPARATOR.length();
        String clazz = String.class.getName();
        if (startClazz < stringValue.length()) {
            clazz = stringValue.substring(startClazz);
        }
        stringValue = stringValue.substring(0, indexOf);
        if (Boolean.class.getName().equals(clazz)) {
            return Boolean.valueOf(stringValue);
        }
        if (Integer.class.getName().equals(clazz)) {
            return Integer.valueOf(stringValue);
        }
        if (Long.class.getName().equals(clazz)) {
            return Long.valueOf(stringValue);
        }
        if (Float.class.getName().equals(clazz)) {
            return Float.valueOf(stringValue);
        }
        if (Double.class.getName().equals(clazz)) {
            return Double.valueOf(stringValue);
        }
        if (BigDecimal.class.getName().equals(clazz)) {
            return new BigDecimal(stringValue);
        }
        if (Date.class.getName().equals(clazz)) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, Locale.ENGLISH);
            try {
                return dateFormat.parse(stringValue);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid date format '" + stringValue + "'");
            }
        }
        if (Time.class.getName().equals(clazz)) {
            return Time.valueOf((String)stringValue);
        }
        if (Interval.class.getName().equals(clazz)) {
            return Interval.valueOf((String)stringValue);
        }
        return stringValue;
    }

    public static Object getObjectValue(ConditionType condition) {
        if (condition == null) {
            return null;
        }
        if (!condition.isSetValue()) {
            return null;
        }
        return ConditionValueUtil.getObjectValue(condition.getValue());
    }

    public static String getStringValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, Locale.ENGLISH);
            return dateFormat.format((Date)value) + VALUE_CLASS_SEPARATOR + Date.class.getName();
        }
        if (value instanceof Calendar) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, Locale.ENGLISH);
            return dateFormat.format(((Calendar)value).getTime()) + VALUE_CLASS_SEPARATOR + Date.class.getName();
        }
        return value.toString() + VALUE_CLASS_SEPARATOR + value.getClass().getName();
    }

    public static String getObjectStringValue(ConditionType condition) {
        if (condition == null) {
            return null;
        }
        if (!condition.isSetValue()) {
            return null;
        }
        return ConditionValueUtil.getObjectStringValue(condition.getValue());
    }

    public static String getObjectStringValue(String value) {
        Object objectValue = ConditionValueUtil.getObjectValue(value);
        return objectValue == null ? null : objectValue.toString();
    }
}

