/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.instancequery.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancequery.IAuditVariableMetadata;
import oracle.bpm.services.instancequery.IAuditVariableRange;

public class AuditVariableMetadata
implements IAuditVariableMetadata,
Serializable {
    private List<IAuditVariableRange> mAllRanges;
    private String mCompositeDn;
    private List<String> mDateNames = new ArrayList<String>(10);
    private List<String> mDateTypes = new ArrayList<String>(10);
    private int mNextDate = 0;
    private int mNextNumber = 0;
    private int mNextString = 0;
    private List<String> mNumberNames = new ArrayList<String>(30);
    private List<String> mNumberTypes = new ArrayList<String>(30);
    private List<String> mStringNames = new ArrayList<String>(20);
    private List<String> mStringTypes = new ArrayList<String>(20);
    private static final String logClassName = AuditVariableMetadata.class.getName();
    static final long serialVersionUID = -7292044011617931550L;

    private AuditVariableMetadata() {
        this.mAllRanges = new ArrayList<IAuditVariableRange>();
    }

    public static IAuditVariableMetadata newInstance() {
        return new AuditVariableMetadata();
    }

    @Override
    public void addDateVariable(String name, String type) {
        String logMethodName = "addDateVariable";
        BPMLogger.log(LoggerComponent.COMPONENT_AUDIT_CORE, Severity.DEBUG, logClassName, "addDateVariable", "Adding {" + name + "} to slot {" + (this.mNextDate + 1) + "}");
        this.mDateNames.add(this.mNextDate, name);
        this.mDateTypes.add(this.mNextDate, type);
        ++this.mNextDate;
    }

    @Override
    public void addNumberVariable(String name, String type) {
        String logMethodName = "addNumberVariable";
        BPMLogger.log(LoggerComponent.COMPONENT_AUDIT_CORE, Severity.DEBUG, logClassName, "addNumberVariable", "Adding {" + name + "} to slot {" + (this.mNextNumber + 1) + "}");
        this.mNumberNames.add(this.mNextNumber, name);
        this.mNumberTypes.add(this.mNextNumber, type);
        ++this.mNextNumber;
    }

    @Override
    public void addStringVariable(String name, String type) {
        String logMethodName = "addStringVariable";
        BPMLogger.log(LoggerComponent.COMPONENT_AUDIT_CORE, Severity.DEBUG, logClassName, "addStringVariable", "Adding {" + name + "} to slot {" + (this.mNextString + 1) + "}");
        this.mStringNames.add(this.mNextString, name);
        this.mStringTypes.add(this.mNextString, type);
        ++this.mNextString;
    }

    @Override
    public void setCompositeDn(String mCompositeDn) {
        this.mCompositeDn = mCompositeDn;
    }

    @Override
    public String getCompositeDn() {
        return this.mCompositeDn;
    }

    @Override
    public List<String> getNumberNames() {
        return this.mNumberNames;
    }

    @Override
    public String getNumberType(int slot) {
        return this.mNumberTypes.get(slot - 1);
    }

    @Override
    public List<String> getNumberTypes() {
        return this.mNumberTypes;
    }

    @Override
    public List<String> getStringNames() {
        return this.mStringNames;
    }

    @Override
    public String getStringType(int slot) {
        return this.mStringTypes.get(slot - 1);
    }

    @Override
    public List<String> getStringTypes() {
        return this.mStringTypes;
    }

    @Override
    public List<String> getDateNames() {
        return this.mDateNames;
    }

    @Override
    public String getDateType(int slot) {
        return this.mDateTypes.get(slot - 1);
    }

    @Override
    public List<String> getDateTypes() {
        return this.mDateTypes;
    }

    @Override
    public void setDateNames(List<String> names) {
        this.mDateNames.clear();
        for (int i = 0; i < names.size(); ++i) {
            this.mDateNames.add(i, names.get(i));
        }
    }

    @Override
    public void setNumberNames(List<String> names) {
        this.mNumberNames.clear();
        for (int i = 0; i < names.size(); ++i) {
            this.mNumberNames.add(i, names.get(i));
        }
    }

    @Override
    public void setStringNames(List<String> names) {
        this.mStringNames.clear();
        for (int i = 0; i < names.size(); ++i) {
            this.mStringNames.add(i, names.get(i));
        }
    }

    @Override
    public String getNumberName(int slot) {
        return this.mNumberNames.get(slot - 1);
    }

    @Override
    public String getStringName(int slot) {
        return this.mStringNames.get(slot - 1);
    }

    @Override
    public String getDateName(int slot) {
        return this.mDateNames.get(slot - 1);
    }

    @Override
    public void setDateName(int slot, String name) {
        this.mDateNames.set(slot - 1, name);
    }

    @Override
    public void setDateType(int slot, String type) {
        this.mDateTypes.set(slot - 1, type);
    }

    @Override
    public void setNumberName(int slot, String name) {
        this.mNumberNames.set(slot - 1, name);
    }

    @Override
    public void setNumberType(int slot, String type) {
        this.mNumberTypes.set(slot - 1, type);
    }

    @Override
    public void setStringName(int slot, String name) {
        this.mStringNames.set(slot - 1, name);
    }

    @Override
    public void setStringType(int slot, String type) {
        this.mStringTypes.set(slot - 1, type);
    }

    @Override
    public void setDateTypes(List<String> types) {
        this.mDateTypes.clear();
        for (int i = 0; i < types.size(); ++i) {
            this.mDateTypes.add(i, types.get(i));
        }
    }

    @Override
    public void setNumberTypes(List<String> types) {
        this.mNumberTypes.clear();
        for (int i = 0; i < types.size(); ++i) {
            this.mNumberTypes.add(i, types.get(i));
        }
    }

    @Override
    public void setStringTypes(List<String> types) {
        this.mStringTypes.clear();
        for (int i = 0; i < types.size(); ++i) {
            this.mStringTypes.add(i, types.get(i));
        }
    }

    @Override
    public int getSlot(String name) {
        int result = this.getNumberNames().indexOf(name);
        if (result < 0 && (result = this.getStringNames().indexOf(name)) < 0) {
            result = this.getDateNames().indexOf(name);
        }
        return ++result;
    }

    public String getDataType(String name) {
        int slot = this.getNumberNames().indexOf(name);
        if (slot > -1) {
            return "NUMBER";
        }
        slot = this.getStringNames().indexOf(name);
        if (slot > -1) {
            return "STRING";
        }
        slot = this.getDateNames().indexOf(name);
        if (slot > -1) {
            return "DATE";
        }
        return null;
    }

    @Override
    public void setAllRanges(List<IAuditVariableRange> allRanges) {
        this.mAllRanges = allRanges;
    }

    @Override
    public List<IAuditVariableRange> getRanges(String name) {
        ArrayList<IAuditVariableRange> result = new ArrayList<IAuditVariableRange>();
        for (IAuditVariableRange r : this.mAllRanges) {
            if (!r.getVarLabel().equals(name)) continue;
            result.add(r);
        }
        return result;
    }
}

