/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.instancemanagement.model.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import oracle.bpel.services.workflow.task.model.AttachmentType;
import oracle.bpel.services.workflow.task.model.CallbackType;
import oracle.bpel.services.workflow.task.model.CommentType;
import oracle.bpel.services.workflow.task.model.ObjectFactory;
import oracle.bpel.services.workflow.task.model.ProcessType;
import oracle.bpel.services.workflow.task.model.ScaType;
import oracle.bpel.services.workflow.task.model.SystemAttributesType;
import oracle.bpel.services.workflow.task.model.SystemMessageAttributesType;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpm.services.instancemanagement.model.IIdentityType;
import oracle.bpm.services.instancemanagement.model.IProcessAttachment;
import oracle.bpm.services.instancemanagement.model.IProcessComment;
import oracle.bpm.services.instancemanagement.model.IProcessFlexAttributes;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.bpm.services.instancemanagement.model.IProcessSystemAttributes;
import oracle.bpm.services.instancemanagement.model.impl.IdentityType;
import oracle.bpm.services.instancemanagement.model.impl.ProcessAttachment;
import oracle.bpm.services.instancemanagement.model.impl.ProcessComment;
import oracle.bpm.services.instancemanagement.model.impl.ProcessFlexAttributes;
import oracle.bpm.services.instancemanagement.model.impl.ProcessSystemAttributes;

public class ProcessInstance
implements IProcessInstance {
    private IProcessSystemAttributes mSysAttribute = null;
    private IProcessFlexAttributes mSysMessageAttr = null;
    private Task mTask = null;
    private List<IIdentityType> mRemoveAssignees = null;
    private static final long serialVersionUID = 7702082600083241468L;

    public ProcessInstance() {
        ObjectFactory factory = new ObjectFactory();
        this.mTask = factory.createTask();
        this.initProcessInstance();
    }

    public ProcessInstance(Task task) {
        this.mTask = task;
        this.initProcessInstance();
    }

    @Override
    public void setTitle(String value) {
        this.mTask.setTitle(value);
    }

    @Override
    public String getTitle() {
        return this.mTask.getTitle();
    }

    @Override
    public void setCreator(String value) {
        this.mTask.setCreator(value);
    }

    @Override
    public String getCreator() {
        return this.mTask.getCreator();
    }

    @Override
    public void setOwner(String value, IIdentityType.IDENTITY_TYPE type) {
        if (type == null || type.equals((Object)IIdentityType.IDENTITY_TYPE.USER)) {
            this.mTask.setOwnerUser(value);
        } else if (type.equals((Object)IIdentityType.IDENTITY_TYPE.GROUP)) {
            this.mTask.setOwnerGroup(value);
        } else {
            this.mTask.setOwnerRole(value);
        }
    }

    @Override
    public String getOwner() {
        String owner = this.mTask.getOwnerUser();
        if (owner == null) {
            owner = this.mTask.getOwnerGroup();
        }
        if (owner == null) {
            owner = this.mTask.getOwnerGroup();
        }
        return owner;
    }

    @Override
    public void setCubeInstanceId(String value) {
        this.mTask.getProcessInfo().setInstanceId(value);
    }

    @Override
    public String getCubeInstanceId() {
        return this.mTask.getProcessInfo().getInstanceId();
    }

    @Override
    public List<IProcessComment> getUserComment() {
        List commentTypes = this.mTask.getUserComment();
        ArrayList<IProcessComment> processComment = new ArrayList<IProcessComment>(commentTypes.size());
        for (int i = 0; i < commentTypes.size(); ++i) {
            processComment.add(new ProcessComment((CommentType)commentTypes.get(i)));
        }
        return processComment;
    }

    @Override
    public List<IProcessAttachment> getAttachment() {
        List attTypes = this.mTask.getAttachment();
        ArrayList<IProcessAttachment> processAtt = new ArrayList<IProcessAttachment>(attTypes.size());
        for (int i = 0; i < attTypes.size(); ++i) {
            processAtt.add(new ProcessAttachment((AttachmentType)attTypes.get(i)));
        }
        return processAtt;
    }

    @Override
    public void setStartDate(Calendar value) {
        this.mTask.setStartDate(value);
    }

    @Override
    public void setSca(ScaType value) {
        this.mTask.setSca(value);
    }

    @Override
    public ScaType getSca() {
        return this.mTask.getSca();
    }

    @Override
    public CallbackType getCallback() {
        return this.mTask.getCallback();
    }

    @Override
    public IProcessSystemAttributes getSystemAttributes() {
        return this.mSysAttribute;
    }

    @Override
    public IProcessFlexAttributes getFlexAttributes() {
        return this.mSysMessageAttr;
    }

    public Task getTask() {
        return this.mTask;
    }

    public void setTask(Task task) {
        this.mTask = task;
        this.initProcessInstance();
    }

    @Override
    public String getProcessDN() {
        return this.mTask.getTaskDefinitionId();
    }

    @Override
    public void setProcessDN(String dn) {
        this.mTask.setTaskDefinitionId(dn);
    }

    @Override
    public void setIdentityContext(String context) {
        this.mTask.setIdentityContext(context);
    }

    @Override
    public String getIdentityContext() {
        return this.mTask.getIdentityContext();
    }

    @Override
    public void setApplicationContext(String context) {
        this.mTask.setApplicationContext(context);
    }

    @Override
    public String getApplicationContext() {
        return this.mTask.getApplicationContext();
    }

    @Override
    public void setPriority(int priority) {
        this.mTask.setPriority(priority);
    }

    @Override
    public int getPriority() {
        return this.mTask.getPriority();
    }

    private void initProcessInstance() {
        oracle.bpel.services.workflow.task.model.IdentityType itype;
        ObjectFactory mFactory = new ObjectFactory();
        ProcessType pType = this.mTask.getProcessInfo();
        SystemAttributesType sType = this.mTask.getSystemAttributes();
        SystemMessageAttributesType smType = this.mTask.getSystemMessageAttributes();
        if (pType == null || sType == null || smType == null) {
            if (pType == null) {
                this.mTask.setProcessInfo(mFactory.createProcessType());
            }
            if (sType == null) {
                sType = mFactory.createSystemAttributesType();
                this.mTask.setSystemAttributes(sType);
            }
            if (smType == null) {
                smType = mFactory.createSystemMessageAttributesType();
                this.mTask.setSystemMessageAttributes(smType);
            }
        }
        if ((itype = sType.getUpdatedBy()) == null) {
            itype = mFactory.createIdentityType();
            sType.setUpdatedBy(itype);
        }
        sType.setComponentType("BPMN");
        this.mSysAttribute = new ProcessSystemAttributes(sType);
        this.mSysMessageAttr = new ProcessFlexAttributes(smType);
        this.mSysAttribute.setUpdatedBy(new IdentityType(sType.getUpdatedBy()));
    }

    @Override
    public List<IIdentityType> getRemoveAssignees() {
        return this.mRemoveAssignees;
    }

    @Override
    public void setRemoveAssignees(List<IIdentityType> assignees) {
        this.mRemoveAssignees = assignees;
    }
}

