/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.wizards.ui;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.GradientPattern;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;

public class WizardTitlePanel
extends Panel {
    private Msg description;
    private HeaderLabel headerLabel;
    private Color left = Color.valueOf(254, 254, 254);
    private Color right = Color.valueOf(206, 223, 230);

    public WizardTitlePanel(UiContainer parent, Image icon) {
        super(parent);
        this.setOpaque(false);
        this.setLayout(new MigLayout("insets 5 10 0 0"));
        this.headerLabel = new HeaderLabel(this);
        this.add(this.headerLabel);
    }

    @Override
    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        g.setPattern(new GradientPattern(0, 0, this.left, width, 0, this.right));
        g.fillRect(0, 0, width, this.getHeight());
        super.paintComponent(g);
    }

    @Override
    public Dimension getPreferredSize() {
        return Dimension.valueOf(200, 50);
    }

    public void setDescription(Msg msg) {
        this.description = msg;
    }

    public void setDescription(String msg) {
        this.description = UIMsg.TO_MSG(msg);
    }

    public void setTitle(Msg msg) {
        this.headerLabel.setText(msg);
    }

    public void setTitle(String msg) {
        this.headerLabel.setText(msg);
    }

    private class HeaderLabel
    extends Label {
        public HeaderLabel(UiContainer parent) {
            super(parent);
            this.setOpaque(false);
            Font font = this.getFont();
            this.setFont(font.bold().scale(1.3f));
        }
    }
}

