/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.wizards.ui;

import oracle.bpm.ui.Button;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.util.ExceptionFormatter;

public class ErrorPanel
extends Panel
implements ActionListener {
    private TextArea descTextArea;
    private Button detailBtn;
    private LabelMultiline msgTextArea;

    public ErrorPanel(UiContainer parent) {
        super(parent);
        this.build();
    }

    public void setThrowable(Throwable throwable) {
        this.msgTextArea.setMsg(UIMsg.TO_MSG(throwable.getMessage()));
        this.descTextArea.setText(ExceptionFormatter.fullTechLevel(throwable));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.descTextArea.isVisible()) {
            this.descTextArea.setVisible(true);
            this.detailBtn.setIcon(UIMsg.UP_ARROW);
        } else {
            this.descTextArea.setVisible(false);
            this.detailBtn.setIcon(UIMsg.DOWN_ARROW);
        }
    }

    private void build() {
        RelativeLayout layout = new RelativeLayout();
        this.setLayout(layout);
        this.msgTextArea = new LabelMultiline(this, UIMsg.TO_MSG(""));
        this.descTextArea = new TextArea(this);
        this.descTextArea.setFocusable(true);
        this.descTextArea.setEditable(false);
        this.descTextArea.makeRecyclable();
        this.descTextArea.setRows(10);
        this.descTextArea.setColumns(25);
        this.detailBtn = new Button(this);
        this.detailBtn.addActionListener(this);
        this.add(this.msgTextArea, "textArea");
        this.add(this.detailBtn, "button");
        this.add(this.descTextArea, "desc");
        this.detailBtn.setIcon(Image.create(UIMsg.UP_ARROW));
        this.detailBtn.setMsg(UIMsg.DETAILS);
        layout.addConstraint("textArea", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint("textArea", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("textArea", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT));
        layout.addConstraint("button", AttributeType.TOP, new AttributeConstraint("textArea", AttributeType.BOTTOM));
        layout.addConstraint("button", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT));
        layout.addConstraint("desc", AttributeType.TOP, new AttributeConstraint("button", AttributeType.BOTTOM));
        layout.addConstraint("desc", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("desc", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT));
        layout.addConstraint("desc", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM));
    }
}

