/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.wizards.ui;

import oracle.bpm.geom.Insets;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.ui.layout.GridBagLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.peer.swing.SwingWizardSupport;

public class ButtonPanel
extends Panel {
    private Button backButton;
    private Button cancelButton;
    private Button finishButton;
    private Button nextButton;

    public ButtonPanel(UiContainer parent) {
        super(parent);
        this.setName("button.panel");
        this.setLayout(new GridBagLayout());
        this.setBorder(new SwingWizardSupport.LineBorder());
        Button helpButton = Button.createHelp(this);
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPanel.this.showHelp(ButtonPanel.this.getOwnerWindow().getHelpId());
            }
        });
        this.backButton = new Button(this);
        this.backButton.setText("< " + UIMsg.BACK.getString());
        this.backButton.setFont(this.backButton.getFont().plain());
        this.nextButton = new Button(this);
        this.nextButton.setText(CoreMsg.NEXT.getString() + " >");
        this.nextButton.setFont(this.nextButton.getFont().plain());
        this.finishButton = new Button(this);
        this.finishButton.setText(UIMsg.FINISH.getString());
        this.finishButton.setFont(this.finishButton.getFont().plain());
        this.cancelButton = new Button((UiContainer)this, UIMsg.CANCEL);
        this.cancelButton.setFont(this.cancelButton.getFont().plain());
        this.add(helpButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.backButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add(this.nextButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add(Box.createHorizontalStrut(this, 5), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add(this.finishButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add(this.cancelButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
    }

    public Button getBackButton() {
        return this.backButton;
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public Button getNextButton() {
        return this.nextButton;
    }

    public Button getFinishButton() {
        return this.finishButton;
    }
}

